import binascii
import subprocess
import tkinter as tk
import os
import time
import webbrowser
import urllib.request
import ssl
from tkinter import ttk
from tkinter import messagebox
from tkinter import filedialog
from sys import platform
from pathlib import Path

########################################################################
# Variables
########################################################################
BUILD = "251116"
VERSION = "v 3.27"
FIRMWARE = "unknown"
titel = "Voes MX Editor " + VERSION + " - build " + BUILD
windows = True
keyctrl = 0x04
keyshift = 0x01
path_bin = 'bin/'
path_templates = 'templates/'
path_mx = '/'
btnx = 20
btny = 45
if platform == "darwin":
    from applescript import tell
    windows = False
    keyshift = 0x03
    path_bin = os.path.dirname(os.path.realpath(__file__)) + '/bin/'
    path_templates = os.path.dirname(os.path.realpath(__file__)) + '/templates/'
    path_avr = os.path.dirname(os.path.realpath(__file__)) + '/avr/bin/'
    path_mx = os.path.expanduser("~/Documents/")
    cmdavr = path_avr + 'avrdude -C ' + path_avr + 'avrdude.conf -p m1284p -P usb -c usbasp -U '
    btnx = 20

# Global variables - if needed to change, use "global x" before changing x=?
MAX = 18
MAX2 = 36
MAX3 = 72
MAX4 = 76 # (36*2) + 4 sw2x
MAX5 = 84  # (36*2) + 4 sw2x + 8 abcd
knop = 0
knoplp = 0
knopcopypaste = 0
model = 36
preset = 0
pijl_exp = [True, True, True, False]  # exp1, exp2, exp3, sw2x
blocksavecurrentsettings = False
loaded_filename = None

if windows:
    kleur_front = "#EEEEEE"
    kleur_back = "#000000"
    kleur_grijs = "#333333"
    kleur_geel = "#FFCC00"
    kleur_btn_wit = "#DDDDDD"
    kleur_btn_front = "#EEEEEE"
    kleur_btn_back = "#000000"
    kleur_btn_grijs = "#333333"
    kleur_btn_geel = "#FFCC00"
    kleur_btn_active = "#444444"
    FONT = "Helvetica 10"
    FONT_BIG = "Helvetica 16 bold"
    FONT_MIDDLE = "Helvetica 14"
    FONT_TMPL = "Helvetica 12"
    FONT_TAB = "Helvetica 11 bold"
    FONT_KNOP = "Helvetica 10"
    FONT_KNOP_ITALIC = "Helvetica 10 italic"
    FONT_KNOP_NR = "Helvetica 9 bold"
    FONT_KNOP_MENU = "Helvetica 12"
    FONT_MODEL = "Helvetica 9 bold"
    FONT_MODEL_SELECTED = "Helvetica 9 bold"
    FONT_DRAGDROP = "Helvetica 9 bold"
    EASYPOSX = 0
else:
    kleur_front = "#EEEEEE"
    kleur_back = "#000000"
    kleur_grijs = "#333333"  # voorheen AAAAAA
    kleur_geel = "#FFCC00"
    kleur_btn_wit = "#999999"
    kleur_btn_front = "#000000"
    kleur_btn_back = "#EEEEEE"
    kleur_btn_grijs = "#333333"  # voorheen AAAAAA
    kleur_btn_geel = "#FFCC00"
    kleur_btn_active = "#444444"
    # FONT = "Monaco 12"
    # FONT_BIG = "Monaco 20 bold"
    # FONT_MIDDLE = "Monaco 16"
    # FONT_TMPL = "Monaco 14"
    # FONT_TAB = "Monaco 11 bold"
    # FONT_KNOP = "Monaco 12 bold"
    # FONT_KNOP_ITALIC = "Monaco 10 italic"
    # FONT_KNOP_NR = "Monaco 9 bold"
        # FONT_MODEL = "Monaco 9 bold"
    FONT = "Helvetica 14"
    FONT_BIG = "Helvetica 22"
    FONT_MIDDLE = "Helvetica 16"
    FONT_TMPL = "Helvetica 16"
    FONT_TAB = "Helvetica 14 bold"
    FONT_KNOP = "Helvetica 13"
    FONT_KNOP_ITALIC = "Helvetica 13 italic"
    FONT_KNOP_NR = "Helvetica 11 bold"
    FONT_KNOP_MENU = "Helvetica 16"
    FONT_MODEL = "Helvetica 13"
    FONT_MODEL_SELECTED = "Helvetica 13 bold underline"
    FONT_DRAGDROP = "Helvetica 12"
    EASYPOSX = 10

folder = ""
hexfile = "temp1284.hex"
newLines = []
easysetup = ''

kleuren = ['none', 'green', 'red', 'blue', 'purple', 'yellow', 'turquoise', 'white']
colors = ['#160900', '#2E8B57', '#CC0000', '#1E90FF', '#D200D2', '#FFCC00', "#40E0D0", kleur_btn_wit]

# Command Types
TYPE_NONE = 0
TYPE_PC = 1
TYPE_CCONOFF = 2
TYPE_CCOFFON = 3
TYPE_CCONONLY = 4
TYPE_CCOFFONLY = 5
TYPE_NOTEONOFF = 43
TYPE_NOTETRIGGER = 44
TYPE_CCVALUE = 6
TYPE_EXPR1SWAP = 7
TYPE_AUTO1SWAP = 8
TYPE_EXPR2SWAP = 9
TYPE_AUTO2SWAP = 10
TYPE_IAONOFF = 11
TYPE_ALLLEDSOFF = 12
TYPE_ONCOLOR = 13
TYPE_OFFCOLOR = 45
TYPE_BANKDOWN = 15
TYPE_BANKUP = 16
TYPE_BANKNUMBER = 64
TYPE_PRESETDOWN = 17
TYPE_PRESETUP = 18
TYPE_FAVORITEPRESET = 42
TYPE_SCENES = 14
TYPE_SCENEDOWN = 19
TYPE_SCENEUP = 20
TYPE_SCENE_AB = 63
TYPE_PRESETSELECT = 21
TYPE_BANKSELECT = 22
TYPE_PAGE_AB = 24
TYPE_PAGE_PRESETS = 46
TYPE_SAVE = 40
TYPE_TEXT = 65
TYPE_AFX12_PRESETS = 41
TYPE_AFX12_TUNER = 23
TYPE_AFX12_TEMPO = 33
TYPE_AFX3_PRESETS = 25
TYPE_AFX3_SCENES = 26
TYPE_AFX3_SCENEAB = 32
TYPE_AFX3_FXBLOCKS = 27
TYPE_AFX3_LOOPER = 28
TYPE_AFX3_TUNER = 29
TYPE_AFX3_TEMPO = 30
TYPE_AFX3_CHANNELS = 31
TYPE_KMPR_PERFORMANCE = 51
TYPE_KMPR_RIG = 52
TYPE_KMPR_STOMPFX = 53
TYPE_KMPR_ROTSPEED = 54
TYPE_KMPR_DLYFEEDBACK = 55
TYPE_KMPR_DLYHOLD = 56
TYPE_KMPR_TUNER = 57
TYPE_KMPR_TEMPO = 58
TYPE_KMPR_LOOPER = 59
TYPE_SYSEX = 61
TYPE_SYSEX_TOGGLE = 62
TYPE_NUMERICSELECT = 66
TYPE_CCONONLYLED = 67
TYPE_CHILD_IAONOFF = 68
TYPE_CHILD_PAGE_AB = 69
TYPE_AFX3_BLOCKCHANNEL = 70
TYPE_PAGE_NUMBER = 71  # voor MX-6x6
TYPE_CC_PLUS = 72
TYPE_CC_MIN = 73
TYPE_WAIT = 74
TYPE_HX_TUNER = 75
TYPE_HX_TEMPO = 76
TYPE_QC_TUNER = 77
TYPE_QC_TEMPO = 78
TYPE_HX_LOOPER = 79
TYPE_QC_LOOPER = 80
TYPE_EXPR3SWAP = 81
TYPE_PCI = 82
TYPE_MAX = 82

cmds1np = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("PC Independent", TYPE_PCI), ("CC On/Off", TYPE_CCONOFF),
           ("CC Off/On", TYPE_CCOFFON),
           ("CC On Only", TYPE_CCONONLY), ("CC On Only LED", TYPE_CCONONLYLED), ("CC Off Only", TYPE_CCOFFONLY),
           ("CC Value", TYPE_CCVALUE), ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
           ("Note On/Off", TYPE_NOTEONOFF), ("Note Trigger", TYPE_NOTETRIGGER),
           ("Exp 1 CC Swap", TYPE_EXPR1SWAP), ("Auto 1 On CC Swap", TYPE_AUTO1SWAP), ("Exp 2 CC Swap", TYPE_EXPR2SWAP),
           ("Auto 2 On CC Swap", TYPE_AUTO2SWAP), ("Exp 3 CC Swap", TYPE_EXPR3SWAP), ("IA On/Off", TYPE_IAONOFF),
           ("All Other LEDs Off", TYPE_ALLLEDSOFF), ("On Color", TYPE_ONCOLOR), ("Off Color", TYPE_OFFCOLOR),
           ("Bank Down", TYPE_BANKDOWN), ("Bank Up", TYPE_BANKUP), ("Bank Number", TYPE_BANKNUMBER),
           ("Preset Down", TYPE_PRESETDOWN), ("Preset Up", TYPE_PRESETUP), ("Favorite Preset", TYPE_FAVORITEPRESET),
           ("Scene/Snapshot", TYPE_SCENES), ("Scene/Snapshot Down", TYPE_SCENEDOWN),
           ("Scene/Snapshot Up", TYPE_SCENEUP), ("Scene/Snapshot A/B", TYPE_SCENE_AB),
           ("Preset Select", TYPE_PRESETSELECT), ("Bank Select", TYPE_BANKSELECT),
           ("Numeric Preset Select", TYPE_NUMERICSELECT), ("Save", TYPE_SAVE), ("Page A/B", TYPE_PAGE_AB),
           ("Page Presets", TYPE_PAGE_PRESETS), ("SysEx", TYPE_SYSEX),
           ("SysEx Toggle", TYPE_SYSEX_TOGGLE), ("== Axe-Fx Std/Ultra/II(XL+) ==", TYPE_NONE),
           ("AFX1/2 - Preset", TYPE_AFX12_PRESETS), ("AFX1/2 - Tuner", TYPE_AFX12_TUNER),
           ("AFX1/2 - Tempo", TYPE_AFX12_TEMPO), ("==   Axe-Fx III/FM3   ==", TYPE_NONE),
           ("AFX3/FM3 - Preset", TYPE_AFX3_PRESETS), ("AFX3/FM3 - Scene", TYPE_AFX3_SCENES),
           ("AFX3/FM3 - Scene A/B", TYPE_AFX3_SCENEAB), ("AFX3/FM3 - FX Block", TYPE_AFX3_FXBLOCKS),
           ("AFX3/FM3 - Channel", TYPE_AFX3_CHANNELS), ("AFX3/FM3 - Block & Ch.", TYPE_AFX3_BLOCKCHANNEL),
           ("AFX3/FM3 - Looper", TYPE_AFX3_LOOPER),
           ("AFX3/FM3 - Tuner", TYPE_AFX3_TUNER), ("AFX3/FM3 - Tempo", TYPE_AFX3_TEMPO),
           ("==   Kemper Profiler  ==", TYPE_NONE), ("KMPR - Performance", TYPE_KMPR_PERFORMANCE),
           ("KMPR - Rig", TYPE_KMPR_RIG), ("KMPR - Stomp & Fx", TYPE_KMPR_STOMPFX),
           ("KMPR - Rot. Speed", TYPE_KMPR_ROTSPEED), ("KMPR - Dly Feedback", TYPE_KMPR_DLYFEEDBACK),
           ("KMPR - Dly Hold", TYPE_KMPR_DLYHOLD), ("KMPR - Looper", TYPE_KMPR_LOOPER),
           ("KMPR - Tuner", TYPE_KMPR_TUNER), ("KMPR - Tempo", TYPE_KMPR_TEMPO),
           ("==   HX-Stomp/Helix   ==", TYPE_NONE), ("HX - Tuner", TYPE_HX_TUNER), ("HX - Tempo", TYPE_HX_TEMPO),
           ("HX - Looper", TYPE_HX_LOOPER), ("==     Quad Cortex    ==", TYPE_NONE), ("QC - Tuner", TYPE_QC_TUNER),
           ("QC - Tempo", TYPE_QC_TEMPO), ("QC - Looper", TYPE_QC_LOOPER)]

cmds1lp = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("PC Independent", TYPE_PCI), ("CC On/Off", TYPE_CCONOFF),
           ("CC Off/On", TYPE_CCOFFON),
           ("CC On Only", TYPE_CCONONLY), ("CC On Only LED", TYPE_CCONONLYLED), ("CC Off Only", TYPE_CCOFFONLY),
           ("CC Value", TYPE_CCVALUE), ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
           ("Note On/Off", TYPE_NOTEONOFF), ("Note Trigger", TYPE_NOTETRIGGER),
           ("Exp 1 CC Swap", TYPE_EXPR1SWAP), ("Auto 1 On CC Swap", TYPE_AUTO1SWAP), ("Exp 2 CC Swap", TYPE_EXPR2SWAP),
           ("Auto 2 On CC Swap", TYPE_AUTO2SWAP), ("Exp 3 CC Swap", TYPE_EXPR3SWAP), ("IA On/Off", TYPE_IAONOFF),
           ("All Other LEDs Off", TYPE_ALLLEDSOFF),
           ("On Color", TYPE_ONCOLOR), ("Off Color", TYPE_OFFCOLOR), ("Bank Down", TYPE_BANKDOWN),
           ("Bank Up", TYPE_BANKUP), ("Bank Number", TYPE_BANKNUMBER), ("Preset Down", TYPE_PRESETDOWN),
           ("Preset Up", TYPE_PRESETUP), ("Favorite Preset", TYPE_FAVORITEPRESET), ("Scene/Snapshot", TYPE_SCENES),
           ("Scene/Snapshot Down", TYPE_SCENEDOWN), ("Scene/Snapshot Up", TYPE_SCENEUP),
           ("Scene/Snapshot A/B", TYPE_SCENE_AB), ("Preset Select", TYPE_PRESETSELECT),
           ("Bank Select", TYPE_BANKSELECT), ("Numeric Preset Select", TYPE_NUMERICSELECT), ("Save", TYPE_SAVE),
           ("Page A/B", TYPE_PAGE_AB), ("Page Presets", TYPE_PAGE_PRESETS), ("SysEx", TYPE_SYSEX),
           ("SysEx Toggle", TYPE_SYSEX_TOGGLE), ("== Axe-Fx Std/Ultra/II(XL+) ==", TYPE_NONE),
           ("AFX1/2 - Preset", TYPE_AFX12_PRESETS), ("AFX1/2 - Tuner", TYPE_AFX12_TUNER),
           ("AFX1/2 - Tempo", TYPE_AFX12_TEMPO), ("==   Axe-Fx III/FM3   ==", TYPE_NONE),
           ("AFX3/FM3 - Preset", TYPE_AFX3_PRESETS), ("AFX3/FM3 - Scene", TYPE_AFX3_SCENES),
           ("AFX3/FM3 - Scene A/B", TYPE_AFX3_SCENEAB), ("AFX3/FM3 - FX Block", TYPE_AFX3_FXBLOCKS),
           ("AFX3/FM3 - Channel", TYPE_AFX3_CHANNELS), ("AFX3/FM3 - Block & Ch.", TYPE_AFX3_BLOCKCHANNEL),
           ("AFX3/FM3 - Tuner", TYPE_AFX3_TUNER), ("AFX3/FM3 - Tempo", TYPE_AFX3_TEMPO),
           ("==   Kemper Profiler  ==", TYPE_NONE), ("KMPR - Performance", TYPE_KMPR_PERFORMANCE),
           ("KMPR - Rig", TYPE_KMPR_RIG), ("KMPR - Stomp & Fx", TYPE_KMPR_STOMPFX),
           ("KMPR - Rot. Speed", TYPE_KMPR_ROTSPEED), ("KMPR - Dly Feedback", TYPE_KMPR_DLYFEEDBACK),
           ("KMPR - Dly Hold", TYPE_KMPR_DLYHOLD),
           ("KMPR - Tuner", TYPE_KMPR_TUNER), ("KMPR - Tempo", TYPE_KMPR_TEMPO),
           ("==   HX-Stomp/Helix   ==", TYPE_NONE), ("HX - Tuner", TYPE_HX_TUNER),
           ("==     Quad Cortex    ==", TYPE_NONE), ("QC - Tuner", TYPE_QC_TUNER)]

cmds26 = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("CC On/Off", TYPE_CCONOFF), ("CC Off/On", TYPE_CCOFFON),
          ("CC On Only", TYPE_CCONONLY), ("CC Off Only", TYPE_CCOFFONLY), ("CC Value", TYPE_CCVALUE),
          ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
          ("Note On/Off", TYPE_NOTEONOFF), ("Note Trigger", TYPE_NOTETRIGGER), ("Exp 1 CC Swap", TYPE_EXPR1SWAP),
          ("Auto 1 On CC Swap", TYPE_AUTO1SWAP), ("Exp 2 CC Swap", TYPE_EXPR2SWAP), ("Exp 3 CC Swap", TYPE_EXPR3SWAP),
          ("Auto 2 On CC Swap", TYPE_AUTO2SWAP), ("IA On/Off", TYPE_IAONOFF),
          ("All Other LEDs Off", TYPE_ALLLEDSOFF), ("On Color", TYPE_ONCOLOR), ("Off Color", TYPE_OFFCOLOR),
          ("Page A/B", TYPE_PAGE_AB), ("SysEx", TYPE_SYSEX), ("Text", TYPE_TEXT),
          ("Child - IA On/Off", TYPE_CHILD_IAONOFF), ("Child - Page A/B", TYPE_CHILD_PAGE_AB)]

cmdsexp = [("== Bank/Preset/Scene/Page ==", TYPE_NONE), ("Bank Down", TYPE_BANKDOWN), ("Bank Up", TYPE_BANKUP),
           ("Preset Down", TYPE_PRESETDOWN), ("Preset Up", TYPE_PRESETUP), ("Scene/Snapshot Down", TYPE_SCENEDOWN),
           ("Scene/Snapshot Up", TYPE_SCENEUP), ("Preset Select", TYPE_PRESETSELECT), ("Bank Select", TYPE_BANKSELECT),
           ("Numeric Preset Select", TYPE_NUMERICSELECT), ("Page A/B", TYPE_PAGE_AB),
           ("Page Presets", TYPE_PAGE_PRESETS), ("== Tempo ==", TYPE_NONE), ("AFX1/2 - Tempo (cc14)", TYPE_AFX12_TEMPO),
           ("AFX3/FM3 - Tempo", TYPE_AFX3_TEMPO), ("KMPR - Tempo (cc30)", TYPE_KMPR_TEMPO),
           ("== Buttons Normal Press ==", TYPE_NONE), ("IA 01 (Normal Press 01)", 101),
           ("IA 02 (Normal Press 02)", 102),
           ("IA 03 (Normal Press 03)", 103), ("IA 04 (Normal Press 04)", 104), ("IA 05 (Normal Press 05)", 105),
           ("IA 06 (Normal Press 06)", 106), ("IA 07 (Normal Press 07)", 107), ("IA 08 (Normal Press 08)", 108),
           ("IA 09 (Normal Press 09)", 109), ("IA 10 (Normal Press 10)", 110), ("IA 11 (Normal Press 11)", 111),
           ("IA 12 (Normal Press 12)", 112), ("IA 13 (Normal Press 13)", 113), ("IA 14 (Normal Press 14)", 114),
           ("IA 15 (Normal Press 15)", 115), ("IA 16 (Normal Press 16)", 116), ("IA 17 (Normal Press 17)", 117),
           ("IA 18 (Normal Press 18)", 118),
           ("== Buttons Long Press ==", TYPE_NONE), ("IA 19 (Long Press 01)", 119), ("IA 20 (Long Press 02)", 120),
           ("IA 21 (Long Press 03)", 121), ("IA 22 (Long Press 04)", 122), ("IA 23 (Long Press 05)", 123),
           ("IA 24 (Long Press 06)", 124), ("IA 25 (Long Press 07)", 125), ("IA 26 (Long Press 08)", 126),
           ("IA 27 (Long Press 09)", 127), ("IA 28 (Long Press 10)", 128), ("IA 29 (Long Press 11)", 129),
           ("IA 30 (Long Press 12)", 130), ("IA 31 (Long Press 13)", 131), ("IA 32 (Long Press 14)", 132),
           ("IA 33 (Long Press 15)", 133), ("IA 34 (Long Press 16)", 134), ("IA 35 (Long Press 17)", 135),
           ("IA 36 (Long Press 18)", 136)]

cmdssw2x = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("CC On/Off", TYPE_CCONOFF), ("CC Off/On", TYPE_CCOFFON),
            ("CC On Only", TYPE_CCONONLY), ("CC Off Only", TYPE_CCOFFONLY), ("CC Value", TYPE_CCVALUE),
            ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
            ("Exp 1 CC Swap", TYPE_EXPR1SWAP), ("Auto 1 On CC Swap", TYPE_AUTO1SWAP),
            ("Exp 2 CC Swap", TYPE_EXPR2SWAP), ("Auto 2 On CC Swap", TYPE_AUTO2SWAP),
            ("Exp 3 CC Swap", TYPE_EXPR3SWAP), ("Bank Down", TYPE_BANKDOWN),
            ("Bank Up", TYPE_BANKUP), ("Bank Number", TYPE_BANKNUMBER), ("Preset Down", TYPE_PRESETDOWN),
            ("Preset Up", TYPE_PRESETUP), ("Favorite Preset", TYPE_FAVORITEPRESET), ("Scene/Snapshot", TYPE_SCENES),
            ("Scene/Snapshot Down", TYPE_SCENEDOWN), ("Scene/Snapshot Up", TYPE_SCENEUP),
            ("Scene/Snapshot A/B", TYPE_SCENE_AB), ("Preset Select", TYPE_PRESETSELECT),
            ("Bank Select", TYPE_BANKSELECT), ("Save", TYPE_SAVE), ("Page A/B", TYPE_PAGE_AB),
            ("Page Presets", TYPE_PAGE_PRESETS), ("== Axe-Fx Std/Ultra/II(XL+) ==", TYPE_NONE),
            ("AFX1/2 - Preset", TYPE_AFX12_PRESETS), ("AFX1/2 - Tuner", TYPE_AFX12_TUNER),
            ("AFX1/2 - Tempo", TYPE_AFX12_TEMPO), ("==   Axe-Fx III/FM3   ==", TYPE_NONE),
            ("AFX3/FM3 - Preset", TYPE_AFX3_PRESETS), ("AFX3/FM3 - Scene", TYPE_AFX3_SCENES),
            ("AFX3/FM3 - Scene A/B", TYPE_AFX3_SCENEAB), ("AFX3/FM3 - FX Block", TYPE_AFX3_FXBLOCKS),
            ("AFX3/FM3 - Channel", TYPE_AFX3_CHANNELS), ("AFX3/FM3 - Block & Ch.", TYPE_AFX3_BLOCKCHANNEL),
            ("AFX3/FM3 - Tuner", TYPE_AFX3_TUNER), ("AFX3/FM3 - Tempo", TYPE_AFX3_TEMPO),
            ("==   Kemper Profiler  ==", TYPE_NONE), ("KMPR - Performance", TYPE_KMPR_PERFORMANCE),
            ("KMPR - Rig", TYPE_KMPR_RIG), ("KMPR - Stomp & Fx", TYPE_KMPR_STOMPFX),
            ("KMPR - Rot. Speed", TYPE_KMPR_ROTSPEED), ("KMPR - Dly Feedback", TYPE_KMPR_DLYFEEDBACK),
            ("KMPR - Dly Hold", TYPE_KMPR_DLYHOLD), ("KMPR - Tuner", TYPE_KMPR_TUNER),
            ("KMPR - Tempo", TYPE_KMPR_TEMPO)]

devices = [("Midi", 99), ("Axe-Fx Std", 0), ("Axe-Fx Ultra", 1), ("Axe-Fx II", 3), ("Axe-Fx II XL", 6),
           ("Axe-Fx II XL+", 7), ("Axe-Fx III", 10), ("FM3", 11), ("FM9", 12), ("Kemper", 20), ("Kemper Player", 23),
           ("HX Stomp", 21), ("Quad Cortex", 22)]

afx = [("None", 0), ("Input 1", 37), ("Input 2", 38), ("Input 3", 39), ("Input 4", 40), ("Input USB", 41),
       ("Output 1", 42), ("Output 2", 43), ("Output 3", 44), ("Output 4", 45), ("Amp 1", 58), ("Amp 2", 59),
       ("Cab 1", 62), ("Cab 2", 63), ("Amp+Cab1", 1), ("Chorus 1", 78), ("Chorus 2", 79), ("Comp 1", 46),
       ("Comp 2", 47), ("Comp 3", 48), ("Comp 4", 49), ("Crossover1", 142), ("Crossover2", 143), ("Delay 1", 70),
       ("Delay 2", 71), ("Delay 3", 72), ("Delay 4", 73), ("Drive 1", 118), ("Drive 2", 119), ("Drive 3", 120),
       ("Drive 4", 121), ("Enhancer1", 122), ("Enhancer2", 123), ("FB Return1", 186), ("FB Return2", 187),
       ("FB Send 1", 182), ("FB Send 2", 183), ("Filter 1", 114), ("Filter 2", 115), ("Filter 3", 116),
       ("Filter 4", 117), ("Flanger 1", 82), ("Flanger 2", 83), ("Formant 1", 98), ("Formant 2", 99), ("Gate 1", 146),
       ("Gate 2", 147), ("Gate 3", 148), ("Gate 4", 149), ("GEQ 1", 50), ("GEQ 2", 51), ("GEQ 3", 52), ("GEQ 4", 53),
       ("IR Player 1", 195), ("IR Player 2", 196), ("Looper", 166), ("Megatap 1", 138), ("Megatap 2", 139),
       ("Midi Block", 190), ("Mixer 1", 126), ("Mixer 2", 127), ("Mixer 3", 128), ("Mixer 4", 129), ("Multicmp1", 154),
       ("Multicmp2", 155), ("Multiplex 1", 191), ("Multiplex 2", 192), ("MultiDelay 1", 74), ("MultiDelay 2", 75),
       ("PEQ 1", 54), ("PEQ 2", 55), ("PEQ 3", 56), ("PEQ 4", 57), ("Phaser 1", 90), ("Phaser 2", 91), ("Pitch 1", 110),
       ("Pitch 2", 111), ("Plex Dly 1", 178), ("Plex Dly 2", 179), ("RTA", 174), ("Resonatr1", 162), ("Resonatr2", 163),
       ("Reverb 1", 66), ("Reverb 2", 67), ("Ring Mod", 150), ("Rotary 1", 86), ("Rotary 2", 87), ("Synth 1", 130),
       ("Synth 2", 131), ("10-Tap 1", 158), ("10-Tap 2", 159), ("ToneMatch", 170), ("Trem/Pan 1", 106),
       ("Trem/Pan 2", 107), ("Vocoder", 134), ("Volume 1", 102), ("Volume 2", 103), ("Volume 3", 104),
       ("Volume 4", 105), ("WahWah 1", 94), ("WahWah 2", 95)]

looperFractal = [("Record", 0), ("Play", 1), ("Undo", 2), ("Once", 3), ("Reverse", 4), ("Half", 5)]
looperKemper = [("Record", 0), ("Play", 1), ("Undo", 2), ("Reverse", 4), ("Half", 5), ("Erase", 6)]
looperHX = [("Rec/Dub", 0), ("Play", 1), ("Undo", 2), ("Once", 3), ("Reverse", 4), ("Half", 5)]
looperQC = [("Rec/Dub", 0), ("Play", 1), ("Undo", 2), ("One Shot", 3), ("Reverse", 4), ("Half", 5), ("Punch", 7),
            ("Duplicate", 8)]

stomps = [("A", 17), ("B", 18), ("C", 19), ("D", 20), ("X", 22), ("MOD", 24), ("DLY", 27), ("RVB", 29)]

channels = [("A", 80), ("B", 81), ("C", 82), ("D", 83), ("===", 0), ("A-B", 1), ("A-C", 2), ("A-D", 3), ("===", 0),
            ("B-A", 10), ("B-C", 12), ("B-D", 13), ("===", 0), ("C-A", 20), ("C-B", 21), ("C-D", 23), ("===", 0),
            ("D-A", 30), ("D-B", 31), ("D-C", 32), ("===", 0), ("NXT", 99)]

blockChannels = [("", 0), ("A", 80), ("B", 81), ("C", 82), ("D", 83)]

holdtypes = ["block", "once", "trigger-only", "hold"]

holdtypesshort = ["", "1", "T", "H"]

sysex = []
for i in range(168):
    sysex.append("00")

# normal press
cmds_text = [cmds1np]
for i in range(5):
    cmds_text.append(cmds26)
# long press
cmds_text.append(cmds1lp)
for i in range(5):
    cmds_text.append(cmds26)

x = 0
y = 0
button_position = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                   [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                   [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                   [10 + x, 90 + y], [90 + x, 90 + y], [170 + x, 90 + y], [250 + x, 90 + y],
                   [330 + x, 90 + y], [410 + x, 90 + y]]


########################################################################
# Classes
########################################################################
class Cmd:
    def __init__(self, type, cc, ch):
        self.type = type
        self.cc = cc
        self.ch = ch

    def prnt(self):
        print(self.type, self.cc, self.ch)


class IA:
    def __init__(self, name, cmd, glbl, steps, color, group, holdtype):
        self.name = name
        self.cmd = cmd
        self.glbl = glbl
        self.steps = steps
        self.color = color
        self.group = group
        self.holdtype = holdtype

    def prnt(self):
        print(self.name, self.cmd.prnt(), self.glbl, self.steps, self.color, self.group, self.holdtype)


class Preset:
    def __init__(self, name, ison, addpcnr, addcconoff):
        self.name = name
        self.ison = ison
        self.addpcnr = addpcnr
        self.addcconoff = addcconoff

    def prnt(self):
        print(self.name, self.ison)


# create IA's & Presets
ias = []
for i in range(MAX5):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
    cmds = []
    for j in range(6):
        cmd = Cmd(0, 1, 1)
        cmds.append(cmd)
    ia = IA('ia' + str(i + 1), cmds, False, False, 0, 0, 0)
    ias.append(ia)

presets = []
for i in range(100):
    isons = []
    for j in range(18):  # voorhen 22 = 18IAs + 4 Additional CC's
        isonn = 0
        isons.append(isonn)

    addpcnr = []
    for j in range(8):
        addpc = 1
        addpcnr.append(addpc)

    addcconoff = []
    for j in range(4):
        addcc = 0
        addcconoff.append(addcc)

    preset = Preset("Preset " + str(i + 1), isons, addpcnr, addcconoff)
    presets.append(preset)


########################################################################
# Functions
########################################################################
def on_drag_start(event):
    widget = event.widget
    widget.startX = event.x
    widget.startY = event.y


def on_drag_motion(event):
    widget = event.widget
    x = widget.winfo_x() - widget.startX + event.x
    y = widget.winfo_y() - widget.startY + event.y
    widget.place(x=x, y=y)


def on_drag_stop(event):
    global blocksavecurrentsettings
    widget = event.widget
    t = widget.index
    x1, y1, x2, y2 = widget.winfo_x(), widget.winfo_y(), widget.winfo_x() + widget.winfo_width(), \
                     widget.winfo_y() + widget.winfo_height()
    begin, end = 0, 18
    if t > 35:
        begin, end = 36, 54
    for i in range(begin, end):
        if button_knop[i] != widget:
            x3, y3, x4, y4 = button_knop[i].winfo_x(), button_knop[i].winfo_y(), \
                             button_knop[i].winfo_x() + button_knop[i].winfo_width(), \
                             button_knop[i].winfo_y() + button_knop[i].winfo_height()
            if x1 < x4 and x2 > x3 and y1 < y4 and y2 > y3:
                temp = ias[t]
                plus = 18
                temp2 = ias[t + plus]
                global blocksavecurrentsettings
                blocksavecurrentsettings = True

                if (event.state & keyshift) != 0:  # SHIFT key is pressed, copy color only
                    ias[i].color = ias[t].color
                    label_knop_name[i].config(fg=colors[ias[i].color])
                    ias[i + plus].color = ias[t + plus].color
                    label_knop_name[i + plus].config(fg=colors[ias[i + plus].color])

                elif (event.state & keyctrl) != 0:  # CTRl key is pressed, copy
                    # np
                    ias[i].name = ias[t].name
                    ias[i].color = ias[t].color
                    for j in range(6):
                        tmpType = int(ias[t].cmd[j].type)
                        tmpCc = int(ias[t].cmd[j].cc)
                        tmpCh = int(ias[t].cmd[j].ch)
                        ias[i].cmd[j].type = tmpType
                        ias[i].cmd[j].cc = tmpCc
                        ias[i].cmd[j].ch= tmpCh

                    ias[i].glbl = ias[t].glbl
                    ias[i].steps = ias[t].steps
                    ias[i].group = ias[t].group
                    label_knop_name[i].config(text=ias[i].name)
                    label_knop_name[i].config(fg=colors[ias[i].color])

                    # lp
                    ias[i + plus].name = ias[t + plus].name
                    ias[i + plus].color = ias[t + plus].color
                    for j in range(6):
                        tmpType = int(ias[t + plus].cmd[j].type)
                        tmpCc = int(ias[t + plus].cmd[j].cc)
                        tmpCh = int(ias[t + plus].cmd[j].ch)
                        ias[i + plus].cmd[j].type = tmpType
                        ias[i + plus].cmd[j].cc = tmpCc
                        ias[i + plus].cmd[j].ch= tmpCh

                    ias[i + plus].glbl = ias[t + plus].glbl
                    ias[i + plus].steps = ias[t + plus].steps
                    ias[i + plus].group = ias[t + plus].group
                    ias[i + plus].holdtype = ias[t + plus].holdtype
                    label_knop_name[i + plus].config(text=ias[i + plus].name)
                    label_knop_name[i + plus].config(fg=colors[ias[i + plus].color])
                    ht = ias[t + plus].holdtype
                    label_knop_holdtype[i + plus].config(text=holdtypesshort[ht])

                    # tab presets
                    if t < 36:
                        label_p_knop_name[i].config(text=ias[i].name)

                else:  # swap
                    ias[t] = ias[i]
                    label_knop_name[t].config(text=ias[t].name)
                    label_knop_name[t].config(fg=colors[ias[t].color])
                    ias[t + plus] = ias[i + plus]
                    label_knop_name[t + plus].config(text=ias[t + plus].name)
                    label_knop_name[t + plus].config(fg=colors[ias[t + plus].color])
                    ht = ias[t + plus].holdtype
                    label_knop_holdtype[t + plus].config(text=holdtypesshort[ht])
                    # tab presets
                    if t < 36:
                        label_p_knop_name[t].config(text=ias[t].name)

                    ias[i] = temp
                    label_knop_name[i].config(text=ias[i].name)
                    label_knop_name[i].config(fg=colors[ias[i].color])
                    ias[i + plus] = temp2
                    label_knop_name[i + plus].config(text=ias[i + plus].name)
                    label_knop_name[i + plus].config(fg=colors[ias[i + plus].color])
                    ht = ias[i + plus].holdtype
                    label_knop_holdtype[i + plus].config(text=holdtypesshort[ht])
                    # tab presets
                    if t < 36:
                        label_p_knop_name[i].config(text=ias[i].name)

                blocksavecurrentsettings = True
                press_button(i)
                blocksavecurrentsettings = False
                break
    if t > 35:
        widget.place(x=button_position[t - 36][0] + btnx, y=button_position[t - 36][1] + btny)
    else:
        widget.place(x=button_position[t][0] + btnx, y=button_position[t][1] + btny)


def prefix_changed():
    for i in range(8):
        if i < var_prefix.get():
            entry_sysex[i + 160].place(y=40)
        else:
            entry_sysex[i + 160].place(y=-1400)


def checkbutton_double_changed():
    for i in range(10, 20):
        if var_double.get() == 0:
            label_sysex[i].config(text=i + 1)
        else:
            label_sysex[i].config(text="+")


def checkbutton_presets_add_usethis_changed():
    if var_presets_add_usethis.get() == 1:
        frame_hide_presets_add.place(width=0, height=0)
        listbox_presets.delete(0, tk.END)
        for i in range(50):
            listbox_presets.insert(tk.END, str(i + 1) + ' ' + presets[i].name)
        spinbox_preset.config(to=50)
    else:
        frame_hide_presets_add.place(width=230, height=380)
        listbox_presets.delete(0, tk.END)
        for i in range(100):
            listbox_presets.insert(tk.END, str(i + 1) + ' ' + presets[i].name)
        spinbox_preset.config(to=100)


def checkbutton_presets_add_onoff_changed(nr, ispc):  # add preset on/off
    if ispc is True:
        if var_presets_add_pc_onoff[nr].get() == 1:
            # show all items
            label_presets_add_pc_tekst[nr].place(x=65)
            spinbox_presets_add_pc_nr[nr].place(x=17)
            spinbox_presets_add_pc_ch[nr].place(x=170)
        else:
            var_presets_add_pc_ch[nr].set(0)
            # hide all items
            label_presets_add_pc_tekst[nr].place(x=-1075)
            spinbox_presets_add_pc_nr[nr].place(x=-1017)
            spinbox_presets_add_pc_ch[nr].place(x=-10185)
    else:
        if var_presets_add_cc_onoff[nr].get() == 1:
            # show all items
            label_presets_add_cc_tekst[nr].place(x=65)
            spinbox_presets_add_cc_ch[nr].place(x=170)
            spinbox_presets_add_cc_cc[nr].place(x=120)
            button_presets_add_cc[nr].place(x=17)
        else:
            var_presets_add_cc_ch[nr].set(0)
            # hide all items
            label_presets_add_cc_tekst[nr].place(x=-1075)
            spinbox_presets_add_cc_ch[nr].place(x=-10185)
            spinbox_presets_add_cc_cc[nr].place(x=-10125)
            button_presets_add_cc[nr].place(x=-1017)


def button_presets_add_pressed(nr):  # per preset CC on/off
    if presets[preset].addcconoff[nr] == 1:
        presets[preset].addcconoff[nr] = 0
        button_presets_add_cc[nr].config(bg=kleur_btn_back)
        label_presets_add_cc_tekst[nr].config(bg=kleur_grijs, fg=kleur_front)
    else:
        presets[preset].addcconoff[nr] = 1
        button_presets_add_cc[nr].config(bg=kleur_btn_geel)
        label_presets_add_cc_tekst[nr].config(bg=kleur_btn_geel, fg=kleur_back)


def is_hex(s):
    try:
        int(s, 16)
        return True
    except ValueError:
        return False


def enter_sysex(event, nr):
    t = entry_sysex[nr].get()
    t = t[0:2]
    t = t.upper()
    if is_hex(t) is False:
        t = "00"
    entry_sysex[nr].delete(0, 'end')
    entry_sysex[nr].insert(0, t)
    sysex[nr] = t


def enter_name(event, isnp, issw2x, nr):
    if issw2x is True:
        t = entry_name_sw2x[nr].get()
        t = t[0:8]
        entry_name_sw2x[nr].delete(8, 'end')
        ias[72 + nr].name = t
    else:
        if isnp is True:
            t = entry_name_np.get()
            t = t[0:8]
            entry_name_np.delete(8, 'end')
            if knop < 19:
                label_knop_name[knop]['text'] = t
                label_p_knop_name[knop]['text'] = t
            ias[knop].name = t
        else:
            t = entry_name_lp.get()
            t = t[0:8]
            entry_name_lp.delete(8, 'end')
            if knop < 19:
                label_knop_name[knoplp]['text'] = t
            ias[knoplp].name = t


def kleur_changed(event, isnp):
    if knop > MAX3:
        return
    caller = event.widget
    index = caller.current()
    if isnp is True:
        label_kleurkleur_np.config(bg=colors[index])
        ias[knop].color = index
        label_knop_name[knop].config(fg=colors[index])
    else:
        label_kleurkleur_lp.config(bg=colors[index])
        ias[knop + MAX].color = index
        label_knop_name[knop + MAX].config(fg=colors[index])


def checkbutton_changed(isnp, type):
    if isnp is True:
        if type == 1:
            ias[knop].glbl = var_np_glbl.get()
        elif type == 2:
            ias[knop].steps = var_np_steps.get()
    else:
        if type == 1:
            ias[knop + MAX].glbl = var_lp_glbl.get()
        elif type == 2:
            ias[knop + MAX].steps = var_lp_steps.get()


def checkbutton_autoexp(nr):
    if nr == 1:
        if var_exp1_auto_onoff.get() == 0:
            spinbox_auto1_cc.place(x=-1400)
            spinbox_auto1_ch.place(x=-2000)
            var_auto1_cc.set(0)
        else:
            spinbox_auto1_cc.place(x=140)
            spinbox_auto1_ch.place(x=200)
    elif nr == 2:
        if var_exp2_auto_onoff.get() == 0:
            spinbox_auto2_cc.place(x=-1400)
            spinbox_auto2_ch.place(x=-2000)
            var_auto2_cc.set(0)
        else:
            spinbox_auto2_cc.place(x=140)
            spinbox_auto2_ch.place(x=200)


def group_changed(isnp, grp):
    if isnp is True:
        ias[knop].group = var_np_group.get()
        changeColorGroup(True, grp)
    else:
        ias[knop + MAX].group = var_lp_group.get()
        changeColorGroup(False, grp)


def changeColorGroup(isnp, grp):
    if isnp is True:
        radiobutton_np_group1.config(bg=kleur_back)
        radiobutton_np_group2.config(bg=kleur_back)
        radiobutton_np_group3.config(bg=kleur_back)
        radiobutton_np_group4.config(bg=kleur_back)
        if grp > 0 and grp < 5:
            if grp == 1:
                radiobutton_np_group1.config(bg=kleur_geel)
            elif grp == 2:
                radiobutton_np_group2.config(bg=kleur_geel)
            elif grp == 3:
                radiobutton_np_group3.config(bg=kleur_geel)
            elif grp == 4:
                radiobutton_np_group4.config(bg=kleur_geel)
    else:
        radiobutton_lp_group1.config(bg=kleur_back)
        radiobutton_lp_group2.config(bg=kleur_back)
        radiobutton_lp_group3.config(bg=kleur_back)
        radiobutton_lp_group4.config(bg=kleur_back)
        if grp > 0 and grp < 5:
            if grp == 1:
                radiobutton_lp_group1.config(bg=kleur_geel)
            elif grp == 2:
                radiobutton_lp_group2.config(bg=kleur_geel)
            elif grp == 3:
                radiobutton_lp_group3.config(bg=kleur_geel)
            elif grp == 4:
                radiobutton_lp_group4.config(bg=kleur_geel)


def holdtype_changed(event):
    caller = event.widget
    index = caller.current()
    ias[knoplp].holdtype = index
    label_knop_holdtype[knoplp].config(text=holdtypesshort[index])


def extendclone_changed(event):
    caller = event.widget
    index = caller.current()
    if index > 0:
        var_global_ignore_pc.set(1)


def adjust_layout_ccch(cmdNr, nr, issw2x):  # nr -> 0-5 Normal Press en 6-11 Long Press
    if issw2x is True:
        label_sw2x_cc[nr].config(text='cc')
        label_sw2x_ch[nr].config(text='ch')
        label_sw2x_cc[nr].place(x=190)
        label_sw2x_ch[nr].place(x=265)
        spinbox_sw2x_cc[nr].place(x=210)
        spinbox_sw2x_cc[nr].config(to=127)
        spinbox_sw2x_ch[nr].place(x=285)
        spinbox_sw2x_ch[nr].config(to=16)
        combobox_sw2x_afx[nr].place(x=-500)
        combobox_sw2x_special[nr].place(x=-500)

        if cmdNr == TYPE_NONE or cmdNr == TYPE_ALLLEDSOFF or cmdNr == TYPE_BANKDOWN or cmdNr == TYPE_BANKUP or \
                cmdNr == TYPE_PRESETDOWN or cmdNr == TYPE_PRESETUP or cmdNr == TYPE_SCENEDOWN or \
                cmdNr == TYPE_SCENEUP or cmdNr == TYPE_PRESETSELECT or cmdNr == TYPE_BANKSELECT or \
                cmdNr == TYPE_PAGE_AB or cmdNr == TYPE_PAGE_PRESETS or cmdNr == TYPE_SAVE or \
                cmdNr == TYPE_AFX12_TUNER or cmdNr == TYPE_AFX12_TEMPO or cmdNr == TYPE_AFX3_TUNER or \
                cmdNr == TYPE_AFX3_TEMPO or cmdNr == TYPE_KMPR_ROTSPEED or cmdNr == TYPE_KMPR_DLYFEEDBACK or \
                cmdNr == TYPE_KMPR_DLYHOLD or cmdNr == TYPE_KMPR_TUNER or cmdNr == TYPE_KMPR_TEMPO or \
                cmdNr == TYPE_NUMERICSELECT or cmdNr == TYPE_CHILD_PAGE_AB or cmdNr == TYPE_WAIT or \
                cmdNr == TYPE_HX_TEMPO or cmdNr == TYPE_HX_TUNER or cmdNr == TYPE_QC_TEMPO or cmdNr == TYPE_QC_TUNER:
            label_sw2x_cc[nr].config(text='')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].place(x=-200)
            spinbox_sw2x_ch[nr].place(x=-280)
        elif cmdNr == TYPE_PC or cmdNr == TYPE_PCI or cmdNr == TYPE_FAVORITEPRESET:
            label_sw2x_cc[nr].config(text='pc')
        elif cmdNr == TYPE_NOTEONOFF or cmdNr == TYPE_NOTETRIGGER:
            label_sw2x_cc[nr].config(text='#')
        elif cmdNr == TYPE_CCVALUE or cmdNr == TYPE_CC_MIN or cmdNr == TYPE_CC_PLUS:
            label_sw2x_cc[nr].config(text='cc')
            label_sw2x_ch[nr].config(text='#')
            spinbox_ch[nr].config(to=127)
        elif cmdNr == TYPE_IAONOFF or cmdNr == TYPE_CHILD_IAONOFF:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=36)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_BANKNUMBER:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=99)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENES or cmdNr == TYPE_AFX3_SCENES:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=8)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENE_AB or cmdNr == TYPE_AFX3_SCENEAB:
            label_sw2x_cc[nr].config(text='A')
            label_sw2x_ch[nr].config(text='B')
            spinbox_sw2x_cc[nr].config(to=8)
            spinbox_sw2x_ch[nr].config(to=8)
        elif cmdNr == TYPE_TEXT:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=100)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_AFX12_PRESETS:
            label_sw2x_cc[nr].config(text='pc')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=512)
            spinbox_sw2x_ch[nr].place(x=-280)
        elif cmdNr == TYPE_AFX3_PRESETS:
            label_sw2x_cc[nr].config(text='pc')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=1024)
            spinbox_sw2x_ch[nr].place(x=-280)
        elif cmdNr == TYPE_KMPR_PERFORMANCE:
            label_sw2x_cc[nr].config(text='pc')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=125)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_KMPR_RIG:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=5)
            spinbox_sw2x_ch[nr].place(x=-280)
        elif cmdNr == TYPE_SYSEX or cmdNr == TYPE_SYSEX_TOGGLE:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=20)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_ONCOLOR or cmdNr == TYPE_OFFCOLOR:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].place(x=-265)
            spinbox_sw2x_cc[nr].place(x=-210)
            spinbox_sw2x_ch[nr].place(x=-285)
            combobox_sw2x_special[nr].place(x=210)
            combobox_sw2x_special[nr]['values'] = kleuren
            combobox_sw2x_special[nr].current(ias[knop + plus].cmd[y].cc)
        elif cmdNr == TYPE_AFX3_FXBLOCKS:
            label_sw2x_cc[nr].place(x=-285)
            label_sw2x_ch[nr].place(x=-265)
            spinbox_sw2x_cc[nr].place(x=-210)
            spinbox_sw2x_ch[nr].place(x=-285)
            combobox_sw2x_afx[nr].place(x=185, width=125)
            x = getIndex(afx, ias[nr].cmd[0].cc)
            combobox_sw2x_afx[nr].current(x)
        elif cmdNr == TYPE_AFX3_CHANNELS:
            label_sw2x_cc[nr].place(x=-285)
            label_sw2x_ch[nr].place(x=-265)
            spinbox_sw2x_cc[nr].place(x=-210)
            spinbox_sw2x_ch[nr].place(x=-285)
            combobox_sw2x_afx[nr].place(x=185, width=80)
            x = getIndex(afx, ias[nr].cmd[0].cc)
            combobox_sw2x_afx[nr].current(x)
            combobox_sw2x_special[nr].place(x=270)
            combobox_sw2x_special[nr]['values'] = [x[0] for x in channels]
            x = getIndex(channels, ias[nr].cmd[0].ch)
            combobox_sw2x_special[nr].current(x)
        elif cmdNr == TYPE_AFX3_BLOCKCHANNEL:
            label_sw2x_cc[nr].place(x=-285)
            label_sw2x_ch[nr].place(x=-265)
            spinbox_sw2x_cc[nr].place(x=-210)
            spinbox_sw2x_ch[nr].place(x=-285)
            combobox_sw2x_afx[nr].place(x=185, width=80)
            x = getIndex(afx, ias[nr].cmd[0].cc)
            combobox_sw2x_afx[nr].current(x)
            combobox_sw2x_special[nr].place(x=270)
            combobox_sw2x_special[nr]['values'] = [x[0] for x in blockChannels]
            x = getIndex(blockChannels, ias[nr].cmd[0].ch)
            combobox_sw2x_special[nr].current(x)
        elif cmdNr == TYPE_KMPR_STOMPFX:
            label_sw2x_cc[nr].place(x=-285)
            label_sw2x_ch[nr].place(x=-265)
            spinbox_sw2x_cc[nr].place(x=-210)
            spinbox_sw2x_ch[nr].place(x=-285)
            combobox_sw2x_special[nr].place(x=210)
            combobox_sw2x_special[nr]['values'] = values = [x[0] for x in stomps]
            x = getIndex(stomps, ias[nr].cmd[0].cc)
            combobox_sw2x_special[nr].current(x)
    else:
        if nr < 6:
            plus = 0
            y = nr
        else:
            plus = knoplp - knop
            y = nr - 6

        label_cc[nr].config(text='cc')
        label_ch[nr].config(text='ch')
        label_cc[nr].place(x=190)
        label_ch[nr].place(x=265)
        spinbox_cc[nr].place(x=210)
        spinbox_cc[nr].config(to=127)
        spinbox_ch[nr].place(x=285)
        spinbox_ch[nr].config(to=16)
        combobox_afx[nr].place(x=-500)
        combobox_special[nr].place(x=-500)

        if cmdNr == TYPE_NONE or cmdNr == TYPE_ALLLEDSOFF or cmdNr == TYPE_BANKDOWN or cmdNr == TYPE_BANKUP or \
                cmdNr == TYPE_PRESETDOWN or cmdNr == TYPE_PRESETUP or cmdNr == TYPE_SCENEDOWN or \
                cmdNr == TYPE_SCENEUP or cmdNr == TYPE_PRESETSELECT or cmdNr == TYPE_BANKSELECT or \
                cmdNr == TYPE_PAGE_AB or cmdNr == TYPE_PAGE_PRESETS or cmdNr == TYPE_SAVE or \
                cmdNr == TYPE_AFX12_TUNER or cmdNr == TYPE_AFX12_TEMPO or cmdNr == TYPE_AFX3_TUNER or \
                cmdNr == TYPE_AFX3_TEMPO or cmdNr == TYPE_KMPR_ROTSPEED or cmdNr == TYPE_KMPR_DLYFEEDBACK or \
                cmdNr == TYPE_KMPR_DLYHOLD or cmdNr == TYPE_KMPR_TUNER or cmdNr == TYPE_KMPR_TEMPO or \
                cmdNr == TYPE_NUMERICSELECT or cmdNr == TYPE_CHILD_PAGE_AB or cmdNr == TYPE_WAIT or \
                cmdNr == TYPE_HX_TEMPO or cmdNr == TYPE_HX_TUNER or cmdNr == TYPE_QC_TEMPO or cmdNr == TYPE_QC_TUNER:
            label_cc[nr].config(text='')
            label_ch[nr].config(text='')
            spinbox_cc[nr].place(x=-200)
            spinbox_ch[nr].place(x=-280)
        elif cmdNr == TYPE_PC or cmdNr == TYPE_PCI or cmdNr == TYPE_FAVORITEPRESET:
            label_cc[nr].config(text='pc')
        elif cmdNr == TYPE_NOTEONOFF or cmdNr == TYPE_NOTETRIGGER:
            label_cc[nr].config(text='#')
        elif cmdNr == TYPE_CCVALUE or cmdNr == TYPE_CC_MIN or cmdNr == TYPE_CC_PLUS:
            label_cc[nr].config(text='cc')
            label_ch[nr].config(text='#')
            spinbox_ch[nr].config(to=127)
        elif cmdNr == TYPE_IAONOFF or cmdNr == TYPE_CHILD_IAONOFF:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=36)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_BANKNUMBER:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=99)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENES or cmdNr == TYPE_AFX3_SCENES:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=8)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENE_AB or cmdNr == TYPE_AFX3_SCENEAB:
            label_cc[nr].config(text='A')
            label_ch[nr].config(text='B')
            spinbox_cc[nr].config(to=8)
            spinbox_ch[nr].config(to=8)
        elif cmdNr == TYPE_TEXT:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=100)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_AFX12_PRESETS:
            label_cc[nr].config(text='pc')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=512)
            spinbox_ch[nr].place(x=-280)
        elif cmdNr == TYPE_AFX3_PRESETS:
            label_cc[nr].config(text='pc')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=1024)
            spinbox_ch[nr].place(x=-280)
        elif cmdNr == TYPE_KMPR_PERFORMANCE:
            label_cc[nr].config(text='pc')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=125)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_KMPR_RIG:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=5)
            spinbox_ch[nr].place(x=-280)
        elif cmdNr == TYPE_SYSEX or cmdNr == TYPE_SYSEX_TOGGLE:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=20)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_ONCOLOR or cmdNr == TYPE_OFFCOLOR:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_special[nr].place(x=210)
            combobox_special[nr]['values'] = kleuren
            combobox_special[nr].current(ias[knop + plus].cmd[y].cc)
        elif cmdNr == TYPE_AFX3_FXBLOCKS:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_afx[nr].place(x=185, width=125)
            x = getIndex(afx, ias[knop + plus].cmd[y].cc)
            combobox_afx[nr].current(x)
        elif cmdNr == TYPE_AFX3_CHANNELS:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_afx[nr].place(x=185, width=80)
            x = getIndex(afx, ias[knop + plus].cmd[y].cc)
            combobox_afx[nr].current(x)
            combobox_special[nr].place(x=270)
            combobox_special[nr]['values'] = [x[0] for x in channels]
            x = getIndex(channels, ias[knop + plus].cmd[y].ch)
            combobox_special[nr].current(x)
        elif cmdNr == TYPE_AFX3_BLOCKCHANNEL:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_afx[nr].place(x=185, width=80)
            x = getIndex(afx, ias[knop + plus].cmd[y].cc)
            combobox_afx[nr].current(x)
            combobox_special[nr].place(x=270)
            combobox_special[nr]['values'] = [x[0] for x in blockChannels]
            x = getIndex(blockChannels, ias[knop + plus].cmd[y].ch)
            combobox_special[nr].current(x)
        elif cmdNr == TYPE_AFX3_LOOPER or cmdNr == TYPE_KMPR_LOOPER or cmdNr == TYPE_HX_LOOPER or \
            cmdNr == TYPE_QC_LOOPER:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_special[nr].place(x=210)
            if cmdNr == TYPE_AFX3_LOOPER:
                looper = looperFractal
            elif cmdNr == TYPE_KMPR_LOOPER:
                looper = looperKemper
            elif cmdNr == TYPE_HX_LOOPER:
                looper = looperHX
            elif cmdNr == TYPE_QC_LOOPER:
                looper = looperQC

            combobox_special[nr]['values'] = [x[0] for x in looper]
            x = getIndex(looper, ias[knop + plus].cmd[y].cc)
            combobox_special[nr].current(x)

            # loopercmd = ias[knop + plus].cmd[y].cc
            # print(loopercmd, len(looper))
            # if loopercmd > len(looper) - 1:
            #     loopercmd = 0
            #     ias[knop + plus].cmd[y].cc = loopercmd
            # combobox_special[nr].current(loopercmd)
        elif cmdNr == TYPE_KMPR_STOMPFX:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_special[nr].place(x=210)
            combobox_special[nr]['values'] = values = [x[0] for x in stomps]
            x = getIndex(stomps, ias[knop + plus].cmd[y].cc)
            combobox_special[nr].current(x)


def cmd_changed(event, nr, issw2x):
    caller = event.widget
    tekst = caller.get()
    if issw2x is True:
        cmdNr = getNumber(cmds1np, tekst)
        ias[MAX3 + nr].cmd[0].type = cmdNr
        # ias[MAX3 + nr].cmd[0].cc = 0
        # ias[MAX3 + nr].cmd[0].ch = 0
        adjust_layout_ccch(cmdNr, nr, True)
    else:
        if nr < 6:
            plus = 0
            y = nr
        else:
            plus = knoplp - knop
            y = nr - 6
        if nr == 0:
            cmdNr = getNumber(cmds1np, tekst)
        elif nr == 6:
            cmdNr = getNumber(cmds1lp, tekst)
        else:
            cmdNr = getNumber(cmds26, tekst)

        ias[knop + plus].cmd[y].type = cmdNr
        # ias[knop + plus].cmd[y].cc = 0
        # ias[knop + plus].cmd[y].ch = 0
        adjust_layout_ccch(cmdNr, nr, False)


def cch_changed(is_cc, nr, issw2x):
    if issw2x is True:
        if is_cc is True:
            ias[MAX3 + nr].cmd[0].cc = int(spinbox_sw2x_cc[nr].get())
        else:
            ias[MAX3 + nr].cmd[0].ch = int(spinbox_sw2x_ch[nr].get())
    else:
        if nr < 6:
            plus = 0
            y = nr
        else:
            plus = knoplp - knop
            y = nr - 6
        if is_cc is True:
            ias[knop + plus].cmd[y].cc = int(spinbox_cc[nr].get())
        else:
            ias[knop + plus].cmd[y].ch = int(spinbox_ch[nr].get())


def afx_changed(event, nr):
    if nr < 6:
        plus = 0
        y = nr
    else:
        plus = knoplp - knop
        y = nr - 6
    caller = event.widget
    tekst = caller.get()
    ias[knop + plus].cmd[y].cc = getNumber(afx, tekst)


def special_changed(event, nr, issw2x):
    caller = event.widget
    tekst = caller.get()
    if issw2x is True:
        cmd = ias[MAX3 + nr].cmd[0].type
        if cmd == TYPE_AFX3_CHANNELS:
            ias[MAX3 + nr].cmd[0].ch = getNumber(channels, tekst)
        elif cmd == TYPE_AFX3_BLOCKCHANNEL:
            ias[MAX3 + nr].cmd[0].ch = getNumber(blockchannels, tekst)
        elif cmd == TYPE_KMPR_STOMPFX:
            ias[MAX3 + nr].cmd[0].cc = getNumber(stomps, tekst)
    else:
        if nr < 6:
            plus = 0
            y = nr
        else:
            plus = knoplp - knop
            y = nr - 6
        cmd = ias[knop + plus].cmd[y].type
        if cmd == TYPE_ONCOLOR or cmd == TYPE_OFFCOLOR:
            ias[knop + plus].cmd[y].cc = kleuren.index(tekst)

        elif cmd == TYPE_AFX3_LOOPER:
            ias[knop + plus].cmd[y].cc = getNumber(looperFractal, tekst)

        elif cmd == TYPE_KMPR_LOOPER:
            ias[knop + plus].cmd[y].cc = getNumber(looperKemper, tekst)

        elif cmd == TYPE_HX_LOOPER:
            ias[knop + plus].cmd[y].cc = getNumber(looperHX, tekst)

        elif cmd == TYPE_QC_LOOPER:
            ias[knop + plus].cmd[y].cc = getNumber(looperQC, tekst)

        elif cmd == TYPE_AFX3_CHANNELS:
            ias[knop + plus].cmd[y].ch = getNumber(channels, tekst)

        elif cmd == TYPE_AFX3_BLOCKCHANNEL:
            ias[knop + plus].cmd[y].ch = getNumber(blockChannels, tekst)

        elif cmd == TYPE_KMPR_STOMPFX:
            ias[knop + plus].cmd[y].cc = getNumber(stomps, tekst)


def change_model(mdl):
    global model
    model = mdl
    if windows:
        x = -5
        y = 0
        xp = 5
        yp = 0
    else:
        x = 10
        y = -25
        xp = -15
        yp = 35
    button_position_mx5 = [[40 + x, 330 + y], [120 + x, 330 + y], [200 + x, 330 + y], [280 + x, 330 + y],
                           [360 + x, 330 + y], [-100, -100], [-100, -100], [-100, -100], [-100, -100],
                           [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100],
                           [-100, -100], [-100, -100], [-100, -100]]

    button_position_mx6 = [[120 + x, 330 + y], [200 + x, 330 + y], [280 + x, 330 + y], [120 + x, 210 + y],
                           [200 + x, 210 + y], [280 + x, 210 + y], [-100, -100], [-100, -100], [-100, -100],
                           [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100],
                           [-100, -100], [-100, -100], [-100, -100]]

    button_position_mx9 = [[120 + x, 330 + y], [200 + x, 330 + y], [280 + x, 330 + y], [120 + x, 210 + y],
                           [200 + x, 210 + y], [280 + x, 210 + y], [120 + x, 90 + y], [200 + x, 90 + y],
                           [280 + x, 90 + y], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100],
                           [-100, -100], [-100, -100], [-100, -100], [-100, -100]]

    button_position_mx1234 = [[90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y], [330 + x, 330 + y],
                              [90 + x, 210 + y], [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y],
                              [90 + x, 90 + y], [170 + x, 90 + y], [250 + x, 90 + y], [330 + x, 90 + y],
                              [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100]]

    button_position_mx1226 = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                              [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                              [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                              [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100]]

    button_position_mx18 = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                            [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                            [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                            [10 + x, 90 + y], [90 + x, 90 + y], [170 + x, 90 + y], [250 + x, 90 + y],
                            [330 + x, 90 + y], [410 + x, 90 + y]]

    if windows:
        button_position_mx16 = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                               [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                               [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                               [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100]]

        button_position_mx22 = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                                [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                                [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                                [10 + x, 90 + y], [90 + x, 90 + y], [170 + x, 90 + y], [250 + x, 90 + y],
                                [330 + x, 90 + y], [410 + x, 90 + y]]
    else:
        button_position_mx16 = [[10 + x, 330 + y], [90 + x, 330 + y], [170 + x, 330 + y], [250 + x, 330 + y],
                               [330 + x, 330 + y], [410 + x, 330 + y], [10 + x, 210 + y], [90 + x, 210 + y],
                               [170 + x, 210 + y], [250 + x, 210 + y], [330 + x, 210 + y], [410 + x, 210 + y],
                               [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100], [-100, -100]]

        button_position_mx22 = [[10 + x, 360 + y], [90 + x, 360 + y], [170 + x, 360 + y], [250 + x, 360 + y],
                                [330 + x, 360 + y], [410 + x, 360 + y], [10 + x, 240 + y], [90 + x, 240 + y],
                                [170 + x, 240 + y], [250 + x, 240 + y], [330 + x, 240 + y], [410 + x, 240 + y],
                                [10 + x, 120 + y], [90 + x, 120 + y], [170 + x, 120 + y], [250 + x, 120 + y],
                                [330 + x, 120 + y], [410 + x, 120 + y]]

    if windows:
        kleur_btn_act_back = kleur_btn_geel
        kleur_btn_act_front = kleur_btn_back
    else:
        kleur_btn_act_back = kleur_btn_geel
        kleur_btn_act_front = kleur_btn_front

    # All buttons bg=kleur_back and fg=wit
    button_mx5.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)
    button_mx6.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)
    button_mx9.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)
    button_mx1234.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)
    button_mx1226.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)
    button_mx18.config(bg=kleur_btn_back, highlightbackground=kleur_btn_back, fg=kleur_btn_front, font=FONT_MODEL)

    frame_knop_abcd.place(x=-1650, y=3, height=80, width=315)

    ismx12118 = True
    global button_position
    if model == 15:
        ismx12118 = False
        button_position = button_position_mx5
        button_mx5.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back, fg=kleur_btn_act_front,
                          font=FONT_MODEL_SELECTED)
    if model == 23:
        ismx12118 = False
        button_position = button_position_mx6
        button_mx6.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back,
                          fg=kleur_btn_act_front, font=FONT_MODEL_SELECTED)
    if model == 33:
        ismx12118 = False
        button_position = button_position_mx9
        button_mx9.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back,
                          fg=kleur_btn_act_front, font=FONT_MODEL_SELECTED)
    if model == 34:
        button_position = button_position_mx1234
        button_mx1234.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back,
                             fg=kleur_btn_act_front, font=FONT_MODEL_SELECTED)
    if model == 26:
        button_position = button_position_mx1226
        button_mx1226.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back,
                             fg=kleur_btn_act_front, font=FONT_MODEL_SELECTED)
    if model == 36:
        button_position = button_position_mx18
        button_mx18.config(bg=kleur_btn_act_back, highlightbackground=kleur_btn_act_back,
                           fg=kleur_btn_act_front, font=FONT_MODEL_SELECTED)

    for i in range(MAX):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        frame_knop[i].place(x=button_position[i][0], y=button_position[i][1], height=95, width=75)
        frame_knop[i + 36].place(x=button_position[i][0], y=button_position[i][1], height=95, width=75)
        frame_p_knop[i].place(x=button_position[i][0] + xp, y=button_position[i][1] + yp, height=95, width=75)
        button_knop[i].place(x=button_position[i][0] + btnx, y=button_position[i][1] + btny, height=42, width=42)
        button_knop[i + 36].place(x=button_position[i][0] + btnx, y=button_position[i][1] + btny, height=42, width=42)


def get_onoffstates(prst, posx, posy):  # buttons on/off state
    # k = 0
    # for j in range(3):
    #     x = posy + (j *2)
    #     getal = get_translation_int(posx, x, x+2)
    #     bin1 = bin(getal)
    #     bin1 = bin1[2:]
    #     bin1 = '00000000' + bin1
    #     bin1 = bin1[-8:]
    #     for b in range(7, -1, -1):
    #         if k < 22:
    #             presets[prst].ison[k] = int(bin1[b])
    #             k = k + 1
    k = 0
    for j in range(3):
        x = posy + (j * 2)
        getal = get_translation_int(posx, x, x + 2)
        getalhex = get_translation_hex(posx, x, x + 2)
        bin1 = bin(getal)
        bin1 = bin1[2:]
        bin1 = '00000000' + bin1
        bin1 = bin1[-8:]
        for b in range(8):
            if k < 18:
                presets[prst].ison[k] = int(bin1[b])
                k = k + 1
            # hier nog de on/off van de per preset CC's


def loaddata():
    # Checksum check
    t = get_translation_hex(53, 53, 55)
    if int(t) != 11:  # 11=MX  12=6x6
        if int(t) == 12:
            messagebox.showinfo(titel, "This is a 6x6 file. Can't load data!")
        else:
            messagebox.showinfo(titel, "Checksum is " + t + ". Should be 11!")

    # Buttons
    #############
    t = ""
    for i in range(MAX3):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        t = get_translation_ascii(i, 57, 73)
        t = t.strip()
        ias[i].name = t

        for j in range(6):
            k = 9 + (6 * j)
            temptype = get_translation_int(i, k, k + 2)
            tempcc = get_translation_int(i, k + 2, k + 4)
            tempch = get_translation_int(i, k + 4, k + 6)
            if temptype == TYPE_AFX12_PRESETS or temptype == TYPE_AFX3_PRESETS:
                tempcc = tempcc + (tempch * 128)
            tempcmd = Cmd(temptype, tempcc, tempch)
            ias[i].cmd[j] = tempcmd

        # global, steps, group, color
        getal = get_translation_int(i, 45, 47)
        k = int(0)
        d = int(0)
        bingetal = [0, 0, 0, 0, 0, 0, 0, 0]

        while getal != 0:
            d = int(getal % 2)
            bingetal[k] = int(d)
            k = k + 1
            getal = int(getal / 2)

        ias[i].glbl = False
        ias[i].steps = False
        ias[i].group = 0
        ias[i].color = 0
        if bingetal[0] == 1:
            ias[i].glbl = True
        if bingetal[1] == 1:
            ias[i].steps = True
        if bingetal[2] == 0 and bingetal[3] == 0 and bingetal[4] == 1:
            ias[i].group = 1
        if bingetal[2] == 0 and bingetal[3] == 1 and bingetal[4] == 0:
            ias[i].group = 2
        if bingetal[2] == 0 and bingetal[3] == 1 and bingetal[4] == 1:
            ias[i].group = 3
        if bingetal[2] == 1 and bingetal[3] == 0 and bingetal[4] == 0:
            ias[i].group = 4
        if bingetal[5] == 0 and bingetal[6] == 0 and bingetal[7] == 1:
            ias[i].color = 1
        if bingetal[5] == 0 and bingetal[6] == 1 and bingetal[7] == 0:
            ias[i].color = 2
        if bingetal[5] == 0 and bingetal[6] == 1 and bingetal[7] == 1:
            ias[i].color = 3
        if bingetal[5] == 1 and bingetal[6] == 0 and bingetal[7] == 0:
            ias[i].color = 4
        if bingetal[5] == 1 and bingetal[6] == 0 and bingetal[7] == 1:
            ias[i].color = 5
        if bingetal[5] == 1 and bingetal[6] == 1 and bingetal[7] == 0:
            ias[i].color = 6
        if bingetal[5] == 1 and bingetal[6] == 1 and bingetal[7] == 1:
            ias[i].color = 7

        label_knop_name[i].config(text=str(t))
        label_knop_name[i].config(fg=colors[ias[i].color])
        if i < MAX:
            label_p_knop_name[i].config(text=str(t))  # Presets buttons

    # holdtype
    for i in range(MAX):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        ias[i + MAX].holdtype = get_translation_int(36 + i, 55, 57)
        ht = ias[i + MAX].holdtype
        label_knop_holdtype[i + MAX].config(text=holdtypesshort[ht])

        ias[i + MAX + MAX2].holdtype = get_translation_int(36 + MAX + i, 55, 57)
        ht = ias[i + MAX + MAX2].holdtype
        label_knop_holdtype[i + MAX + MAX2].config(text=holdtypesshort[ht])

    # ABCD
    for i in range(4):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        # name
        txtnp = ""
        txtlp = ""
        for l in range(4):
           txtnp += get_translation_ascii(56 + (i * 4), 47 + (l * 2), 49 + (l * 2))
           txtlp += get_translation_ascii(58 + (i * 4), 47 + (l * 2), 49 + (l * 2))
        for l in range(4):
           txtnp += get_translation_ascii(57 + (i * 4), 47 + (l * 2), 49 + (l * 2))
           txtlp += get_translation_ascii(59 + (i * 4), 47 + (l * 2), 49 + (l * 2))
        txtnp = txtnp[0:8]
        ias[i + 76].name = txtnp
        txtlp = txtlp[0:8]
        ias[i + 76 + 4].name = txtlp

        # type, cc, ch
        for j in range(6):
            knp = (12 * i) + j
            klp = knp + 6

            # ABCD normal press
            temptype = get_translation_int(knp, 47, 49)
            tempcc = get_translation_int(knp, 49, 51)
            tempch = get_translation_int(knp, 51, 53)
            if temptype == TYPE_AFX12_PRESETS or temptype == TYPE_AFX3_PRESETS:
                tempcc = tempcc + (tempch * 128)
            tempcmd = Cmd(temptype, tempcc, tempch)
            ias[i + 76].cmd[j] = tempcmd

            # ABCD long press
            temptype = get_translation_int(klp, 47, 49)
            tempcc = get_translation_int(klp, 49, 51)
            tempch = get_translation_int(klp, 51, 53)
            if temptype == TYPE_AFX12_PRESETS or temptype == TYPE_AFX3_PRESETS:
                tempcc = tempcc + (tempch * 128)
            tempcmd = Cmd(temptype, tempcc, tempch)
            ias[i + 76 + 4].cmd[j] = tempcmd

    # sw2x
    for i in range(4):
        t = get_translation_ascii(77, 9 + (i * 16), 25 + (i * 16))
        t = t.strip()
        ias[MAX3 + i].name = t
        entry_name_sw2x[i].delete(0, 'end')
        entry_name_sw2x[i].insert(0, t)

        temptype = get_translation_int(27 + (i * 3), 53, 55)
        if temptype > TYPE_MAX:
            temptype = TYPE_NONE
        tempcc = get_translation_int(28 + (i * 3), 53, 55)
        tempch = get_translation_int(29 + (i * 3), 53, 55)
        if temptype == TYPE_AFX12_PRESETS or temptype == TYPE_AFX3_PRESETS:
            tempcc = tempcc + (tempch * 128)
        tempcmd = Cmd(temptype, tempcc, tempch)
        ias[MAX3 + i].cmd[0] = tempcmd
        t = ias[MAX3 + i].cmd[0].type
        combobox_sw2x_cmd[i].current(getIndex(cmdssw2x, t))
        var_sw2x_cc[i].set(ias[MAX3 + i].cmd[0].cc)
        spinbox_sw2x_cc[i].config(textvariable=var_sw2x_cc[i])
        var_sw2x_ch[i].set(ias[MAX3 + i].cmd[0].ch)
        spinbox_sw2x_ch[i].config(textvariable=var_sw2x_ch[i])
        adjust_layout_ccch(t, i, True)


    global blocksavecurrentsettings
    blocksavecurrentsettings = True
    press_button(0)
    blocksavecurrentsettings = False

    # Presets
    #############
    # Use additional CC's and PC's??
    var_presets_add_usethis.set(get_translation_int(19, 55, 57))

    if var_presets_add_usethis.get() == 0:
        for i in range(50):
            t = get_translation_ascii(78 + i, 9, 31)
            t = t.strip()
            prst = 2 * i
            presets[prst].name = t
            get_onoffstates(prst, 78 + i, 35)

            t = get_translation_ascii(78 + i, 41, 63)
            t = t.strip()
            prst = prst + 1
            presets[prst].name = t
            get_onoffstates(prst, 78 + i, 67)

        listbox_presets.delete(0, tk.END)
        for i in range(100):
            listbox_presets.insert(tk.END, str(i + 1) + ' ' + presets[i].name)
        spinbox_preset.config(to=100)
    else:
        for i in range(25):
            # even
            t = get_translation_ascii(78 + i, 9, 31)
            t = t.strip()
            prst = 2 * i
            presets[prst].name = t
            get_onoffstates(prst, 78 + i, 35)
            # additional pc & cc's
            for j in range(12):
                b = 9 + (j * 2)
                t = get_translation_int(103 + i, b, b + 2)
                if j < 8:
                    presets[prst].addpcnr[j] = t
                else:
                    presets[prst].addcconoff[j - 8] = t

            # odd
            t = get_translation_ascii(78 + i, 41, 63)
            t = t.strip()
            prst = prst + 1
            presets[prst].name = t
            get_onoffstates(prst, 78 + i, 67)
            # additional pc & cc's
            for j in range(12):
                b = 41 + (j * 2)
                t = get_translation_int(103 + i, b, b + 2)
                if j < 8:
                    presets[prst].addpcnr[j] = t
                else:
                    presets[prst].addcconoff[j - 8] = t

        listbox_presets.delete(0, tk.END)
        for i in range(50):
            listbox_presets.insert(tk.END, str(i + 1) + ' ' + presets[i].name)
        spinbox_preset.config(to=50)

    # additional PC Midi Channel and CC CC + Midi Channel
    for i in range(8):
        v = get_translation_int(20 + i, 55, 57)
        var_presets_add_pc_ch[i].set(v)
        if v > 0:
             var_presets_add_pc_onoff[i].set(1)
        checkbutton_presets_add_onoff_changed(i, True)

        if i < 4:
            var_presets_add_cc_cc[i].set(get_translation_int(28 + i, 55, 57))
            v = get_translation_int(32 + i, 55, 57)
            var_presets_add_cc_ch[i].set(v)
            if v > 0:
                var_presets_add_cc_onoff[i].set(1)
            checkbutton_presets_add_onoff_changed(i, False)

    checkbutton_presets_add_usethis_changed()

    global preset
    preset = 0
    preset_changed()

    # Exp. Input
    #############
    var_exp1_cc.set(get_translation_int(0, 53, 55))
    spinbox_exp1_cc.config(textvariable=var_exp1_cc)
    var_exp1_ch.set(get_translation_int(1, 53, 55))
    spinbox_exp1_ch.config(textvariable=var_exp1_ch)
    auto = get_translation_int(2, 53, 55)
    var_auto1_cc.set(auto)
    if auto == 0:
        var_exp1_auto_onoff.set(0)
        spinbox_auto1_cc.place(x=-1400)
        spinbox_auto1_ch.place(x=-2000)
    else:
        var_exp1_auto_onoff.set(1)
        spinbox_auto1_cc.place(x=140)
        spinbox_auto1_ch.place(x=200)
    spinbox_auto1_cc.config(textvariable=var_auto1_cc)
    var_auto1_ch.set(get_translation_int(3, 53, 55))
    spinbox_auto1_ch.config(textvariable=var_auto1_ch)
    var_exp1_resend.set(get_translation_int(17, 55, 57))

    temp = get_translation_int(39, 53, 55)
    if temp > 127:
        temp = 0
    var_exp1_min_cc.set(temp)
    spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
    temp = get_translation_int(40, 53, 55)
    if temp > 127 or temp == 0:
        temp = 127
    if temp < var_exp1_min_cc.get():
        temp = 127
        var_exp1_min_cc.set(0)
        spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
    var_exp1_max_cc.set(temp)
    spinbox_exp1_max_cc.config(textvariable=var_exp1_max_cc)

    var_exp2_cc.set(get_translation_int(4, 53, 55))
    spinbox_exp2_cc.config(textvariable=var_exp2_cc)
    var_exp2_ch.set(get_translation_int(5, 53, 55))
    spinbox_exp2_ch.config(textvariable=var_exp2_ch)
    auto = get_translation_int(6, 53, 55)
    var_auto2_cc.set(auto)
    if auto == 0:
        var_exp2_auto_onoff.set(0)
        spinbox_auto2_cc.place(x=-1400)
        spinbox_auto2_ch.place(x=-2000)
    else:
        var_exp2_auto_onoff.set(1)
        spinbox_auto2_cc.place(x=140)
        spinbox_auto2_ch.place(x=200)
    spinbox_auto2_cc.config(textvariable=var_auto2_cc)
    var_auto2_ch.set(get_translation_int(7, 53, 55))
    spinbox_auto2_ch.config(textvariable=var_auto2_ch)

    var_exp3_cc.set(get_translation_int(8, 53, 55))
    spinbox_exp3_cc.config(textvariable=var_exp3_cc)
    var_exp3_ch.set(get_translation_int(9, 53, 55))
    spinbox_exp3_ch.config(textvariable=var_exp3_ch)

    for nr in range(3):
        device = get_translation_int(10 + nr, 53, 55)
        index = getIndex(cmdsexp, device)
        if nr == 0:
            combobox_exp_as_button1.current(index)
        elif nr == 1:
            combobox_exp_as_button2.current(index)
        elif nr == 2:
            combobox_exp_as_button3.current(index)
        if index == 0:
            frame_act_as_exp[nr].place(x=10)
            frame_act_as_btn[nr].place(x=-1000)
            pijl_exp[nr] = True
        else:
            frame_act_as_sw2x_inner.place(x=-1000)
            frame_act_as_exp[nr].place(x=-1000)
            frame_act_as_btn[nr].place(x=10)
            pijl_exp[nr] = False
    if ias[MAX3].cmd[0].type == 0:  # check if SW2x Left Button NP is > 0
        frame_act_as_sw2x_inner.place(x=-1000)
        frame_act_as_exp[0].place(x=10)
        frame_act_as_btn[0].place(x=-1000)
    else:
        frame_act_as_sw2x_inner.place(x=10)
        frame_act_as_exp[0].place(x=-1000)
        frame_act_as_btn[0].place(x=-1000)

    # SysEx
    #############
    x = 0
    y = 0
    for i in range(160):
        if int(i / 32) > y:  # new row
            y = y + 1
            x = 0
        posx = 72 + y
        posy = 9 + (x * 2)
        sysex[i] = get_translation_hex(posx, posy, posy + 2)
        entry_sysex[i].delete(0, 'end')
        entry_sysex[i].insert(0, sysex[i])
        x = x + 1
    # Sysex Pre
    for i in range(8):
        sysex[i + 160] = get_translation_hex(19 + i, 53, 55)
        entry_sysex[i + 160].delete(0, 'end')
        entry_sysex[i + 160].insert(0, sysex[i + 160])

    var_prefix.set(get_translation_int(12, 55, 57))
    prefix_changed()
    var_double.set(get_translation_int(13, 55, 57))
    checkbutton_double_changed()

    # Global
    #############
    # Misc
    var_global_preset_offset.set(get_translation_int(1, 55, 57))
    temp = get_translation_int(15, 55, 57)
    if temp > 5:
        temp = 0
    temp = temp * 128
    var_global_start_preset.set(temp + get_translation_int(14, 55, 57))
    spinbox_global_start_preset.config(textvariable=var_global_start_preset)
    var_global_bank_only.set(get_translation_int(3, 55, 57))
    var_global_ignore_pc.set(get_translation_int(16, 55, 57))
    var_global_reset_steps.set(get_translation_int(2, 55, 57))
    var_global_auto_color.set(get_translation_int(0, 55, 57))
    var_global_cc_start_value.set(get_translation_int(42, 53, 55))
    temp = get_translation_int(41, 53, 55)
    if temp > 10:  # 0=none 1=extend mother 2= extend child 3=clone mother 4=clone child 5=sync fm3/fm9, ...
        temp = 0
    combobox_extendclone.current(temp)
    var_global_long_press.set((get_translation_int(4, 55, 57)))
    var_global_reset_lcd.set(get_translation_int(9, 55, 57))
    spinbox_global_reset_lcd.config(textvariable=var_global_reset_lcd)
    combobox_kleur_page_a.current(get_translation_int(11, 55, 57))
    combobox_kleur_page_b.current(get_translation_int(8, 55, 57))
    temp = get_translation_int(54, 53, 55)
    if temp > 7:
        temp = 0
    combobox_kleur_scene_ab.current(temp)

    # External Device
    device = get_translation_int(5, 55, 57)
    index = getIndex(devices, device)
    combobox_device.current(index)
    var_global_midi_channel.set(get_translation_int(6, 55, 57))
    spinbox_global_midi_channel.config(textvariable=var_global_midi_channel)
    temp = get_translation_int(50, 53, 55)
    if temp > 2:
        temp = 0
    combobox_tuner.current(temp)
    var_global_show_preset.set(get_translation_int(7, 55, 57))

    # Expr. Calibration
    var_global_exp1_min.set(get_translation_int(13, 53, 55))
    spinbox_global_exp1_min.config(textvariable=var_global_exp1_min)
    var_global_exp1_max.set(get_translation_int(14, 53, 55))
    spinbox_global_exp1_max.config(textvariable=var_global_exp1_max)
    var_global_exp2_min.set(get_translation_int(15, 53, 55))
    spinbox_global_exp2_min.config(textvariable=var_global_exp2_min)
    var_global_exp2_max.set(get_translation_int(16, 53, 55))
    spinbox_global_exp2_max.config(textvariable=var_global_exp2_max)
    var_global_exp3_min.set(get_translation_int(17, 53, 55))
    spinbox_global_exp3_min.config(textvariable=var_global_exp3_min)
    var_global_exp3_max.set(get_translation_int(18, 53, 55))
    spinbox_global_exp3_max.config(textvariable=var_global_exp3_max)

    # Hardware 15 23 33 26 34 36
    t = get_translation_hex(10, 55, 57)
    change_model(int(t))

    # saved previously with O.S. (88=Mac, 99=Win)
    t = get_translation_hex(18, 55, 57)
    if t == '88':
        button_voes.config(bg=kleur_geel)
    else:
        button_voes.config(bg=kleur_front)

    notebook_tabs.select(0)


def updatedata():
    # Checksum
    change_value_to_int(53, 53, 53, 11)  # 11=MX 12=6x6
    # Used O.S.
    if windows:
        change_value_to_int(18, 55, 57, 99)
    else:
        change_value_to_int(18, 55, 57, 88)
    # Model
    change_value_to_int(10, 55, 57, model)

    # Buttons
    #############
    for i in range(MAX3):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        # name
        txt = ias[i].name

        txt = txt + '        '
        txt = txt[0:8]
        change_value(i, 57, 73, txt)

        # type, cc, ch
        for j in range(6):
            k = 9 + (6 * j)
            change_value_to_hex(i, k, k + 2, ias[i].cmd[j].type)
            if ias[i].cmd[j].type == TYPE_AFX12_PRESETS or ias[i].cmd[j].type == TYPE_AFX3_PRESETS:
                temppreset = int(ias[i].cmd[j].cc % 128)
                tempbank = int(ias[i].cmd[j].cc / 128)
                change_value_to_hex(i, k + 2, k + 4, temppreset)
                change_value_to_hex(i, k + 4, k + 6, tempbank)
            else:
                change_value_to_hex(i, k + 2, k + 4, ias[i].cmd[j].cc)
                change_value_to_hex(i, k + 4, k + 6, ias[i].cmd[j].ch)

        # global, steps, group, color
        int7 = 0
        int6 = 0
        int5 = 0
        int4 = 0
        int3 = 0
        int2 = 0
        int1 = 0
        int0 = 0

        if ias[i].glbl:
            int0 = 1
        if ias[i].steps:
            int1 = 1
        if ias[i].group == 1:
            int2 = 0
            int3 = 0
            int4 = 1
        if ias[i].group == 2:
            int2 = 0
            int3 = 1
            int4 = 0
        if ias[i].group == 3:
            int2 = 0
            int3 = 1
            int4 = 1
        if ias[i].group == 4:
            int2 = 1
            int3 = 0
            int4 = 0
        if ias[i].color == 0:
            int5 = 0
            int6 = 0
            int7 = 0
        if ias[i].color == 1:
            int5 = 0
            int6 = 0
            int7 = 1
        if ias[i].color == 2:
            int5 = 0
            int6 = 1
            int7 = 0
        if ias[i].color == 3:
            int5 = 0
            int6 = 1
            int7 = 1
        if ias[i].color == 4:
            int5 = 1
            int6 = 0
            int7 = 0
        if ias[i].color == 5:
            int5 = 1
            int6 = 0
            int7 = 1
        if ias[i].color == 6:
            int5 = 1
            int6 = 1
            int7 = 0
        if ias[i].color == 7:
            int5 = 1
            int6 = 1
            int7 = 1

        getal = int0 + (int1 * 2) + (int2 * 4) + (int3 * 8) + (int4 * 16) + (int5 * 32) + (int6 * 64) + (int7 * 128)
        change_value_to_hex(i, 45, 47, getal)

    # holdtype
    for i in range(MAX):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        change_value_to_hex(36 + i, 55, 57, ias[i + MAX].holdtype)
        change_value_to_hex(36 + MAX + i, 55, 57, ias[i + MAX + MAX2].holdtype)

    # ABCD
    for i in range(4):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        # name
        txtnp = ias[i+76].name
        txtnp = txtnp + '        '
        txtnp = txtnp[0:8]

        txtlp = ias[i+76+4].name
        txtlp = txtlp + '        '
        txtlp = txtlp[0:8]

        for l in range(4):
             change_value(56 + (i * 4), 47 + (l * 2), 49 + (l * 2), txtnp[l])
             change_value(57 + (i * 4), 47 + (l * 2), 49 + (l * 2), txtnp[l+4])

             change_value(58 + (i * 4), 47 + (l * 2), 49 + (l * 2), txtlp[l])
             change_value(59 + (i * 4), 47 + (l * 2), 49 + (l * 2), txtlp[l+4])

        # type, cc, ch
        for j in range(6):
            rnp = (12 * i) + j
            rlp = rnp + 6
            # ABCD normal press
            change_value_to_hex(rnp, 47, 49, ias[i+76].cmd[j].type)
            if ias[i+76].cmd[j].type == TYPE_AFX12_PRESETS or ias[i+76].cmd[j].type == TYPE_AFX3_PRESETS:
                temppreset = int(ias[i+76].cmd[j].cc % 128)
                tempbank = int(ias[i+76].cmd[j].cc / 128)
                change_value_to_hex(rnp, 49, 51, temppreset)
                change_value_to_hex(rnp, 51, 53, tempbank)
            else:
                change_value_to_hex(rnp, 49, 51, ias[i+76].cmd[j].cc)
                change_value_to_hex(rnp, 51, 53, ias[i+76].cmd[j].ch)

            # ABCD long press
            change_value_to_hex(rlp, 47, 49, ias[i+76+4].cmd[j].type)
            if ias[i+76+4].cmd[j].type == TYPE_AFX12_PRESETS or ias[i+76+4].cmd[j].type == TYPE_AFX3_PRESETS:
                temppreset = int(ias[i+76+4].cmd[j].cc % 128)
                tempbank = int(ias[i+76+4].cmd[j].cc / 128)
                change_value_to_hex(rlp, 49, 51, temppreset)
                change_value_to_hex(rlp, 51, 53, tempbank)
            else:
                change_value_to_hex(rlp, 49, 51, ias[i+76+4].cmd[j].cc)
                change_value_to_hex(rlp, 51, 53, ias[i+76+4].cmd[j].ch)

    # sw2x
    for i in range(4):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
        # name
        txt = ias[MAX3 + i].name
        txt = txt + '        '
        txt = txt[0:8]
        change_value(77, 9 + (i * 16), 25 + (i * 16), txt)

        # type, cc, ch
        change_value_to_hex(27 + (i * 3), 53, 55, ias[MAX3 + i].cmd[0].type)

        if ias[MAX3 + i].cmd[0].type == TYPE_AFX12_PRESETS or ias[MAX3 + i].cmd[0].type == TYPE_AFX3_PRESETS:
            temppreset = int(ias[MAX3 + i].cmd[0].cc % 128)
            tempbank = int(ias[MAX3 + i].cmd[0].cc / 128)
            change_value_to_hex(28 + (i * 3), 53, 55, temppreset)
            change_value_to_hex(29 + (i * 3), 53, 55, tempbank)
        else:
            change_value_to_hex(28 + (i * 3), 53, 55, ias[MAX3 + i].cmd[0].cc)
            change_value_to_hex(29 + (i * 3), 53, 55, ias[MAX3 + i].cmd[0].ch)

    # Presets
    #############
    if var_presets_add_usethis.get() == 0:
        for i in range(50):
            # even
            prst = 2 * i
            txt = presets[prst].name
            txt = txt + '        '
            txt = txt[0:11]
            change_value(78 + i, 9, 31, txt)
            getal = (presets[prst].ison[0] * 128) + (presets[prst].ison[1] * 64) + (presets[prst].ison[2] * 32) + \
                    (presets[prst].ison[3] * 16) + (presets[prst].ison[4] * 8) + (presets[prst].ison[5] * 4) + \
                    (presets[prst].ison[6] * 2) + presets[prst].ison[7]
            change_value_to_hex(78 + i, 35, 37, getal)
            getal = (presets[prst].ison[8] * 128) + (presets[prst].ison[9] * 64) + (presets[prst].ison[10] * 32) + \
                    (presets[prst].ison[11] * 16) + (presets[prst].ison[12] * 8) + (presets[prst].ison[13] * 4) + \
                    (presets[prst].ison[14] * 2) + presets[prst].ison[15]
            change_value_to_hex(78 + i, 37, 39, getal)
            getal = (presets[prst].ison[16] * 128) + (presets[prst].ison[17] * 64)
            change_value_to_hex(78 + i, 39, 41, getal)

            # odd
            prst = prst + 1
            txt = presets[prst].name
            txt = txt + '        '
            txt = txt[0:11]
            change_value(78 + i, 41, 63, txt)
            getal = (presets[prst].ison[0] * 128) + (presets[prst].ison[1] * 64) + (presets[prst].ison[2] * 32) + \
                    (presets[prst].ison[3] * 16) + (presets[prst].ison[4] * 8) + (presets[prst].ison[5] * 4) + \
                    (presets[prst].ison[6] * 2) + presets[prst].ison[7]
            change_value_to_hex(78 + i, 67, 69, getal)
            getal = (presets[prst].ison[8] * 128) + (presets[prst].ison[9] * 64) + (presets[prst].ison[10] * 32) + \
                    (presets[prst].ison[11] * 16) + (presets[prst].ison[12] * 8) + (presets[prst].ison[13] * 4) + \
                    (presets[prst].ison[14] * 2) + presets[prst].ison[15]
            change_value_to_hex(78 + i, 69, 71, getal)
            getal = (presets[prst].ison[16] * 128) + (presets[prst].ison[17] * 64)
            change_value_to_hex(78 + i, 71, 73, getal)

    else:
        for i in range(25):
            # even
            prst = 2 * i
            txt = presets[prst].name
            txt = txt + '        '
            txt = txt[0:11]
            change_value(78 + i, 9, 31, txt)
            getal = (presets[prst].ison[0] * 128) + (presets[prst].ison[1] * 64) + (presets[prst].ison[2] * 32) + \
                    (presets[prst].ison[3] * 16) + (presets[prst].ison[4] * 8) + (presets[prst].ison[5] * 4) + \
                    (presets[prst].ison[6] * 2) + presets[prst].ison[7]
            change_value_to_hex(78 + i, 35, 37, getal)
            getal = (presets[prst].ison[8] * 128) + (presets[prst].ison[9] * 64) + (presets[prst].ison[10] * 32) + \
                    (presets[prst].ison[11] * 16) + (presets[prst].ison[12] * 8) + (presets[prst].ison[13] * 4) + \
                    (presets[prst].ison[14] * 2) + presets[prst].ison[15]
            change_value_to_hex(78 + i, 37, 39, getal)
            getal = (presets[prst].ison[16] * 128) + (presets[prst].ison[17] * 64)
            change_value_to_hex(78 + i, 39, 41, getal)
            # additional pc & cc's
            for j in range(12):
                b = 9 + (j * 2)
                t = get_translation_int(103 + i, b, b + 2)
                if j < 8:
                    change_value_to_hex(103 + i, b, b + 2, presets[prst].addpcnr[j])
                else:
                    change_value_to_hex(103 + i, b, b + 2, presets[prst].addcconoff[j - 8])

            # odd
            prst = prst + 1
            txt = presets[prst].name
            txt = txt + '        '
            txt = txt[0:11]
            change_value(78 + i, 41, 63, txt)
            getal = (presets[prst].ison[0] * 128) + (presets[prst].ison[1] * 64) + (presets[prst].ison[2] * 32) + \
                    (presets[prst].ison[3] * 16) + (presets[prst].ison[4] * 8) + (presets[prst].ison[5] * 4) + \
                    (presets[prst].ison[6] * 2) + presets[prst].ison[7]
            change_value_to_hex(78 + i, 67, 69, getal)
            getal = (presets[prst].ison[8] * 128) + (presets[prst].ison[9] * 64) + (presets[prst].ison[10] * 32) + \
                    (presets[prst].ison[11] * 16) + (presets[prst].ison[12] * 8) + (presets[prst].ison[13] * 4) + \
                    (presets[prst].ison[14] * 2) + presets[prst].ison[15]
            change_value_to_hex(78 + i, 69, 71, getal)
            getal = (presets[prst].ison[16] * 128) + (presets[prst].ison[17] * 64)
            change_value_to_hex(78 + i, 71, 73, getal)
            # additional pc & cc's
            for j in range(12):
                b = 41 + (j * 2)
                t = get_translation_int(103 + i, b, b + 2)
                if j < 8:
                    change_value_to_hex(103 + i, b, b + 2, presets[prst].addpcnr[j])
                else:
                    change_value_to_hex(103 + i, b, b + 2, presets[prst].addcconoff[j - 8])

    # additional PC Midi Channel and CC CC + Midi Channel
    change_value_to_hex(19, 55, 57, var_presets_add_usethis.get())
    for i in range(8):
        change_value_to_hex(20 + i, 55, 57, var_presets_add_pc_ch[i].get())
        if i < 4:
            change_value_to_hex(28 + i, 55, 57, var_presets_add_cc_cc[i].get())
            change_value_to_hex(32 + i, 55, 57, var_presets_add_cc_ch[i].get())

    # Exp. Input
    #############
    change_value_to_hex(0, 53, 55, var_exp1_cc.get())
    change_value_to_hex(1, 53, 55, var_exp1_ch.get())
    change_value_to_hex(2, 53, 55, var_auto1_cc.get())
    change_value_to_hex(3, 53, 55, var_auto1_ch.get())
    change_value_to_hex(17, 55, 57, var_exp1_resend.get())
    change_value_to_hex(39, 53, 55, var_exp1_min_cc.get())
    change_value_to_hex(40, 53, 55, var_exp1_max_cc.get())

    change_value_to_hex(4, 53, 55, var_exp2_cc.get())
    change_value_to_hex(5, 53, 55, var_exp2_ch.get())
    change_value_to_hex(6, 53, 55, var_auto2_cc.get())
    change_value_to_hex(7, 53, 55, var_auto2_ch.get())

    change_value_to_hex(8, 53, 55, var_exp3_cc.get())
    change_value_to_hex(9, 53, 55, var_exp3_ch.get())

    device_nr = getNumber(cmdsexp, combobox_exp_as_button1.get())
    change_value_to_hex(10, 53, 55, device_nr)
    device_nr = getNumber(cmdsexp, combobox_exp_as_button2.get())
    change_value_to_hex(11, 53, 55, device_nr)
    device_nr = getNumber(cmdsexp, combobox_exp_as_button3.get())
    change_value_to_hex(12, 53, 55, device_nr)

    # SysEx
    #############
    x = 0
    y = 0
    for i in range(160):
        if int(i / 32) > y:  # new row
            y = y + 1
            x = 0
        posx = 72 + y
        posy = 9 + (x * 2)
        change_value_to_realhex(posx, posy, posy + 2, sysex[i])
        x = x + 1
    # Sysex Pre
    for i in range(8):
        change_value_to_realhex(19 + i, 53, 55, sysex[i + 160])
    change_value_to_hex(12, 55, 57, var_prefix.get())
    change_value_to_hex(13, 55, 57, var_double.get())

    # Global
    #############
    # Misc
    change_value_to_hex(1, 55, 57, var_global_preset_offset.get())
    beginPreset = var_global_start_preset.get() % 128
    beginBank = int(var_global_start_preset.get() / 128)
    change_value_to_hex(14, 55, 57, beginPreset)
    change_value_to_hex(15, 55, 57, beginBank)
    change_value_to_hex(3, 55, 57, var_global_bank_only.get())
    change_value_to_hex(16, 55, 57, var_global_ignore_pc.get())
    change_value_to_hex(2, 55, 57, var_global_reset_steps.get())
    change_value_to_hex(0, 55, 57, var_global_auto_color.get())
    change_value_to_hex(42, 53, 55, var_global_cc_start_value.get())
    change_value_to_hex(41, 53, 55, combobox_extendclone.current())
    change_value_to_hex(4, 55, 57, var_global_long_press.get())
    change_value_to_hex(9, 55, 57, var_global_reset_lcd.get())
    change_value_to_hex(11, 55, 57, combobox_kleur_page_a.current())
    change_value_to_hex(8, 55, 57, combobox_kleur_page_b.current())
    change_value_to_hex(54, 53, 55, combobox_kleur_scene_ab.current())

    # External Device
    device_nr = getNumber(devices, combobox_device.get())
    change_value_to_hex(5, 55, 57, device_nr)
    change_value_to_hex(6, 55, 57, var_global_midi_channel.get())
    tekst_tuner = combobox_tuner.get()
    tuner = 0  # Mixed
    if tekst_tuner == "Flat":
        tuner = 1
    elif tekst_tuner == "Sharp":
        tuner = 2
    change_value_to_hex(50, 53, 55, tuner)
    change_value_to_hex(7, 55, 57, var_global_show_preset.get())

    # Expr. Calibration
    change_value_to_hex(13, 53, 55, var_global_exp1_min.get())
    change_value_to_hex(14, 53, 55, var_global_exp1_max.get())
    change_value_to_hex(15, 53, 55, var_global_exp2_min.get())
    change_value_to_hex(16, 53, 55, var_global_exp2_max.get())
    change_value_to_hex(17, 53, 55, var_global_exp3_min.get())
    change_value_to_hex(18, 53, 55, var_global_exp3_max.get())


# get the Hex version from the bytes on line 'line
def get_translation_hex(lineNr, yOffsetStart, yOffsetEnd):
    out = 0
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = line
    return out


# get the Int version from the bytes on line 'line
def get_translation_int(lineNr, yOffsetStart, yOffsetEnd):
    out = 0
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = int(line, 16)
    return out


# get the Ascii version from the bytes on line 'line
def get_translation_ascii(lineNr, yOffsetStart, yOffsetEnd):
    out = ""
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = binascii.unhexlify(line)
    out = str(out, 'ascii')
    return out


def get_checksum(line):
    oldChecksum = line[-2:]
    line = line[:len(line) - 1]
    o = 0
    i = line
    # calculate the sum
    while not len(i) < 2:
        o += int((i[:2]), 16)
        i = i[2:]

    # calculate the complement and add 1 (two's complement)
    checksum = format((o ^ 0xffff) + 1, '#016b')
    checksum = int(checksum[-8:], 2)
    checksum = "{0:#0{1}x}".format(checksum, 4)
    checksum = checksum[-2:]
    # return the last two symbols
    return checksum


# change a value on lineNr from (y_offsetStart, y_offsetEnd) to value
def change_value(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    # add spaces
    value = value.ljust(size, ' ')
    out = binascii.b2a_hex(value.encode())
    hex_value = str(out, 'ascii').upper()
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_int(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    # add spaces
    # value = value.ljust(size, ' ')
    # out = binascii.b2a_hex(value.encode())
    # hex_value = str(out, 'ascii').upper()

    hex_value = str(value)
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_hex(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    hex_value = str(hex(value))
    lengte = len(hex_value)
    if lengte > 3:
        hex_value = hex_value[2:4].upper()
    else:
        hex_value = "0" + hex_value[2:3].upper()
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_realhex(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    hex_value = value.upper()
    lengte = len(hex_value)
    if lengte < 2:
        hex_value = "0" + hex_value
    hex_value = hex_value[0:2]
    # print(hex_value)
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def read_hex(filepath):
    my_file = Path(filepath)
    if my_file.is_file():
        newLines.clear()
        with open(filepath) as f:
            lines = f.readlines()
        f.close()
        for line in lines:
            newLines.append(line)
    else:
        messagebox.showinfo(titel, "File does not exist!")


def read_txt(filepath):
    my_file = Path(filepath)
    if my_file.is_file():
        if windows:
            os.startfile(my_file)
        else:
            subprocess.call(['open', '-a', 'Textedit', my_file])


def write_hex(filepath):
    # if windows:
    #    file = open(filepath, "w")
    # else:
    #    file = open('./' + filepath, "w")
    file = open(filepath, "w")
    for line in newLines:
        file.write(line)
    file.close()


def select_preset(event):
    anchor = listbox_presets.get(tk.ANCHOR)
    global preset
    preset = listbox_presets.get(0, tk.END).index(anchor)
    entry_preset_name.delete(0, 'end')
    entry_preset_name.insert(0, presets[preset].name)
    var_preset.set(preset + 1)
    spinbox_preset.config(textvariable=var_preset)
    preset_changing()


def preset_changed():
    global preset
    preset = int(spinbox_preset.get()) - 1
    entry_preset_name.delete(0, 'end')
    entry_preset_name.insert(0, presets[preset].name)
    preset_changing()


def preset_changing():
    for i in range(MAX):
        if presets[preset].ison[i] == 1:
            label_p_knop_name[i].config(bg=colors[ias[i].color], fg=kleur_btn_front)
        else:
            label_p_knop_name[i].config(bg=kleur_btn_back, fg=kleur_btn_front)

    # additional PC's and CC's
    if var_presets_add_usethis.get() > 0:
        for i in range(8):
            var_presets_add_pc_nr[i].set(presets[preset].addpcnr[i])
            if i < 4:
                if presets[preset].addcconoff[i] == 0:
                    button_presets_add_cc[i].config(bg=kleur_btn_back)
                    label_presets_add_cc_tekst[i].config(bg=kleur_grijs, fg=kleur_front)
                else:
                    button_presets_add_cc[i].config(bg=kleur_btn_geel)
                    label_presets_add_cc_tekst[i].config(bg=kleur_btn_geel, fg=kleur_back)


def enter_preset_name(event):
    t = entry_preset_name.get()
    t = t[0:12]
    entry_preset_name.delete(12, 'end')
    presets[preset].name = t
    listbox_presets.delete(preset)
    listbox_presets.insert(preset, str(preset + 1) + ' ' + presets[preset].name)


def addpcnr_changed(nr):
    presets[preset].addpcnr[nr] = int(var_presets_add_pc_nr[nr].get())


def press_load_from_computer():
    global loaded_filename
    root.filename = filedialog.askopenfilename(title="Select file",
                                               filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return
    read_hex(root.filename)
    loaddata()
    # Store the loaded filename
    if windows:
        loaded_filename = root.filename
    else:
        loaded_filename = os.path.basename(root.filename)


def press_save_to_computer():
    global loaded_filename
    updatedata()
    # Use the loaded filename as the default filename
    root.filename = filedialog.asksaveasfilename(title="Select file",
                                                 initialfile=loaded_filename,
                                                 filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return
    if root.filename[-4:] != '.hex':
        root.filename = root.filename + '.hex'
    write_hex(root.filename)
    file = open(root.filename, "w")
    # delete the : and newlines
    n = 9
    for line in newLines:
        line = line.strip()
        line = line.strip()
        line = line[1:]
        checksum = get_checksum(line)
        line = ":" + line[:len(line) - 2] + checksum.upper() + "\n"
        file.write(line)
    file.close()
    # write to chip
    # self.run_bash(savef)
    messagebox.showinfo(titel, "Saved to computer")
    # Store the loaded filename
    loaded_filename = root.filename


def importnames():
    root.filename = filedialog.askopenfilename(title="Select file",
                                               filetypes=(("csv files", "*.csv"), ("txt files", "*.txt")))
    if not root.filename: return

    listbox_presets.delete(0, tk.END)
    with open(root.filename, 'r') as file:
        for i, line in enumerate(file):
            if i >= 100:
                break
            truncated_line = line[:12]
            listbox_presets.insert(tk.END, str(i + 1) + ' ' + truncated_line)
            presets[i].name = truncated_line
    spinbox_preset.config(to=i+1)


def press_load_from_mx():
    if windows:
        os.system('start cmd /k "bin\\read_settings.bat"')
        time.sleep(4)
        read_hex("./temp.hex")

        # Run the batch file and wait for it to complete
        # subprocess.run(['cmd', '/k', 'bin\\read_settings.bat'], check=True)
        # read_hex("./temp.hex")
    else:
        cmd = cmdavr + 'eeprom:r:' + path_mx + 'temp.hex:i'
        tell.app('Terminal', 'do script "' + cmd + '; exit"')
        tell.app('Terminal', 'activate')
        tell.app('System Events', 'delay 4')
        tell.app('System Events', 'tell process "Terminal" to keystroke "w" using command down')
        read_hex(path_mx + "temp.hex")
    loaddata()
    # Firmware
    global FIRMWARE
    major = str(get_translation_hex(51, 53, 55))
    if major[0:1] == "0":
        major = major[1:]
    minor = str(get_translation_hex(52, 53, 55))
    FIRMWARE = "v " + major + "." + minor
    message = "Editor: " + VERSION + "\n(Build: " + BUILD + ")\n\nFirmware: " + FIRMWARE
    message += "\n\nLatest software and firmware on"
    label_firmware.config(text=message)
    if VERSION != FIRMWARE:
        messagebox.showinfo(titel, "Editor (" + VERSION + ") and Firmware (" + FIRMWARE +
                            ") versions are not identical.\n\nPlease update!")


def press_save_to_mx():
    updatedata()
    if windows:
        write_hex('temp.hex')
        file = open('temp.hex', "w")
    else:
        write_hex(path_mx + 'temp.hex')
        file = open(path_mx + 'temp.hex', "w")
    # delete the : and newlines
    n = 9
    for line in newLines:
        line = line.strip()
        line = line.strip()
        line = line[1:]
        checksum = get_checksum(line)
        line = ":" + line[:len(line) - 2] + checksum.upper() + "\n"
        file.write(line)
    file.close()

    if windows:
        os.system('start cmd /k "bin\\write_settings.bat"')
    else:
        cmd = cmdavr + 'eeprom:w:' + path_mx + 'temp.hex:i'
        tell.app('Terminal', 'do script "' + cmd + '"')
        tell.app('Terminal', 'activate')
        tell.app('System Events', 'delay 52')
        tell.app('System Events', 'tell process "Terminal" to keystroke "w" using command down')


def press_update_firmware():
    root.filename = filedialog.askopenfilename(title="Select file",
                                               filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return

    if windows:
        cmd = 'start cmd /k "bin\\update_firmware.bat" ' + Path(root.filename).stem
        os.system(cmd)
    else:
        if " " in root.filename:
            messagebox.showinfo(titel, "Sorry but map name can not contain a space.\n\n" + root.filename +
                                "\n\nPlease rename your map.")
            return

        cmd = cmdavr + 'flash:w:' + root.filename
        tell.app('Terminal', 'do script "' + cmd + '"')
        tell.app('Terminal', 'activate')
        # cmd = f'{cmdavr} flash:w:"{root.filename}"'
        # subprocess.run(['osascript', '-e', f'tell app "Terminal" to do script "{cmd}"'], check=True)
        # subprocess.run(['osascript', '-e', 'tell app "Terminal" to activate'], check=True)


def run_bash(filepath):
    # start a new subprocess to run the script:
    # data_folder = Path("/bin/")
    # file_to_open = data_folder / filePath
    file_to_open = filepath
    # os.chmod(file_to_open, 0o755)
    p = subprocess.Popen(file_to_open, shell=True, stdout=subprocess.PIPE)
    stdout, stderr = p.communicate()
    p.kill()
    is_process_alive(p)
    return p.returncode


def check_internet_connection(url='https://voes.be'):
    context = ssl._create_unverified_context()
    try:
        urllib.request.urlopen(url, context=context, timeout=5)
        return True
    except:
        return False


def check_latest_version():
    if check_internet_connection():
        url = 'https://voes.be/downloads/latest_firmware.txt'
        context = ssl._create_unverified_context()
        response = urllib.request.urlopen(url, context=context)
        data = response.read().decode('utf-8')

        # Controleer of "MX     =" in de data staat en haal de waarde op
        latest_version = None
        for line in data.splitlines():
            if "MX     =" in line:
                latest_version = line.split('=')[1].strip()
                break

        if latest_version:
            if VERSION < latest_version:
                response = messagebox.askquestion(titel, "New editor and firmware " + latest_version +
                                                  " available\n\nDownload?")
                if response == 'yes':
                    webbrowser.open("https://voes.be/downloads.html")
                    root.destroy()

def is_process_alive(p):  # check if a process is still running
    check = p.poll()
    if check is None:
        print("still running")
        return True
    print("process terminated")
    return False


def cch_check(value, max):
    if value > max:
        value = max
    return value


def press_button(x):
    global knop, knoplp

    # save current settings before changing to new knop
    if blocksavecurrentsettings is False:
        # name normal press & long press
        t = entry_name_np.get()
        t = t[0:8]
        ias[knop].name = t
        if knop <= MAX3:
            label_knop_name[knop].config(text=str(t))
            # color
            label_knop_name[knop].config(fg=colors[ias[knop].color])

        t = entry_name_lp.get()
        t = t[0:8]
        ias[knoplp].name = t
        if knop <= MAX3:
            label_knop_name[knoplp].config(text=str(t))
            # color
            label_knop_name[knoplp].config(fg=colors[ias[knoplp].color])
        # command 1-6 normal press & long press
        for i in range(6):
            # command 1-6 normal press
            cmdNr = ias[knop].cmd[i].type
            if cmdNr != TYPE_ONCOLOR and cmdNr != TYPE_OFFCOLOR and cmdNr != TYPE_AFX3_FXBLOCKS and \
                cmdNr != TYPE_AFX3_CHANNELS and cmdNr != TYPE_AFX3_BLOCKCHANNEL and cmdNr != TYPE_AFX3_LOOPER and \
                cmdNr != TYPE_KMPR_STOMPFX and cmdNr != TYPE_KMPR_LOOPER and cmdNr != TYPE_HX_LOOPER and \
                cmdNr != TYPE_QC_LOOPER:
                cctemp = int(spinbox_cc[i].get())
                chtemp = int(spinbox_ch[i].get())
                if cmdNr == TYPE_SCENES or cmdNr == TYPE_SCENE_AB or cmdNr == TYPE_AFX3_SCENES or \
                    cmdNr == TYPE_AFX3_SCENEAB:
                    cctemp = cch_check(cctemp, 8)
                    chtemp = cch_check(chtemp, 8)
                elif cmdNr == TYPE_PC or cmdNr == TYPE_CCONOFF or cmdNr == TYPE_CCOFFON or cmdNr == TYPE_CCONONLY or \
                    cmdNr == TYPE_CCONONLYLED or cmdNr == TYPE_CCOFFONLY or cmdNr == TYPE_EXPR1SWAP or \
                    cmdNr == TYPE_AUTO1SWAP or cmdNr == TYPE_FAVORITEPRESET or cmdNr == TYPE_NOTEONOFF or \
                    cmdNr == TYPE_NOTETRIGGER or cmdNr == TYPE_EXPR2SWAP or cmdNr == TYPE_AUTO2SWAP or \
                    cmdNr == TYPE_EXPR3SWAP:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 16)
                elif cmdNr == TYPE_CCVALUE or cmdNr == TYPE_CC_MIN or cmdNr == TYPE_CC_PLUS:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 127)
                elif cmdNr == TYPE_SYSEX or cmdNr == TYPE_SYSEX_TOGGLE:
                    cctemp = cch_check(cctemp, 20)
                elif cmdNr == TYPE_AFX12_PRESETS:
                    cctemp = cch_check(cctemp, 512)
                elif cmdNr == TYPE_AFX3_PRESETS:
                    cctemp = cch_check(cctemp, 1024)
                elif cmdNr == TYPE_KMPR_PERFORMANCE:
                    cctemp = cch_check(cctemp, 125)
                elif cmdNr == TYPE_KMPR_RIG:
                    cctemp = cch_check(cctemp, 15)
                elif cmdNr == TYPE_IAONOFF or cmdNr == TYPE_CHILD_IAONOFF:
                    cctemp = cch_check(cctemp, 36)

                ias[knop].cmd[i].cc = cctemp
                ias[knop].cmd[i].ch = chtemp

            # command 1-6 long press
            cmdNr = ias[knoplp].cmd[i].type
            if cmdNr != TYPE_ONCOLOR and cmdNr != TYPE_OFFCOLOR and cmdNr != TYPE_AFX3_FXBLOCKS and \
                cmdNr != TYPE_AFX3_CHANNELS and cmdNr != TYPE_AFX3_BLOCKCHANNEL and cmdNr != TYPE_AFX3_LOOPER and \
                cmdNr != TYPE_KMPR_STOMPFX and cmdNr != TYPE_KMPR_LOOPER:
                cctemp = int(spinbox_cc[i+6].get())
                chtemp = int(spinbox_ch[i+6].get())
                if cmdNr == TYPE_SCENES or cmdNr == TYPE_SCENE_AB or cmdNr == TYPE_AFX3_SCENES or \
                    cmdNr == TYPE_AFX3_SCENEAB:
                    cctemp = cch_check(cctemp, 8)
                    chtemp = cch_check(chtemp, 8)
                elif cmdNr == TYPE_PC or cmdNr == TYPE_CCONOFF or cmdNr == TYPE_CCOFFON or cmdNr == TYPE_CCONONLY or \
                    cmdNr == TYPE_CCONONLYLED or cmdNr == TYPE_CCOFFONLY or cmdNr == TYPE_EXPR1SWAP or \
                    cmdNr == TYPE_AUTO1SWAP or cmdNr == TYPE_FAVORITEPRESET or cmdNr == TYPE_NOTEONOFF or \
                    cmdNr == TYPE_NOTETRIGGER or cmdNr == TYPE_EXPR2SWAP or cmdNr == TYPE_AUTO2SWAP or \
                    cmdNr == TYPE_EXPR3SWAP:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 16)
                elif cmdNr == TYPE_CCVALUE or cmdNr == TYPE_CC_MIN or cmdNr == TYPE_CC_PLUS:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 127)
                elif cmdNr == TYPE_SYSEX or cmdNr == TYPE_SYSEX_TOGGLE:
                    cctemp = cch_check(cctemp, 20)
                elif cmdNr == TYPE_AFX12_PRESETS:
                    cctemp = cch_check(cctemp, 512)
                elif cmdNr == TYPE_AFX3_PRESETS:
                    cctemp = cch_check(cctemp, 1024)
                elif cmdNr == TYPE_KMPR_PERFORMANCE:
                    cctemp = cch_check(cctemp, 125)
                elif cmdNr == TYPE_KMPR_RIG:
                    cctemp = cch_check(cctemp, 5)
                elif cmdNr == TYPE_IAONOFF or cmdNr == TYPE_CHILD_IAONOFF:
                    cctemp = cch_check(cctemp, 36)

                ias[knoplp].cmd[i].cc = cctemp
                ias[knoplp].cmd[i].ch = chtemp
    # end save current settings

    # background color previous knop black
    label_knop_name[knop].config(bg=kleur_back)
    label_knop_name[knop + 18].config(bg=kleur_back)

    knop = x
    knoplp = knop + MAX
    if knop > MAX3:
        knoplp = knop + 4

    # background color active knop grey
    label_knop_name[knop].config(bg=kleur_btn_active)
    label_knop_name[knop + 18].config(bg=kleur_btn_active)

    # Normal Press
    if knop > MAX3:
        label_ia_np['text'] = "btn " + chr(ord('A') + (knop - 76))
        # hide global, steps, color, group
        combobox_holdtype.place(x=-1250)
        label_global_np.place(x=-205)
        checkbutton_glbl_np.place(x=-210)
        label_steps_np.place(x=-285)
        checkbutton_steps_np.place(x=-290)
        label_kleur_np.place(x=-230)
        label_kleurkleur_np.place(x=-145)
        combobox_kleur_np.place(x=-250)
        frame_groep_group_np.place(x=-2500)
    else:
        label_ia_np['text'] = "IA " + str(knop + 1)
        # show global, steps, color, group
        combobox_holdtype.place(x=125)
        label_global_np.place(x=205)
        checkbutton_glbl_np.place(x=210)
        label_steps_np.place(x=285)
        checkbutton_steps_np.place(x=290)
        label_kleur_np.place(x=23)
        label_kleurkleur_np.place(x=145)
        combobox_kleur_np.place(x=25)
        frame_groep_group_np.place(x=20)

    entry_name_np.delete(0, 'end')
    entry_name_np.insert(0, ias[knop].name)
    kleur = int(ias[knop].color)
    label_kleurkleur_np.config(bg=colors[kleur])
    combobox_kleur_np.current(kleur)
    var_np_glbl.set(ias[knop].glbl)
    var_np_steps.set(ias[knop].steps)
    var_np_group.set(ias[knop].group)
    changeColorGroup(True, ias[knop].group)

    # Long Press
    if knop > MAX3:
        label_ia_lp['text'] = "btn " + chr(ord('A') + (knop - 76))
        # hide global, steps, color, group
        label_global_lp.place(x=-205)
        checkbutton_glbl_lp.place(x=-210)
        label_steps_lp.place(x=-285)
        checkbutton_steps_lp.place(x=-290)
        label_kleur_lp.place(x=-230)
        label_kleurkleur_lp.place(x=-145)
        combobox_kleur_lp.place(x=-250)
        frame_groep_group_lp.place(x=-2500)
    else:
        label_ia_lp['text'] = "IA " + str(knoplp + 1)
        # show global, steps, color, group
        label_global_lp.place(x=205)
        checkbutton_glbl_lp.place(x=210)
        label_steps_lp.place(x=285)
        checkbutton_steps_lp.place(x=290)
        label_kleur_lp.place(x=23)
        label_kleurkleur_lp.place(x=145)
        combobox_kleur_lp.place(x=25)
        frame_groep_group_lp.place(x=20)
    holdtype = int(ias[knoplp].holdtype)
    combobox_holdtype.current(holdtype)
    entry_name_lp.delete(0, 'end')
    entry_name_lp.insert(0, ias[knoplp].name)
    kleur = int(ias[knoplp].color)
    label_kleurkleur_lp.config(bg=colors[kleur])
    combobox_kleur_lp.current(kleur)
    var_lp_glbl.set(ias[knoplp].glbl)
    var_lp_steps.set(ias[knoplp].steps)
    var_lp_group.set(ias[knoplp].group)
    changeColorGroup(False, ias[knoplp].group)

    for i in range(6):
        # Normal Press
        t = ias[knop].cmd[i].type
        if i == 0:
            combobox_cmd[i].current(getIndex(cmds1np, t))
        else:
            combobox_cmd[i].current(getIndex(cmds26, t))
        var_cc[i].set(ias[knop].cmd[i].cc)
        spinbox_cc[i].config(textvariable=var_cc[i])
        var_ch[i].set(ias[knop].cmd[i].ch)
        spinbox_ch[i].config(textvariable=var_ch[i])
        adjust_layout_ccch(t, i, False)

        # Long Press
        t = ias[knoplp].cmd[i].type
        if i == 0:
            combobox_cmd[i + 6].current(getIndex(cmds1lp, t))
        else:
            combobox_cmd[i + 6].current(getIndex(cmds26, t))
        var_cc[i + 6].set(ias[knoplp].cmd[i].cc)
        spinbox_cc[i + 6].config(textvariable=var_cc[i + 6])
        var_ch[i + 6].set(ias[knoplp].cmd[i].ch)
        spinbox_ch[i + 6].config(textvariable=var_ch[i + 6])
        adjust_layout_ccch(t, i + 6, False)


def press_onoff(x):
    cmd = ias[x].cmd[0].type
    if cmd == TYPE_CCONOFF or cmd == TYPE_CCOFFON:
        if presets[preset].ison[x] == 1:
            presets[preset].ison[x] = 0
            label_p_knop_name[x].config(bg=kleur_btn_back, fg=kleur_btn_front)
        else:
            presets[preset].ison[x] = 1
            label_p_knop_name[x].config(bg=colors[ias[x].color], fg=kleur_btn_front)


def press_logo():
    if windows:
        frame_info.place(x=415)
    else:
        frame_info.place(x=450)


def press_exppijl(nr):
    if nr > 2: # SW-2x
        if pijl_exp[3] is True:
            frame_act_as_sw2x_inner.place(x=10)
            frame_act_as_exp[0].place(x=-1000)
            frame_act_as_btn[0].place(x=-1000)
            combobox_exp_as_button1.current(0)
            pijl_exp[3] = False
        else:
            frame_act_as_sw2x_inner.place(x=-1000)
            frame_act_as_exp[0].place(x=10)
            frame_act_as_btn[0].place(x=-1000)
            combobox_sw2x_cmd[0].current(0)
            ias[MAX3].cmd[0].type = 0
            combobox_exp_as_button1.current(0)
            pijl_exp[3] = True
    else:
        if pijl_exp[nr] is True:
            frame_act_as_exp[nr].place(x=-1000)
            frame_act_as_btn[nr].place(x=10)
            pijl_exp[nr] = False
            if nr == 0:
                frame_act_as_sw2x_inner.place(x=-1000)
                combobox_sw2x_cmd[0].current(0)
        else:
            frame_act_as_exp[nr].place(x=10)
            frame_act_as_btn[nr].place(x=-1000)
            pijl_exp[nr] = True
            if nr == 0:
                combobox_exp_as_button1.current(0)
                frame_act_as_sw2x_inner.place(x=-1000)
                combobox_sw2x_cmd[0].current(0)
            elif nr == 1:
                combobox_exp_as_button2.current(0)
            elif nr == 2:
                combobox_exp_as_button3.current(0)


def press_easysetup1(c):
    global easysetup
    easysetup = c
    frame_easysetup1.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup3.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup2.place(x=5 + EASYPOSX, y=5, width=1196, height=495)


def press_easysetup2(c):
    global easysetup
    frame_easysetup1.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup2.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup3.place(x=5 + EASYPOSX, y=5, width=1196, height=495)

    if easysetup == "0515":
        text_easysetup3 = [["BLANK", "5 Presets\nBank Up/Down", "5 Fx\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Fx\nPreset Up/Down", "Boss Katana", "Eventide H9", "TC 2290", "Diezel VHX", ""],  # Midi
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Fx\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Fx\nPreset Up/Down", "", "", "", "", ""],  # Standard
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Fx\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Fx\nPreset Up/Down", "", "", "", "", ""],  # Ultra
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # II
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # II XL
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # II XL+
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # III
                           ["BLANK", "5 Performances\nBank Up/Down", "5 Rigs\nPerf. Up/Down",
                            "3 Performances\nBank Up/Down", "3 Rigs\nPerf. Up/Down", "", "", "", "", ""],  # Kemper
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Presets\nBank Up/Down",
                            "3 Snapshots\nPreset Up/Down", "3 Snapshots\nFS4 FS5", "Looper", "", "", "", ""],
                           # HX Stomp
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # FM3
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Presets\nPreset Up/Down", "8 Scenes\nTempo Tuner",
                            "Looper", "", "", "", "", ""],  # QC
                           ["BLANK", "5 Presets\nBank Up/Down", "5 Scenes\nPreset Up/Down", "3 Presets\nBank Up/Down",
                            "3 Scenes\nPreset Up/Down", "8 Scenes\nTempo Tuner", "", "", "", ""],  # FM9
                           ["BLANK", "5 Presets\nBank Up/Down", "5 FX\n(mod & dly types)", "",
                            "", "", "", "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\nBank Up/Down", "4 Stomps\nRig Up/Down\nTuner", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    elif easysetup == "0623":
        text_easysetup3 = [["BLANK", "6 Presets\nBank Up/Down", "6 Fx\nPreset Up/Down", "Boss Katana", "Eventide H9",
                            "TC 2290", "Diezel VHX", "", "", ""],  # Midi
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Fx\nPreset Up/Down",
                            "3 Presets\nBank Up/Down\nTempo", "3 Fx\nPreset Up/Down\nTempo", "== No LCD ==\nBLANK\n\n",
                            "== No LCD ==\n6 Presets\nBank Up/Down\n", "== No LCD ==\n6 Fx\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\nBank Up/Down\nTempo Tuner",
                            "== No LCD ==\n3 Fx\nPreset Up/Down\nTempo Tuner"],  # Standard
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Fx\nPreset Up/Down",
                            "3 Presets\nBank Up/Down\nTempo", "3 Fx\nPreset Up/Down\nTempo", "== No LCD ==\nBLANK\n\n",
                            "== No LCD ==\n6 Presets\nBank Up/Down\n", "== No LCD ==\n6 Fx\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\nBank Up/Down\nTempo Tuner",
                            "== No LCD ==\n3 Fx\nPreset Up/Down\nTempo Tuner"],  # Ultra
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n",
                            "== No LCD ==\n6 Presets\nBank Up/Down\n", "== No LCD ==\n6 Fx\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\nBank Up/Down\nTempo Tuner",
                            "== No LCD ==\n3 Fx\nPreset Up/Down\nTempo Tuner"],  # II
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n",
                            "== No LCD ==\n6 Presets\nBank Up/Down\n", "== No LCD ==\n6 Fx\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\nBank Up/Down\nTempo Tuner",
                            "== No LCD ==\n3 Fx\nPreset Up/Down\nTempo Tuner"],  # II XL
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n",
                            "== No LCD ==\n6 Presets\nBank Up/Down\n", "== No LCD ==\n6 Fx\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\nBank Up/Down\nTempo Tuner",
                            "== No LCD ==\n3 Fx\nPreset Up/Down\nTempo Tuner"],  # II XL+
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n", "== No LCD ==\n6 Presets\nBank Up/Down\n",
                            "== No LCD ==\n6 Scenes\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\n3 Scenes\nBank Up/Down",
                            "== No LCD ==\n8 Scenes\nPreset Up/Down\n"],  # III
                           ["BLANK", "6 Performances\nBank Up/Down", "3 Performances\n3 Rigs\nBank Up/Down",
                            "3 Performances\n3 Stomps\nBank Up/Down", "3 Rigs\n3 Stomps\nPerf. Up/Down",
                            "4 Rigs\nPerf. Up/Down", "4 Rigs\nPerf. Up/Down\nLooper (*)", "", "", ""],  # Kemper
                           ["BLANK", "3 Presets\nTempo/Tuner\nBank Up/Down", "6 Presets\nBank Up/Down",
                            "3 Presets\n3 Snapshots\nBank Up/Down", "3 Snapshots\nTempo/Tuner\nPreset Up/Down",
                            "Looper", "3 Snapshots\nTempo/Tuner\nFS4 FS5", "", "", ""],  # HX Stomp
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n", "== No LCD ==\n6 Presets\nBank Up/Down\n",
                            "== No LCD ==\n6 Scenes\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\n3 Scenes\nBank Up/Down",
                            "== No LCD ==\n8 Scenes\nPreset Up/Down\n"],  # FM3
                           ["BLANK", "6 Presets\nBank Up/Down", "3 Presets\nBank Up/Down\nTempo Tuner",
                            "3 Presets\n3 Scenes\nBank Up/Down", "6 Scenes\nPreset Up/Down", "Looper", "", "", "",
                            ""],  # QC
                           ["BLANK", "6 Presets\nBank Up/Down", "6 Scenes\nPreset Up/Down",
                            "3 Presets\n3 Scenes\nBank Up/Down", "8 Scenes\nPreset Up/Down",
                            "== No LCD ==\nBLANK\n\n", "== No LCD ==\n6 Presets\nBank Up/Down\n",
                            "== No LCD ==\n6 Scenes\nPreset Up/Down\n",
                            "== No LCD ==\n3 Presets\n3 Scenes\nBank Up/Down",
                            "== No LCD ==\n8 Scenes\nPreset Up/Down\n"],  # FM9
                           ["BLANK", "6 Presets\nBank Up/Down", "6 FX", "6 FX\n(mod & dly types)", "",
                            "", "", "", "", ""],  # Tonex
                           ["BLANK", "6 Rigs\nBank Up/Down", "3 Rigs\n3 Stomps\nBank Up/Down",
                            "4 Stomps\nRig Up/Down\nTuner", "", "", "", "", "", ""]]
                            # Kemper Player
    elif easysetup == "0933":
        text_easysetup3 = [["BLANK", "6 Presets\nFav. Preset\nBank Up/Down", "3 Presets\n4 Fx\nBank Up/Down",
                            "7 Fx\n Preset Up/Down", "Boss Katana", "Eventide H9", "TC 2290", "Diezel VHX", "", ""],
                           # Midi
                           ["BLANK", "6 Presets\nFav. Preset\nBank Up/Down",
                            "3 Presets\n3 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nTempo Tuner\nPreset Up/Down",
                            "6 Fx\nTempo Tuner\n6 Preset (*)\nBank Up/Down (*)", "", "", "", "", ""],  # Standard
                           ["BLANK", "6 Presets\nFav. Preset\nBank Up/Down",
                            "3 Presets\n3 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nTempo Tuner\nPreset Up/Down",
                            "6 Fx\nTempo Tuner\n6 Preset (*)\nBank Up/Down (*)", "", "", "", "", ""],  # Ultra
                           ["BLANK", "6 Presets\nFav. Preset\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down", "3 Presets\n4 Fx\nBank Up/Down",
                            "7 Scenes\nPreset Up/Down", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\nBank Up/Down\n6 Scenes (*)", "", ""],  # II
                           ["BLANK", "6 Presets\nFav. Preset\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down", "3 Presets\n4 Fx\nBank Up/Down",
                            "7 Scenes\nPreset Up/Down", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\nBank Up/Down\n6 Scenes (*)", "", ""],  # II XL
                           ["BLANK", "6 Presets\nFav. Preset\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down", "3 Presets\n4 Fx\nBank Up/Down",
                            "7 Scenes\nPreset Up/Down", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\nBank Up/Down\n6 Scenes (*)", "", ""],  # II XL+
                           ["BLANK", "6 Presets\nTempo Tuner\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down\nTempo", "3 Presets\n4 Fx\nBank Up/Down",
                            "6 Scenes\nPreset Up/Down\nTempo Tuner", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\n4 Fx\nPreset Up/Down", "3 Amp Channels\n6 Fx",
                            "8 Scenes\n6 Presets (*)\nBank Up/Down"],  # III
                           ["BLANK", "6 Performances\nFav. Perf.\nBank Up/Down", "3 Performances\n4 Rigs\nBank Up/Down",
                            "3 Performances\n4 Stomps\nBank Up/Down", "3 Rigs\n4 Stomps\nPerf. Up/Down",
                            "6 Performances\nBank Up/Down\n5 Rigs (*)\n3 Stomps (*)",
                            "6 Performances\nBank Up/Down\nLooper (*)\n2 Rigs (*)", "", "", ""],  # Kemper
                           ["BLANK", "6 Presets\nBank Up/Down\nTempo/Tuner",
                            "3 Presets\n3 Snapshots\nBank Up/Down\nTempo/Tuner",
                            "3 Snapshots\nLooper", "", "", "", "", "", ""],  # HX Stomp
                           ["BLANK", "6 Presets\nTempo Tuner\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down\nTempo", "3 Presets\n4 Fx\nBank Up/Down",
                            "6 Scenes\nPreset Up/Down\nTempo Tuner", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\n4 Fx\nPreset Up/Down", "3 Amp Channels\n6 Fx",
                            "8 Scenes\n6 Presets (*)\nBank Up/Down"],  # FM3
                           ["BLANK", "6 Presets\nBank Up/Down", "3 Presets\n6 Scenes\nBank Up/Down",
                            "6 Scenes\nPreset Up/Down\nTempo Tuner", "8 Scenes\nTempo Tuner",
                            "8 Scenes\n6 Presets (*)\nBank Up/Down\nTempo Tuner", "Looper\nTempo Tuner",
                            "8 Presets\n Bank Up/Down\nLooper (*)", "8 Scenes\nLooper (*)", ""],
                           # QC
                           ["BLANK", "8 Presets\nTempo Tuner\nBank Up/Down", "3 Presets\n4 Scenes\nBank Up/Down",
                            "3 Presets\n8 Scenes\nBank Up/Down\nTempo", "3 Presets\n4 Fx\nBank Up/Down",
                            "6 Scenes\nPreset Up/Down\nTempo Tuner", "3 Presets\n6 Scenes\nBank Up/Down\nLooper (*)",
                            "6 Presets\n4 Fx\nPreset Up/Down", "3 Amp Channels\n6 Fx",
                            "8 Scenes\n6 Presets (*)\nBank Up/Down"],  # FM9
                           ["BLANK", "6 Presets\nBank Up/Down\nTempo/Tuner",
                            "3 Presets\n3 Fx\nBank Up/Down\nTempo/Tuner", "6 Fx\nPreset Up/Down\nTempo/Tuner",
                            "8 FX\nTempo/Tuner", "", "", "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n2 Stomps\nBank Up/Down", "3 Rigs\n4 Stomps\nBank Up/Down\nTuner", "",
                            "", "", "", "", "", ""]]  # Kemper Player
    elif easysetup == "1226":
        text_easysetup3 = [["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Fx\nBank Up/Down",
                            "10 Fx\n Preset Up/Down", "TC 2290", "Boss Katana", "Eventide H9", "Diezel VHX", "", ""],
                           # Midi
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "5 Presets\n4 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Standard
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "5 Presets\n4 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Ultra
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL +
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # III
                           ["BLANK", "10 Performances\nBank Up/Down\nTuner",
                            "5 Performances\n5 Rigs\nBank Up/Down\nTuner",
                            "3 Performances\n5 Stomps\nBank Up/Down\nTuner", "5 Rigs\n5 Stomps\nPerf. Up/Down\nTuner",
                            "4 Rigs\n6 Stomps\nTempo Tuner\n10 Perf. (**)",
                            "5 Performances\n5 Rigs\nBank Up/Down\nTuner\nLooper (*)",
                            "4 Rigs\n4 Stomps\nTempo Tuner\nLooper (*)\nPerform. (**)",
                            "4 Rigs\n8 Stomps\nLooper (*)\nPerform2 (**)", ""],  # Kemper
                           ["BLANK", "10 Presets\nBank Up/Down", "6 Presets\n3 Snapshots\nBank Up/Down\nTempo/Tuner",
                            "3 Presets\nBank Up/Down\nLooper\nTempo/Tuner",
                            "5 Presets\n3 Snapshots\nFS4 FS5\nBank Up/Down", "", "", "", "", ""],  # HX Stomp
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM3
                           ["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Scenes\nBank Up/Down",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner", "Looper\nPreset Up/Down\nTempo Tuner",
                            "8 Stomps\nScene Up/Down\nPreset Up/Down", "5 Stomps\n5 Scenes\nPreset Up/Down",
                            "8 Presets\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Scenes\nTempo Tuner\nLooper (*)", ""],  # QC
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM9
                           ["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Fx\nBank Up/Down",
                            "10 Fx\nPreset Up/Down", "", "", "", "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n4 Stomps\nBank Up/Down\nTempo Tuner", "", "", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    elif easysetup == "1234":
        text_easysetup3 = [["BLANK", "10 Presets\nBank Up/Down", "4 Presets\n6 Fx\nBank Up/Down",
                            "10 Fx\n Preset Up/Down", "TC 2290", "Boss Katana", "Eventide H9", "Diezel VHX", "", ""],
                           # Midi
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "4 Presets\n5 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Standard
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "4 Presets\n5 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Ultra
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL+
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # III
                           ["BLANK", "10 Performances\nBank Up/Down\nTuner",
                            "4 Performances\n4 Rigs\n2 Stomps\nBank Up/Down\nTuner",
                            "4 Performances\n6 Stomps\nBank Up/Down\nTuner", "4 Rigs\n6 Stomps\nPerf. Up/Down\nTuner",
                            "4 Rigs\n6 Stomps\nTempo Tuner\n10 Perf. (**)",
                            "4 Performances\n4 Rigs\nBank Up/Down\nTuner\nLooper (*)",
                            "4 Rigs\n4 Stomps\nTempo Tuner\nLooper (*)\nPerform. (**)",
                            "4 Rigs\n8 Stomps\nLooper (*)\nPerform2 (**)", ""],  # Kemper
                           ["BLANK", "10 Presets\nBank Up/Down",
                            "6 Presets\n3 Snapshots\nBank Up/Down\nTempo/Tuner",
                            "3 Presets\nBank Up/Down\nLooper\nTempo/Tuner",
                            "4 Presets\n3 Snapshots\nFS4 FS5\nBank Up/Down\nTempo/Tuner", "", "", "", "", ""],
                           # HX Stomp
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM3
                           ["BLANK", "10 Presets\nBank Up/Down", "4 Presets\n6 Scenes\nBank Up/Down",
                            "8 Scenes\nNum. Preset\nPreset Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nNum. Preset\n10 Presets (*)\nBank Up/Down",
                            "Looper\nPreset Up/Down\nTempo Tuner",
                            "8 Stomps\nScene Up/Down\nPreset Up/Down",
                            "5 Stomps\n5 Scenes\nTuner Tempo\nPreset Up/Down",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)",],  # QC
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "4 Presets\n6 Scenes\nBank Up/Down\nTuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "4 Presets\n6 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM9
                           ["BLANK", "10 Presets\nBank Up/Down", "4 Presets\nBank Up/Down\n5 Fx\nTempo/Tuner",
                            "10 Fx\nPreset Up/Down", "", "", "", "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n4 Stomps\nBank Up/Down\nTempo Tuner", "", "", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    elif easysetup == "1836":
        text_easysetup3 = [["BLANK", "15 Presets\nBank Up/Down", "10 Presets\n6 Fx\nBank Up/Down",
                            "5 Presets\n11 Fx\n Bank Up/Down", "16Fx\nPreset Up/Down", "TC 2290", "Boss Katana",
                            "Diezel VHX", "", ""],  # Midi
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n20 Fx\nBank Up/Down\nTempo Tuner", "15 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", ""],  # Standard
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n20 Fx\nBank Up/Down\nTempo Tuner", "15 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", ""],  # Ultra
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II XL
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II XL+
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # III
                           ["BLANK", "10 Performances\n5 Rigs\nBank Up/Down\nTempo Tuner",
                            "5 Performances\n5 Rigs 5 Stomps\nBank Up/Down\nTempo Tuner",
                            "5 Performances\n8 Stomps\nBank Up/Down\nTempo Tuner",
                            "5 Rigs\n8 Stomps\nPerf. Up/Down\nTempo Tuner",
                            "5 Performances\n5 Rigs 4 Stomps\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "5 Rigs 8 Stomps\nTempo Tuner\nLooper (*)\nPerform2 (**)", "", "", ""],  # Kemper
                           ["BLANK", "15 Presets\nBank Up/Down\nTempo/Tuner",
                            "12 Presets\n3 Snapshots\nBank Up/Down\nTempo/Tuner",
                            "6 Presets\n3 Snapshots\nLooper\nTempo/Tuner\nBank Up/Down",
                            "10 Presets\n3 Snapshots\nfS4 FS5\nBank Up/Down\nTempo/Tuner", "", "", "", "", ""],
                           # HX Stomp
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # FM3
                           ["BLANK", "15 Presets\nBank Up/Down", "10 Presets\n5 Scenes\nBank Up/Down",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner",
                            "8 Stomps\n8 Scenes\nPreset Up/Down",
                            "6 Presets\nLooper\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nLooper\nTempo Tuner", "", "", ""],  # QC
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # FM9
                           ["BLANK", "15 Presets\nBank Up/Down\nTempo/Tuner",
                            "10 Presets\n5 Fx\nBank Up/Down\nTempo/Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo/Tuner", "", "", "",  "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n4 Stomps\nBank Up/Down\nTempo Tuner", "", "", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    elif easysetup == "1626":
        text_easysetup3 = [["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Fx\nBank Up/Down",
                            "10 Fx\n Preset Up/Down", "TC 2290", "Boss Katana", "Eventide H9", "Diezel VHX", "", ""],
                           # Midi
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "5 Presets\n4 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Standard
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner",
                            "5 Presets\n4 Fx\nBank Up/Down\nTempo Tuner", "8 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", "", ""],  # Ultra
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)", ""],  # II XL +
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # III
                           ["BLANK", "10 Performances\nBank Up/Down\nTuner",
                            "5 Performances\n5 Rigs\nBank Up/Down\nTuner",
                            "3 Performances\n5 Stomps\nBank Up/Down\nTuner", "5 Rigs\n5 Stomps\nPerf. Up/Down\nTuner",
                            "4 Rigs\n6 Stomps\nTempo Tuner\n10 Perf. (**)",
                            "5 Performances\n5 Rigs\nBank Up/Down\nTuner\nLooper (*)",
                            "4 Rigs\n4 Stomps\nTempo Tuner\nLooper (*)\nPerform. (**)",
                            "4 Rigs\n8 Stomps\nLooper (*)\nPerform2 (**)", ""],  # Kemper
                           ["BLANK", "10 Presets\nBank Up/Down", "6 Presets\n3 Snapshots\nBank Up/Down\nTempo/Tuner",
                            "3 Presets\nBank Up/Down\nLooper\nTempo/Tuner",
                            "5 Presets\n3 Snapshots\nFS4 FS5\nBank Up/Down", "", "", "", "", ""],  # HX Stomp
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM3
                           ["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Scenes\nBank Up/Down",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner", "Looper\nPreset Up/Down\nTempo Tuner",
                            "8 Stomps\nScene Up/Down\nPreset Up/Down", "5 Stomps\n5 Scenes\nPreset Up/Down",
                            "", "", ""],  # QC
                           ["BLANK", "10 Presets\nBank Up/Down\nTuner", "5 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner", "5 Presets\n5 Fx\nBank Up/Down\nTuner",
                            "8 Scenes\nPreset Up/Down\nTempo Tuner\nPresets (**)",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTuner\nLooper (*)",
                            "8 Presets\n8 Scenes (*)\nBank Up/Down\nTempo Tuner",
                            "8 Scenes\nTempo Tuner\nLooper (*)\nPresets (**)",
                            "OMG-12\n8 Scenes\nTempo Tuner\n10 Fx (*)\nPresets (**)"],  # FM9
                           ["BLANK", "10 Presets\nBank Up/Down", "5 Presets\n5 Fx\nBank Up/Down",
                            "10 Fx\nPreset Up/Down", "Looper\n5 Fx\nPreset Up/Down", "Looper\n5 Presets\nBank Up/Down",
                            "", "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n4 Stomps\nBank Up/Down\nTempo Tuner", "", "", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    elif easysetup == "2236":
        text_easysetup3 = [["BLANK", "15 Presets\nBank Up/Down", "10 Presets\n6 Fx\nBank Up/Down",
                            "5 Presets\n11 Fx\n Bank Up/Down", "16Fx\nPreset Up/Down", "TC 2290", "Boss Katana",
                            "Diezel VHX", "", ""],  # Midi
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n20 Fx\nBank Up/Down\nTempo Tuner", "15 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", ""],  # Standard
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n20 Fx\nBank Up/Down\nTempo Tuner", "15 Fx\nPreset Up/Down\nTempo Tuner",
                            "", "", "", "", ""],  # Ultra
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II XL
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner",
                            "10 Presets\n5 Scenes\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n8 Scenes 2 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)", "", "", ""],  # II XL+
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # III
                           ["BLANK", "10 Performances\n5 Rigs\nBank Up/Down\nTempo Tuner",
                            "5 Performances\n5 Rigs 5 Stomps\nBank Up/Down\nTempo Tuner",
                            "5 Performances\n8 Stomps\nBank Up/Down\nTempo Tuner",
                            "5 Rigs\n8 Stomps\nPerf. Up/Down\nTempo Tuner",
                            "5 Performances\n5 Rigs 4 Stomps\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "5 Rigs 8 Stomps\nTempo Tuner\nLooper (*)\nPerform2 (**)", "", "", ""],  # Kemper
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "12 Presets\n3 Snapshots\nBank Up/Down\nTuner",
                            "6 Presets\n3 Snapshots\nLooper\nTuner\nBank Up/Down",
                            "10 Presets\n3 Snapshots\nfS4 FS5\nBank Up/Down\nTuner", "", "", "", "", ""],  # HX Stomp
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # FM3
                           ["BLANK", "15 Presets\nBank Up/Down", "10 Presets\n5 Scenes\nBank Up/Down",
                            "5 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner",
                            "6 Presets\nLooper\nBank Up/Down\nTempo Tuner", "", "", "", "", ""],  # QC
                           ["BLANK", "15 Presets\nBank Up/Down\nTuner", "10 Presets\n5 Scenes\nBank Up/Down\nTuner",
                            "5 Presets\n8 Scenes 2Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo Tuner",
                            "5 Presets\n5 Scenes Looper\nBank Up/Down\nTempo Tuner",
                            "4 Presets\n8 Scenes\nBank Up/Down\nTempo Tuner\nLooper (*)",
                            "4 Amp+Cab\nDrive & Delay\nChannels\n5 Fx\nTempo Tuner",
                            "15 Presets\nBank Up/down\n14 Fx (*)\nTempo Tuner",
                            "5 Scenes\nTempo Tuner\n11 Fx (*)\n15 Presets (**)"],  # FM9
                           ["BLANK", "15 Presets\nBank Up/Down\nTempo", "10 Presets\n5 Fx\nBank Up/Down\nTempo",
                            "5 Presets\n10 Fx\nBank Up/Down\nTempo", "Looper\n10 Fx\nPreset Up/Down\nTempo",
                            "Looper\n10 Presets\nBank Up/Down\nTempo", "Looper\n5 Presets\n5 Fx\nBank Up/Down\nTempo",
                            "", "", ""],  # Tonex
                           ["BLANK", "5 Rigs\n4 Stomps\nBank Up/Down\nTempo Tuner", "", "", "", "", "", "", "",
                            "", ""]]  # Kemper Player
    else:
        text_easysetup3 = [["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"],
                           ["-", "-", "-", "-", "-", "-", "-", "-", "-", "-"]]

    easysetup = easysetup + c
    for i in range(10):
        button_easysetup3[i].config(text=text_easysetup3[int(c) - 1][i])


def press_easysetup3(c):
    global easysetup
    easysetup = easysetup + c
    filename = path_templates + easysetup
    read_txt(filename + ".txt")
    read_hex(filename + ".hex")
    loaddata()
    notebook_tabs.select(0)
    easysetup = ""
    frame_easysetup2.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup3.place(x=-1000, y=-1000, width=1196, height=495)
    frame_easysetup1.place(x=5 + EASYPOSX, y=5, width=1196, height=495)


def press_easysetup_return(c):
    global easysetup
    if c == 0:
        easysetup = ""
        frame_easysetup2.place(x=-1000, y=-1000, width=1196, height=495)
        frame_easysetup3.place(x=-1000, y=-1000, width=1196, height=495)
        frame_easysetup1.place(x=5 + EASYPOSX, y=5, width=1196, height=495)
    else:
        easysetup = easysetup[0:4]
        frame_easysetup1.place(x=-1000, y=-1000, width=1196, height=495)
        frame_easysetup3.place(x=-1000, y=-1000, width=1196, height=495)
        frame_easysetup2.place(x=5 + EASYPOSX, y=5, width=1196, height=495)


def getNumber(lijst, selectNaam):
    if selectNaam in [y[0] for y in lijst]:
        idx = [y[0] for y in lijst].index(selectNaam)
        return lijst[idx][1]
    else:
        return ""


def getName(lijst, selectNr):
    if selectNr in [y[1] for y in lijst]:
        idx = [y[1] for y in lijst].index(selectNr)
        return lijst[idx][0]
    else:
        return 0


def getIndex(lijst, selectNr):
    if selectNr in [y[1] for y in lijst]:
        idx = [y[1] for y in lijst].index(selectNr)
        return idx
    else:
        return 0


def on_tab_changed(event):
    selected_tab = event.widget.select()

    if selected_tab == ".!notebook.!frame6":
        frame_menu.place(x=-1745, y=55, width=480, height=26)
        press_easysetup_return(0)
    else:
        if windows is True:
            frame_menu.place(x=745, y=58, width=480, height=26)
        else:
            frame_menu.place(x=810, y=70, width=480, height=26)


def copypasteclear_button(type, isNormalPress):
    global knop, knopcopypaste, blocksavecurrentsettings
    knptemp = knop

    if type == 1: # copy
        blocksavecurrentsettings = True
        if isNormalPress:
            knopcopypaste = knop
        else:
            knopcopypaste = knop + 18

    elif type == 2: # paste
        blocksavecurrentsettings = True
        if isNormalPress:
            knptemp = knop
            ias[knptemp].name = ias[knopcopypaste].name
            entry_name_np.delete(0, 'end')
            entry_name_np.insert(0, ias[knptemp].name)
        else:
            knptemp = knptemp + 18
            ias[knptemp].name = ias[knopcopypaste].name
            entry_name_lp.delete(0, 'end')
            entry_name_lp.insert(0, ias[knptemp].name)

            ias[knptemp].holdtype = ias[knopcopypaste].holdtype
            ht = ias[knopcopypaste].holdtype
            label_knop_holdtype[knptemp].config(text=holdtypesshort[ht])

        ias[knptemp].color = ias[knopcopypaste].color
        for j in range(6):
            tmpType = int(ias[knopcopypaste].cmd[j].type)
            tmpCc = int(ias[knopcopypaste].cmd[j].cc)
            tmpCh = int(ias[knopcopypaste].cmd[j].ch)
            ias[knptemp].cmd[j].type = tmpType
            ias[knptemp].cmd[j].cc = tmpCc
            ias[knptemp].cmd[j].ch = tmpCh

        ias[knptemp].glbl = ias[knopcopypaste].glbl
        ias[knptemp].steps = ias[knopcopypaste].steps
        ias[knptemp].group = ias[knopcopypaste].group
        label_knop_name[knptemp].config(text=ias[knopcopypaste].name)
        label_knop_name[knptemp].config(fg=colors[ias[knopcopypaste].color])

        blocksavecurrentsettings = True
        if isNormalPress:
            press_button(knptemp)
        else:
            press_button(knptemp - 18)
        blocksavecurrentsettings = False

    else: # clear
        knopcopypaste = 0
        if isNormalPress:
            entry_name_np.delete(0, 'end')
        else:
            knptemp = knptemp + 18
            entry_name_lp.delete(0, 'end')

        ias[knptemp].color = 0
        for j in range(6):
            ias[knptemp].cmd[j].type = 0
            ias[knptemp].cmd[j].cc = 0
            ias[knptemp].cmd[j].ch = 0

        ias[knptemp].holdtype = 0
        ias[knptemp].glbl = 0
        ias[knptemp].steps = 0
        ias[knptemp].group = 0
        label_knop_name[knptemp].config(text="")
        label_knop_name[knptemp].config(fg=colors[0])
        label_knop_holdtype[knptemp].config(text="")

        if isNormalPress:
            press_button(knptemp)
        else:
            press_button(knptemp - 18)


def test(testinput):
    label_test['text'] = str(testinput)


########################################################################
########################################################################
# GUI
########################################################################
########################################################################

if windows:
    app_height = 700
    app_width = 1230
else:
    app_height = 730
    app_width = 1300

root = tk.Tk()
root.title(titel)

try:
    if windows:
        root.iconbitmap(path_bin + 'logo.ico')
    else:
        img = tk.Image("photo", file=path_bin + 'logo.gif')
        root.tk.call('wm', 'iconphoto', root._w, img)
except Exception as err:
    messagebox.showerror(titel, "GUI\n\n" + str(err))

root.resizable(False, False)
screen_width = root.winfo_screenwidth()
screen_height = root.winfo_screenheight() - 80
xx = (screen_width / 2) - (app_width / 2)
yy = (screen_height / 2) - (app_height / 2)
root.geometry(f'{app_width}x{app_height}+{int(xx)}+{int(yy)}')

canvas = tk.Canvas(root, height=app_height, width=app_width, bg=kleur_back)
canvas.pack()

image_title = tk.PhotoImage(file=path_bin + 'titel.png')
label_title = tk.Label(root, bg=kleur_back, image=image_title)
label_title.place(x=(app_width - 501) / 2, y=3, width=501, height=55)

label_test = tk.Label(root, bg=kleur_back, fg=kleur_front, anchor='w')
label_test.place(x=5, y=5, width=300, height=20)

# image_manual = tk.PhotoImage(file=path_bin + 'manual.png')
# button_manual = tk.Button(root, image=image_manual, bg=kleur_back, borderwidth=0,
#                           command=lambda: youtube('https://voes.be/midi-cc'))
# if windows:
#     button_manual.place(x=11, y=8)
# else:
#     button_manual.place(x=12, y=15)

image_midicc = tk.PhotoImage(file=path_bin + 'midi-cc.png')
button_midicc = tk.Button(root, image=image_midicc, bg=kleur_back, borderwidth=0,
                          command=lambda: youtube('https://voes.be/midi-cc'))
if windows:
    button_midicc.place(x=1175, y=8)
else:
    button_midicc.place(x=1240, y=15)

########################################################################
# Frame TABs
########################################################################
style = ttk.Style()
style.theme_create('mytheme', parent='alt', settings={
    'TNotebook': {'configure': {'background': kleur_back, 'borderwidth': 5}},
    'TNotebook.Tab': {
    'configure': {'background': kleur_front, 'foreground': kleur_back, 'font': FONT_TAB},
    'map': {'background': [('selected', kleur_geel)]} } } )
style.theme_use('mytheme')
notebook_tabs = ttk.Notebook(root)
notebook_tabs.bind("<<NotebookTabChanged>>", on_tab_changed)

if windows:
    notebook_tabs.place(x=10, y=63, width=1210, height=540)
else:
    notebook_tabs.place(x=15, y=77, width=1270, height=550)

frame_tab_buttons = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_presets = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_expinput = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_sysex = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_global = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_easysetup = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)

frame_tab_buttons.pack(fill="both", expand=1)
frame_tab_presets.pack(fill="both", expand=1)
frame_tab_expinput.pack(fill="both", expand=1)
frame_tab_sysex.pack(fill="both", expand=1)
frame_tab_global.pack(fill="both", expand=1)
frame_tab_easysetup.pack(fill="both", expand=1)

notebook_tabs.add(frame_tab_buttons, text=" Buttons  ")
notebook_tabs.add(frame_tab_presets, text=" Presets  ")
notebook_tabs.add(frame_tab_expinput, text=" Exp. Input  ")
notebook_tabs.add(frame_tab_sysex, text=" SysEx  ")
notebook_tabs.add(frame_tab_global, text=" Global  ")
notebook_tabs.add(frame_tab_easysetup, text=" Easy Setup  ")

########################################################################
# TAB Buttons - Frame Buttons
########################################################################
frame_buttons = tk.Frame(frame_tab_buttons, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
if windows:
    frame_buttons.place(x=5, y=10, width=540, height=490)
else:
    frame_buttons.place(x=5, y=20, width=540, height=490)

notebook_tabsAB = ttk.Notebook(frame_tab_buttons)
if windows:
    notebook_tabsAB.place(x=3, y=10, width=495, height=493)
    frame_tab_pageA = tk.Frame(notebook_tabsAB, width=450, height=450, bg=kleur_back)
    frame_tab_pageB = tk.Frame(notebook_tabsAB, width=450, height=450, bg="gray")
else:
    notebook_tabsAB.place(x=7, y=15, width=525, height=490)
    frame_tab_pageA = tk.Frame(notebook_tabsAB, width=450, height=450, bg=kleur_back)
    frame_tab_pageB = tk.Frame(notebook_tabsAB, width=450, height=450, bg="gray")

frame_tab_pageA.pack(fill="both", expand=1)
frame_tab_pageB.pack(fill="both", expand=1)
notebook_tabsAB.add(frame_tab_pageA, text=" Page A  ")
notebook_tabsAB.add(frame_tab_pageB, text=" Page B  ")

btn_image = tk.PhotoImage(file=path_bin + 'button.png')
button_knop = list()
label_knop_nr = list()
label_knop_name = list()
frame_knop = list()
label_knop_holdtype = list()

button_knop_abcd = list()
label_knop_abcd = list()

label_tip_np = tk.Label(frame_tab_pageA, bg=kleur_back, fg=kleur_geel, anchor='c', font=FONT_DRAGDROP,
                        text="Drag&Drop: Right click=Swap   Right click+CTRL=Copy   Right click+SHIFT=Copy color")
if windows:
    label_tip_np.place(x=-8, y=440, width=500, height=20)
else:
    label_tip_np.place(x=10, y=440, width=500, height=20)

for i in range(MAX3):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
    if i > 35:
        frame_knop.append(tk.Frame(frame_tab_pageB, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
    else:
        frame_knop.append(tk.Frame(frame_tab_pageA, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))

    label_knop_nr.append(tk.Label(frame_knop[i], text=i + 1, relief=tk.FLAT, borderwidth=0, bg=kleur_back,
                                  fg=kleur_front, font=FONT_KNOP_NR))

    if (17 < i < 36) or (i > 53):  # long press
        label_knop_nr[i].place(x=0, y=0, height=0, width=0)
        label_knop_name.append(tk.Label(frame_knop[i - 18], text=ias[i].name, relief=tk.FLAT, borderwidth=2,
                                        bg=kleur_back, fg=kleur_front, font=FONT_KNOP_ITALIC))
        label_knop_name[i].place(x=2, y=18, height=20, width=65)

        label_knop_holdtype.append(tk.Label(frame_knop[i - 18], text='', relief=tk.FLAT, borderwidth=0,
                                            bg=kleur_back, fg=kleur_geel, font=FONT_KNOP_NR))
        label_knop_holdtype[i].place(x=60, y=75, height=10, width=10)

    else:  # normal press
        label_knop_nr[i].place(x=0, y=35, height=20, width=20)
        label_knop_name.append(tk.Label(frame_knop[i], text=ias[i].name, relief=tk.FLAT, borderwidth=2,
                                        bg=kleur_back, fg=kleur_front, font=FONT_KNOP))
        label_knop_name[i].place(x=2, y=0, height=20, width=65)

        label_knop_holdtype.append(tk.Label(frame_knop[i], text='', borderwidth=0, bg=kleur_back, fg=kleur_front))
        label_knop_holdtype[i].place(x=-100, y=-100, height=20, width=20)

for i in range(MAX3):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
    if (17 < i < 36) or (i > 53):  # long press
        button_knop.append(tk.Button(frame_knop[i - 18]))
        button_knop[i].place(x=-100, y=-100, height=0, width=0)
    else:  # normal press
        if i > 35:
            button_knop.append(tk.Button(frame_tab_pageB, image=btn_image, text=i, relief=tk.FLAT, borderwidth=0,
                                         bg=kleur_back, command=lambda c=i: press_button(c)))
            button_knop[i].place(x=button_position[i - 36][0] + btnx, y=button_position[i - 36][1] + btny, height=42,
                                 width=42)
        else:
            button_knop.append(tk.Button(frame_tab_pageA, image=btn_image, text=i, relief=tk.FLAT, borderwidth=0,
                                         bg=kleur_back, command=lambda c=i: press_button(c)))
            button_knop[i].place(x=button_position[i][0] + btnx, y=button_position[i][1] + btny, height=42, width=42)
        if windows:
            button_knop[i].bind("<Button-3>", on_drag_start)
            button_knop[i].bind("<B3-Motion>", on_drag_motion)
            button_knop[i].bind("<ButtonRelease-3>", on_drag_stop)
        else:
            button_knop[i].bind("<Button-2>", on_drag_start)
            button_knop[i].bind("<B2-Motion>", on_drag_motion)
            button_knop[i].bind("<ButtonRelease-2>", on_drag_stop)
        button_knop[i].index = i

# frame abcd
frame_knop_abcd = tk.Frame(frame_tab_pageA, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
frame_knop_abcd.place(x=165, y=3, height=80, width=315)
for i in range(4):
    label_knop_abcd.append(tk.Label(frame_knop_abcd, text=chr(ord('A') + i), relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, fg=kleur_front, font=FONT_BIG))
    label_knop_abcd[i].place(x=(i*80), y=55, height=20, width=20)

    label_knop_name.append(tk.Label(frame_knop_abcd, text=ias[i].name, relief=tk.FLAT, borderwidth=2,
                                    bg=kleur_geel, fg=kleur_grijs, font=FONT_KNOP))



  #  label_knop_name[i].place(x=(i*80) + 20, y=30, height=20, width=65)
   # label_knop_name[i].place(x=20, y=30, height=20, width=65)

    # HIER
    # button_knop_abcd.append(tk.Button(frame_knop_abcd, image=btn_image, text=i, relief=tk.FLAT, borderwidth=2,
    #                                   bg=kleur_btn_back, command=lambda c=MAX4 + i: press_button(c)))
    # button_knop_abcd[i].place(x=(i*80) + 20, y=30, height=42, width=42)


########################################################################
# TAB Buttons - Frame Normal Press & Long Press
########################################################################
var_cc = []
var_ch = []
spinbox_cc = []
spinbox_ch = []
label_nr = []
label_cc = []
label_ch = []
combobox_cmd = []
combobox_afx = []
combobox_special = []
var_cmd = []
var_afx = []
var_special = []
var_np_steps = tk.IntVar()
var_np_glbl = tk.IntVar()
var_np_group = tk.IntVar()
var_lp_steps = tk.IntVar()
var_lp_glbl = tk.IntVar()
var_lp_group = tk.IntVar()

frame_normal_press = tk.Frame(frame_tab_buttons, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_long_press = tk.Frame(frame_tab_buttons, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)

image_rc345x490 = tk.PhotoImage(file=path_bin + 'rc345x490.png')
label_round_np = tk.Label(frame_normal_press, bg=kleur_back, image=image_rc345x490)
label_round_np.place(x=0, y=0, width=345, height=490)
label_round_lp = tk.Label(frame_long_press, bg=kleur_back, image=image_rc345x490)
label_round_lp.place(x=0, y=0, width=345, height=490)

if windows:
    frame_normal_press.place(x=500, y=10, width=345, height=490)
    frame_long_press.place(x=850, y=10, width=345, height=490)
else:
    frame_normal_press.place(x=545, y=15, width=345, height=490)
    frame_long_press.place(x=905, y=15, width=345, height=490)

# Normal Press
label_name_normal_press = tk.Label(frame_normal_press, text="Normal Press", font=FONT_BIG, bg=kleur_back,
                                   fg=kleur_front, anchor="w")
label_name_normal_press.place(x=100, y=5, width=150, height=30)
label_ia_np = tk.Label(frame_normal_press, text="IA", font=FONT_BIG, bg=kleur_back, fg=kleur_front, anchor="w")
label_ia_np.place(x=150, y=33, width=60, height=30)

label_name_np = tk.Label(frame_normal_press, text="name", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_name_np.place(x=23, y=100, width=150, height=30)
entry_name_np = tk.Entry(frame_normal_press, font=FONT, fg=kleur_back, bg=kleur_front)
entry_name_np.insert(0, "")
entry_name_np.bind("<Return>", lambda event, obj=i: enter_name(event, True, False, 0))
entry_name_np.place(x=23, y=130, width=100, height=30)

label_global_np = tk.Label(frame_normal_press, text="global", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_global_np.place(x=205, y=100, width=50, height=30)
checkbutton_glbl_np = tk.Checkbutton(frame_normal_press, text="", variable=var_np_glbl,
                                     command=lambda c=i: checkbutton_changed(True, 1))
checkbutton_glbl_np.place(x=210, y=135, width=19, height=16)

label_steps_np = tk.Label(frame_normal_press, text="steps", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_steps_np.place(x=285, y=100, width=50, height=30)
checkbutton_steps_np = tk.Checkbutton(frame_normal_press, text="", variable=var_np_steps,
                                      command=lambda c=i: checkbutton_changed(True, 2))
checkbutton_steps_np.place(x=290, y=135, width=19, height=16)

label_kleur_np = tk.Label(frame_normal_press, text="color", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_kleur_np.place(x=23, y=160, width=100, height=30)
label_kleurkleur_np = tk.Label(frame_normal_press, bg=colors[0], anchor="w")
label_kleurkleur_np.place(x=145, y=187, width=40, height=25)
combobox_kleur_np = ttk.Combobox(frame_normal_press, values=kleuren)
combobox_kleur_np.current(0)
combobox_kleur_np.place(x=25, y=185, width=100, height=28)
combobox_kleur_np.bind("<<ComboboxSelected>>", lambda event, obj=i: kleur_changed(event, True))
label_cmd_np = tk.Label(frame_normal_press, text="command", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_cmd_np.place(x=23, y=215, width=150, height=25)

# group np
frame_groep_group_np = tk.Frame(frame_normal_press, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_groep_group_np.place(x=20, y=455, width=300, height=20)
radiobutton_np_group0 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=0, bg=kleur_back,
                                       command=lambda c=i: group_changed(True, 0))
radiobutton_np_group0.place(x=65, y=10, width=20, height=20, anchor="w")
radiobutton_np_group1 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=1, bg=kleur_back,
                                       command=lambda c=i: group_changed(True, 1))
radiobutton_np_group1.place(x=135, y=10, width=20, height=20, anchor="w")
radiobutton_np_group2 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=2, bg=kleur_back,
                                       command=lambda c=i: group_changed(True, 2))
radiobutton_np_group2.place(x=175, y=10, width=20, height=20, anchor="w")
radiobutton_np_group3 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=3, bg=kleur_back,
                                       command=lambda c=i: group_changed(True, 3))
radiobutton_np_group3.place(x=215, y=10, width=20, height=20, anchor="w")
radiobutton_np_group4 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=4, bg=kleur_back,
                                       command=lambda c=i: group_changed(True, 4))
radiobutton_np_group4.place(x=255, y=10, width=20, height=20, anchor="w")
groupx = 10
groupy = 0
if not windows:
    groupx = 0
    groupy = 2
label_group_np = tk.Label(frame_groep_group_np, text="group:", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_group_np.place(x=3, y=groupy, width=50, height=20)
label_np_group0 = tk.Label(frame_groep_group_np, text="None", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group0.place(x=90-groupx, y=groupy, width=35, height=20)
label_np_group1 = tk.Label(frame_groep_group_np, text="1", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group1.place(x=160-groupx, y=groupy, width=15, height=20)
label_np_group2 = tk.Label(frame_groep_group_np, text="2", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group2.place(x=200-groupx, y=groupy, width=15, height=20)
label_np_group3 = tk.Label(frame_groep_group_np, text="3", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group3.place(x=240-groupx, y=groupy, width=15, height=20)
label_np_group4 = tk.Label(frame_groep_group_np, text="4", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group4.place(x=280-groupx, y=groupy, width=15, height=20)

# Long Press
label_name_long_press = tk.Label(frame_long_press, text="Long Press", bg=kleur_back, font=FONT_BIG, fg=kleur_front,
                                 anchor="w")
label_name_long_press.place(x=115, y=5, width=120, height=30)
label_ia_lp = tk.Label(frame_long_press, text="IA", font=FONT_BIG, bg=kleur_back, fg=kleur_front, anchor="w")
label_ia_lp.place(x=150, y=33, width=60, height=30)

label_holdtype = tk.Label(frame_long_press, text="hold-type", bg=kleur_back, font=FONT_MIDDLE, fg=kleur_front,
                          anchor="w")
label_holdtype.place(x=23, y=70, width=90, height=25)
label_triggeronly = tk.Label(frame_long_press, text="trigger-only", font=FONT, bg=kleur_back, fg=kleur_front,
                             anchor="w")
if windows:
    label_triggeronly.place(x=125, y=70, width=110, height=30)
else:
    label_triggeronly.place(x=125, y=68, width=110, height=30)

combobox_holdtype = ttk.Combobox(frame_long_press, values=holdtypes)
combobox_holdtype.current(0)
if windows:
    combobox_holdtype.place(x=125, y=70, width=110, height=28)
else:
    combobox_holdtype.place(x=125, y=65, width=110, height=28)
combobox_holdtype.bind("<<ComboboxSelected>>", lambda event, obj=i: holdtype_changed(event))

label_name_lp = tk.Label(frame_long_press, text="name", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_name_lp.place(x=23, y=100, width=150, height=30)
entry_name_lp = tk.Entry(frame_long_press, font=FONT, fg=kleur_back, bg=kleur_front)
entry_name_lp.insert(0, "")
entry_name_lp.bind("<Return>", lambda event, obj=i: enter_name(event, False, False, 0))
entry_name_lp.place(x=23, y=130, width=100, height=30)

label_global_lp = tk.Label(frame_long_press, text="global", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_global_lp.place(x=205, y=100, width=50, height=30)
checkbutton_glbl_lp = tk.Checkbutton(frame_long_press, text="", variable=var_lp_glbl,
                                     command=lambda c=i: checkbutton_changed(False, 1))
checkbutton_glbl_lp.place(x=210, y=135, width=19, height=16)

label_steps_lp = tk.Label(frame_long_press, text="steps", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_steps_lp.place(x=285, y=100, width=50, height=30)
checkbutton_steps_lp = tk.Checkbutton(frame_long_press, text="", variable=var_lp_steps,
                                      command=lambda c=i: checkbutton_changed(False, 2))
checkbutton_steps_lp.place(x=290, y=135, width=19, height=16)

label_kleur_lp = tk.Label(frame_long_press, text="color", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_kleur_lp.place(x=23, y=160, width=100, height=30)
label_kleurkleur_lp = tk.Label(frame_long_press, bg=colors[0], anchor="w")
label_kleurkleur_lp.place(x=145, y=187, width=40, height=25)
combobox_kleur_lp = ttk.Combobox(frame_long_press, values=kleuren)
combobox_kleur_lp.current(0)
combobox_kleur_lp.place(x=25, y=185, width=100, height=28)
combobox_kleur_lp.bind("<<ComboboxSelected>>", lambda event, obj=i: kleur_changed(event, False))
label_cmd_lp = tk.Label(frame_long_press, text="command", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_cmd_lp.place(x=23, y=215, width=150, height=25)

# group lp
frame_groep_group_lp = tk.Frame(frame_long_press, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_groep_group_lp.place(x=20, y=455, width=300, height=20)
radiobutton_lp_group0 = tk.Radiobutton(frame_groep_group_lp, variable=var_lp_group, value=0, bg=kleur_back,
                                       command=lambda c=i: group_changed(False, 0))
radiobutton_lp_group0.place(x=65, y=10, width=20, height=20, anchor="w")
radiobutton_lp_group1 = tk.Radiobutton(frame_groep_group_lp, variable=var_lp_group, value=1, bg=kleur_back,
                                       command=lambda c=i: group_changed(False, 1))
radiobutton_lp_group1.place(x=135, y=10, width=20, height=20, anchor="w")
radiobutton_lp_group2 = tk.Radiobutton(frame_groep_group_lp, variable=var_lp_group, value=2, bg=kleur_back,
                                       command=lambda c=i: group_changed(False, 2))
radiobutton_lp_group2.place(x=175, y=10, width=20, height=20, anchor="w")
radiobutton_lp_group3 = tk.Radiobutton(frame_groep_group_lp, variable=var_lp_group, value=3, bg=kleur_back,
                                       command=lambda c=i: group_changed(False, 3))
radiobutton_lp_group3.place(x=215, y=10, width=20, height=20, anchor="w")
radiobutton_lp_group4 = tk.Radiobutton(frame_groep_group_lp, variable=var_lp_group, value=4, bg=kleur_back,
                                       command=lambda c=i: group_changed(False, 4))
radiobutton_lp_group4.place(x=255, y=10, width=20, height=20, anchor="w")

label_group_lp = tk.Label(frame_groep_group_lp, text="group:", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_group_lp.place(x=3, y=groupy, width=50, height=20)
label_lp_group0 = tk.Label(frame_groep_group_lp, text="None", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_lp_group0.place(x=90-groupx, y=groupy, width=35, height=20)
label_lp_group1 = tk.Label(frame_groep_group_lp, text="1", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_lp_group1.place(x=160-groupx, y=groupy, width=15, height=20)
label_lp_group2 = tk.Label(frame_groep_group_lp, text="2", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_lp_group2.place(x=200-groupx, y=groupy, width=15, height=20)
label_lp_group3 = tk.Label(frame_groep_group_lp, text="3", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_lp_group3.place(x=240-groupx, y=groupy, width=15, height=20)
label_lp_group4 = tk.Label(frame_groep_group_lp, text="4", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_lp_group4.place(x=280-groupx, y=groupy, width=15, height=20)

# combobox and spinboxes Normal Press & Long Press
for i in range(12):
    k = i
    if i < 6:
        comboboxcmd = ttk.Combobox(frame_normal_press)
        comboboxafx = ttk.Combobox(frame_normal_press)
        comboboxspecial = ttk.Combobox(frame_normal_press)
    else:
        k = i - 6
        comboboxcmd = ttk.Combobox(frame_long_press)
        comboboxafx = ttk.Combobox(frame_long_press)
        comboboxspecial = ttk.Combobox(frame_long_press)

    combobox_cmd.append(comboboxcmd)
    combobox_cmd[i]['values'] = [x[0] for x in cmds_text[i]]
    combobox_cmd[i].current(0)
    combobox_cmd[i].place(x=23, y=240 + (k * 35), width=160, height=28)
    combobox_cmd[i].bind("<<ComboboxSelected>>", lambda event, c=i: cmd_changed(event, c, False))

    varcc = tk.IntVar(root)
    var_cc.append(varcc)
    var_cc[i].set(1)
    if i < 6:
        spinboxcc = ttk.Spinbox(frame_normal_press, from_=0, to=127, command=lambda c=i: cch_changed(True, c, False))

    else:
        spinboxcc = ttk.Spinbox(frame_long_press, from_=0, to=127, command=lambda c=i: cch_changed(True, c, False))
    spinboxcc.config(textvariable=var_cc[i])
    spinbox_cc.append(spinboxcc)
    spinbox_cc[i].place(x=210, y=240 + (k * 35), width=55, height=25)

    varch = tk.IntVar(root)
    var_ch.append(varch)
    var_ch[i].set(1)
    if i < 6:
        spinboxch = ttk.Spinbox(frame_normal_press, from_=0, to=127, command=lambda c=i: cch_changed(False, c, False))
    else:
        spinboxch = ttk.Spinbox(frame_long_press, from_=0, to=127, command=lambda c=i: cch_changed(False, c, False))
    spinboxch.config(textvariable=var_ch[i])
    spinbox_ch.append(spinboxch)
    spinbox_ch[i].place(x=285, y=240 + (k * 35), width=50, height=25)

    if i < 6:
        labelnr = tk.Label(frame_normal_press, text=str(i + 1), font=FONT_BIG, bg=kleur_back, fg=kleur_front,
                           anchor="w")
        labelcc = tk.Label(frame_normal_press, text="cc", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
        labelch = tk.Label(frame_normal_press, text="ch", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
    else:
        labelnr = tk.Label(frame_long_press, text=str(i + 1 - 6), font=FONT_BIG, bg=kleur_back, fg=kleur_front,
                           anchor="w")
        labelcc = tk.Label(frame_long_press, text="cc", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
        labelch = tk.Label(frame_long_press, text="ch", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")

    label_nr.append(labelnr)
    label_nr[i].place(x=5, y=240 + (k * 35), width=20, height=30)

    label_cc.append(labelcc)
    label_cc[i].place(x=190, y=240 + (k * 35), width=20, height=25)
    label_ch.append(labelch)
    label_ch[i].place(x=265, y=240 + (k * 35), width=20, height=25)

    combobox_afx.append(comboboxafx)
    combobox_afx[i]['values'] = [x[0] for x in afx]
    combobox_afx[i].current(0)
    combobox_afx[i].place(x=-505, y=240 + (k * 35), width=150, height=28)
    combobox_afx[i].bind("<<ComboboxSelected>>", lambda event, c=i: afx_changed(event, c))

    combobox_special.append(comboboxspecial)
    looper = looperFractal
    combobox_special[i]['values'] = [x[0] for x in looper]
    combobox_special[i].current(0)
    combobox_special[i].place(x=-505, y=240 + (k * 35), width=70, height=28)
    combobox_special[i].bind("<<ComboboxSelected>>", lambda event, c=i: special_changed(event, c, False))

# Copy, Paste, Clear
btn_copy = tk.PhotoImage(file=path_bin + 'copy.png')
btn_paste = tk.PhotoImage(file=path_bin + 'paste.png')
btn_clear = tk.PhotoImage(file=path_bin + 'clear.png')

button_copy_np = tk.Button(frame_normal_press, image=btn_copy, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(1, True))
button_copy_np.place(x=265, y=groupy+10, width=20, height=20)

button_paste_np = tk.Button(frame_normal_press, image=btn_paste, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(2, True))
button_paste_np.place(x=290, y=groupy+10, width=20, height=20)

button_clear_np = tk.Button(frame_normal_press, image=btn_clear, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(3, True))
button_clear_np.place(x=315, y=groupy+10, width=20, height=20)

button_copy_lp = tk.Button(frame_long_press, image=btn_copy, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(1, False))
button_copy_lp.place(x=265, y=groupy+10, width=20, height=20)

button_paste_lp = tk.Button(frame_long_press, image=btn_paste, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=i: copypasteclear_button(2, False))
button_paste_lp.place(x=290, y=groupy+10, width=20, height=20)

button_clear_lp = tk.Button(frame_long_press, image=btn_clear, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=i: copypasteclear_button(3, False))
button_clear_lp.place(x=315, y=groupy+10, width=20, height=20)

########################################################################
# TAB Presets
########################################################################
var_preset = tk.IntVar(root)
var_preset.set(1)

var_presets_add_usethis = tk.IntVar(root)
var_presets_add_usethis.set(0)

var_presets_add_pc_onoff = []
var_presets_add_pc_nr = []
var_presets_add_pc_ch = []

var_presets_add_cc_onoff = []
button_presets_add_cc = list()
var_presets_add_cc_cc = []
var_presets_add_cc_ch = []

xpresets = 0
if not windows:
    xpresets = 30
# presets list
frame_presets_list = tk.Frame(frame_tab_presets, bg=kleur_grijs, borderwidth=2, relief=tk.RIDGE)
frame_presets_list.place(x=125+xpresets, y=40, width=180, height=450)
scrollbar_presets = tk.Scrollbar(frame_presets_list, orient=tk.VERTICAL)
listbox_presets = tk.Listbox(frame_presets_list, font=FONT, yscrollcommand=scrollbar_presets.set)
listbox_presets.bind('<<ListboxSelect>>', select_preset)
listbox_presets.place(x=0, y=0, width=160, height=450)
listbox_presets.delete(0, tk.END)
for i in range(100):
    listbox_presets.insert(tk.END, str(i + 1) + ' ' + presets[i].name)
scrollbar_presets.config(command=listbox_presets.yview)
scrollbar_presets.pack(side=tk.RIGHT, fill=tk.Y)

button_import = tk.Button(frame_tab_presets, text="import names", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT,
                          command=lambda: importnames())
button_import.place(x=125+xpresets, y=20, height=20, width=90)

# presets
frame_presets = tk.Frame(frame_tab_presets, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_presets.place(x=315+xpresets, y=40, width=495, height=450)
image_rc495x450 = tk.PhotoImage(file=path_bin + 'rc495x450.png')
label_rc_presets = tk.Label(frame_presets, bg=kleur_grijs, image=image_rc495x450)
label_rc_presets.place(x=0, y=0, width=495, height=450)
label_preset_name = tk.Label(frame_presets, text="name (press enter)", font=FONT, bg=kleur_grijs, fg=kleur_front,
                             anchor="w")
label_preset_name.place(x=74, y=10, width=150, height=30)
spinbox_preset = ttk.Spinbox(frame_presets, from_=1, to=100, command=lambda c=i: preset_changed())
spinbox_preset.config(textvariable=var_preset)
spinbox_preset.place(x=20, y=40, width=50, height=25)
entry_preset_name = tk.Entry(frame_presets, font=FONT_MIDDLE, bg=kleur_back, fg=kleur_front)
entry_preset_name.insert(0, "Preset Name")
entry_preset_name.bind("<Return>", lambda event, obj=i: enter_preset_name(event))
entry_preset_name.place(x=75, y=38, width=230, height=30)

button_p_knop = list()
label_p_knop_nr = list()
label_p_knop_name = list()
frame_p_knop = list()

for i in range(MAX):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 (4x sw2x) MAX5=84 (8x abcd) PAGE=36
    frame_p_knop.append(tk.Frame(frame_presets, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))

    label_p_knop_nr.append(tk.Label(frame_p_knop[i], text=i + 1, relief=tk.FLAT, borderwidth=0, bg=kleur_back,
                                    fg=kleur_front, font=FONT_KNOP_NR))

    label_p_knop_nr[i].place(x=0, y=35, height=20, width=20)
    label_p_knop_name.append(tk.Label(frame_p_knop[i], text=ias[i].name, relief=tk.FLAT, borderwidth=2,
                                      bg=kleur_btn_back, fg=kleur_btn_front, font=FONT_KNOP))
    label_p_knop_name[i].place(x=0, y=0, height=20, width=70)

    button_p_knop.append(tk.Button(frame_p_knop[i], image=btn_image, text=i, relief=tk.FLAT, borderwidth=0,
                                   bg=kleur_back, command=lambda c=i: press_onoff(c)))
    button_p_knop[i].place(x=17, y=45, height=42, width=42)

# presets add
frame_presets_add = tk.Frame(frame_tab_presets, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_presets_add.place(x=820+xpresets, y=40, width=250, height=450)

image_rc250x450 = tk.PhotoImage(file=path_bin + 'rc250x450.png')
label_rc_presets_add = tk.Label(frame_presets_add, bg=kleur_grijs, image=image_rc250x450)
label_rc_presets_add.place(x=0, y=0, width=250, height=450)

frame_presets_add_links_kader = tk.Frame(frame_presets_add, bg=kleur_btn_grijs, borderwidth=2, relief=tk.RIDGE)
frame_presets_add_links_kader.place(x=11, y=60, width=100, height=380)

label_preset_add = tk.Label(frame_presets_add, text="per preset pc's & cc's", font=FONT_MIDDLE, bg=kleur_grijs,
                            fg=kleur_front, anchor="w")
label_preset_add.place(x=30+xpresets, y=3, width=185, height=30)
label_use_this_function = tk.Label(frame_presets_add, text="use this function", font=FONT, bg=kleur_grijs,
                                   fg=kleur_front, anchor="w")
label_use_this_function.place(x=85, y=30, width=120, height=30)

label_pc = tk.Label(frame_presets_add, text="pc", font=FONT, bg=kleur_grijs, fg=kleur_front, anchor="w")
label_pc.place(x=15, y=62, width=30, height=20)
label_onoff = tk.Label(frame_presets_add, text="on/off", font=FONT, bg=kleur_grijs, fg=kleur_front, anchor="w")
label_onoff.place(x=15, y=307, width=50, height=20)
label_cccc = tk.Label(frame_presets_add, text="cc", font=FONT, bg=kleur_grijs, fg=kleur_front, anchor="w")
label_cccc.place(x=120, y=307, width=30, height=20)
label_pcch = tk.Label(frame_presets_add, text="ch", font=FONT, bg=kleur_grijs, fg=kleur_front, anchor="w")
label_pcch.place(x=170, y=62, width=30, height=20)
label_pccc = tk.Label(frame_presets_add, text="ch", font=FONT, bg=kleur_grijs, fg=kleur_front, anchor="w")
label_pccc.place(x=170, y=307, width=30, height=20)

# add pc's
spinbox_presets_add_pc_nr = list()
label_presets_add_pc_tekst = list()  # tekst pc #
spinbox_presets_add_pc_ch = list()
checkbutton_presets_add_pc_onoff = list()

for i in range(8):
    varpresetsaddpconoff = tk.IntVar(root)
    var_presets_add_pc_onoff.append(varpresetsaddpconoff)
    var_presets_add_pc_onoff[i].set(0)

    varpresetsaddpcch = tk.IntVar(root)
    var_presets_add_pc_ch.append(varpresetsaddpcch)
    var_presets_add_pc_ch[i].set(0)

    varpresetsaddpc = tk.IntVar(root)
    var_presets_add_pc_nr.append(varpresetsaddpc)
    var_presets_add_pc_nr[i].set(0)

    checkbutton_presets_add_pc_onoff.append(tk.Checkbutton(frame_presets_add, variable=var_presets_add_pc_onoff[i],
                                                           command=lambda c=i:
                                                           checkbutton_presets_add_onoff_changed(c, True)))
    checkbutton_presets_add_pc_onoff[i].place(x=215, y=89 + (i * 28), height=20, width=20)

    spinboxpcch = ttk.Spinbox(frame_presets_add, from_=0, to=16)
    spinboxpcch.config(textvariable=var_presets_add_pc_ch[i])
    spinbox_presets_add_pc_ch.append(spinboxpcch)
    spinbox_presets_add_pc_ch[i].place(x=170, y=85 + (i * 28), height=25, width=35)

    spinboxpcnr = ttk.Spinbox(frame_presets_add, from_=0, to=127, command=lambda c=i: addpcnr_changed(c))
    spinboxpcnr.config(textvariable=var_presets_add_pc_nr[i])
    spinbox_presets_add_pc_nr.append(spinboxpcnr)
    spinbox_presets_add_pc_nr[i].place(x=17, y=85 + (i * 28), height=25, width=40)

    label_presets_add_pc_tekst.append(tk.Label(frame_presets_add, text="pc #" + str(i + 1), font=FONT, bg=kleur_grijs,
                                               fg=kleur_front, anchor="w"))
    label_presets_add_pc_tekst[i].place(x=65, y=84 + (i * 28), width=40, height=27)

# add cc's
label_presets_add_cc_tekst = list()  # tekst cc #
spinbox_presets_add_cc_cc = list()
spinbox_presets_add_cc_ch = list()
checkbutton_presets_add_cc_onoff = list()

for i in range(4):
    varpresetsaddcconoff = tk.IntVar(root)
    var_presets_add_cc_onoff.append(varpresetsaddcconoff)
    var_presets_add_cc_onoff[i].set(0)

    varpresetsaddccch = tk.IntVar(root)
    var_presets_add_cc_ch.append(varpresetsaddccch)
    var_presets_add_cc_ch[i].set(0)

    varpresetsaddcccc = tk.IntVar(root)
    var_presets_add_cc_cc.append(varpresetsaddcccc)
    var_presets_add_cc_cc[i].set(0)

    checkbutton_presets_add_cc_onoff.append(tk.Checkbutton(frame_presets_add, variable=var_presets_add_cc_onoff[i],
                                                           command=lambda c=i:
                                                           checkbutton_presets_add_onoff_changed(c, False)))
    checkbutton_presets_add_cc_onoff[i].place(x=215, y=334 + (i * 28), height=20, width=20)

    spinboxcccc = ttk.Spinbox(frame_presets_add, from_=0, to=127)
    spinboxcccc.config(textvariable=var_presets_add_cc_cc[i])
    spinbox_presets_add_cc_cc.append(spinboxcccc)
    spinbox_presets_add_cc_cc[i].place(x=120, y=330 + (i * 28), height=25, width=40)

    spinboxccch = ttk.Spinbox(frame_presets_add, from_=0, to=16)
    spinboxccch.config(textvariable=var_presets_add_cc_ch[i])
    spinbox_presets_add_cc_ch.append(spinboxccch)
    spinbox_presets_add_cc_ch[i].place(x=170, y=330 + (i * 28), height=25, width=35)

    label_presets_add_cc_tekst.append(tk.Label(frame_presets_add, text="cc #" + str(i + 1), font=FONT, bg=kleur_grijs,
                                               fg=kleur_front, anchor="w"))
    label_presets_add_cc_tekst[i].place(x=65, y=327 + (i * 28), width=40, height=27)

    button_presets_add_cc.append(tk.Button(frame_presets_add, relief=tk.FLAT, borderwidth=0,
                                           bg=kleur_back, command=lambda c=i: button_presets_add_pressed(c)))
    button_presets_add_cc[i].place(x=17, y=330 + (i * 28), height=20, width=20)

frame_hide_presets_add = tk.Frame(frame_presets_add, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_hide_presets_add.place(x=10, y=60, width=250, height=380)

checkbutton_use_this_function = tk.Checkbutton(frame_presets_add, variable=var_presets_add_usethis,
                                               command=lambda c=i: checkbutton_presets_add_usethis_changed())
checkbutton_use_this_function.place(x=65, y=35, height=20, width=20)

########################################################################
# TAB Exp. Input
########################################################################
var_exp1_cc = tk.IntVar(root)
var_exp1_cc.set(1)
var_exp1_ch = tk.IntVar(root)
var_exp1_ch.set(1)
var_auto1_cc = tk.IntVar(root)
var_auto1_cc.set(1)
var_auto1_ch = tk.IntVar(root)
var_auto1_ch.set(1)
var_exp2_cc = tk.IntVar(root)
var_exp2_cc.set(1)
var_exp2_ch = tk.IntVar(root)
var_exp2_ch.set(1)
var_auto2_cc = tk.IntVar(root)
var_auto2_cc.set(1)
var_auto2_ch = tk.IntVar(root)
var_auto2_ch.set(1)
var_exp3_cc = tk.IntVar(root)
var_exp3_cc.set(1)
var_exp3_ch = tk.IntVar(root)
var_exp3_ch.set(1)
var_exp1_auto_onoff = tk.IntVar(root)
var_exp1_auto_onoff.set(0)
var_exp1_resend = tk.IntVar(root)
var_exp1_resend.set(0)
var_exp2_auto_onoff = tk.IntVar(root)
var_exp2_auto_onoff.set(0)
var_exp1_min_cc = tk.IntVar(root)
var_exp1_min_cc.set(0)
var_exp1_max_cc = tk.IntVar(root)
var_exp1_max_cc.set(127)

# sw2x
var_sw2x_cc = []
var_sw2x_ch = []
spinbox_sw2x_cc = []
spinbox_sw2x_ch = []
label_sw2x_cc = []
label_sw2x_ch = []
combobox_sw2x_cmd = []
combobox_sw2x_afx = []
combobox_sw2x_special = []
var_sw2x_cmd = []
var_sw2x_afx = []
var_sw2x_special = []

#########################
# act as Expression Pedal
frame_act_as_exp_pedal = tk.Frame(frame_tab_expinput, bg=kleur_geel, borderwidth=0, relief=tk.RIDGE)
frame_act_as_exp_pedal.place(x=500, y=30, width=280, height=450)
image_rc280x450_2 = tk.PhotoImage(file=path_bin + 'rc280x450.png')
label_rc_act_as_exp = tk.Label(frame_act_as_exp_pedal, bg=kleur_grijs, image=image_rc280x450_2)
label_rc_act_as_exp.place(x=0, y=0, width=280, height=450)

label_act_as_exp_pedal = tk.Label(frame_act_as_exp_pedal, text="Act as Expr. Pedal", bg=kleur_grijs,
                                  font=FONT_BIG, fg=kleur_front, anchor="w")
if windows:
    label_act_as_exp_pedal.place(x=45, y=5, width=220, height=30)
else:
    label_act_as_exp_pedal.place(x=35, y=5, width=220, height=30)

# expr 1 pedal as expr. pedal
frame_act_as_exp = list()
frame_act_as_exp.append(tk.Frame(frame_act_as_exp_pedal, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_exp[0].place(x=10, y=40, width=260, height=200)
label_act_as_exp_exp1 = tk.Label(frame_act_as_exp[0], text="Expr 1 Pedal", bg=kleur_back, font=FONT, fg=kleur_front,
                                 anchor="w")
label_act_as_exp_exp1.place(x=5, y=30, width=180, height=30)
label_act_as_exp_exp1_cc = tk.Label(frame_act_as_exp[0], text="cc", font=FONT, bg=kleur_back, fg=kleur_front,
                                    anchor="w")
label_act_as_exp_exp1_cc.place(x=140, y=5, width=20, height=25)
spinbox_exp1_cc = ttk.Spinbox(frame_act_as_exp[0], from_=0, to=127)
spinbox_exp1_cc.config(textvariable=var_exp1_cc)
spinbox_exp1_cc.place(x=140, y=30, width=50, height=25)
label_act_as_exp_exp1_ch = tk.Label(frame_act_as_exp[0], text="ch", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp1_ch.place(x=200, y=5, width=20, height=25)
spinbox_exp1_ch = ttk.Spinbox(frame_act_as_exp[0], from_=1, to=16)
spinbox_exp1_ch.config(textvariable=var_exp1_ch)
spinbox_exp1_ch.place(x=200, y=30, width=50, height=25)
label_act_as_exp_exp1_auto_on = tk.Label(frame_act_as_exp[0], text="Expr 1 Auto On", bg=kleur_back, fg=kleur_front,
                                         font=FONT, anchor="w")
label_act_as_exp_exp1_auto_on.place(x=5, y=60, width=180, height=30)
spinbox_auto1_cc = ttk.Spinbox(frame_act_as_exp[0], from_=0, to=127)
spinbox_auto1_cc.config(textvariable=var_auto1_cc)
spinbox_auto1_cc.place(x=140, y=60, width=50, height=25)
spinbox_auto1_ch = ttk.Spinbox(frame_act_as_exp[0], from_=1, to=16)
spinbox_auto1_ch.config(textvariable=var_auto1_ch)
spinbox_auto1_ch.place(x=200, y=60, width=50, height=25)
checkbutton_exp1_auto = tk.Checkbutton(frame_act_as_exp[0], text="", variable=var_exp1_auto_onoff,
                                       command=lambda c=i: checkbutton_autoexp(1))
checkbutton_exp1_auto.place(x=110, y=65, width=19, height=16)

label_act_as_exp_minmax = tk.Label(frame_act_as_exp[0], text="Min/Max CC value", bg=kleur_back, font=FONT,
                                   fg=kleur_front, anchor="w")
label_act_as_exp_minmax.place(x=5, y=120, width=180, height=30)
label_act_as_exp_min_cc = tk.Label(frame_act_as_exp[0], text="min", font=FONT, bg=kleur_back, fg=kleur_front,
                                   anchor="w")
label_act_as_exp_min_cc.place(x=140, y=95, width=25, height=25)
spinbox_exp1_min_cc = ttk.Spinbox(frame_act_as_exp[0], from_=0, to=127)
spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
spinbox_exp1_min_cc.place(x=140, y=120, width=50, height=25)
label_act_as_exp_max_ch = tk.Label(frame_act_as_exp[0], text="max", bg=kleur_back, fg=kleur_front, font=FONT,
                                   anchor="w")
label_act_as_exp_max_ch.place(x=200, y=95, width=30, height=25)
spinbox_exp1_max_cc = ttk.Spinbox(frame_act_as_exp[0], from_=0, to=127)
spinbox_exp1_max_cc.config(textvariable=var_exp1_max_cc)
spinbox_exp1_max_cc.place(x=200, y=120, width=50, height=25)
#
label_act_as_exp_exp1_resend = tk.Label(frame_act_as_exp[0], text="Resend current value on\nScene or Pogram Change",
                                        bg=kleur_back, font=FONT, fg=kleur_front, justify="left")
if windows:
    label_act_as_exp_exp1_resend.place(x=5, y=150)
else:
    label_act_as_exp_exp1_resend.place(x=0, y=150)

checkbutton_exp1_resend = tk.Checkbutton(frame_act_as_exp[0], text="", variable=var_exp1_resend)
checkbutton_exp1_resend.place(x=200, y=160, width=19, height=16)

# expr 2 pedal as expr. pedal
frame_act_as_exp.append(tk.Frame(frame_act_as_exp_pedal, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_exp[1].place(x=5, y=250, width=260, height=100)
label_act_as_exp_exp2_cc = tk.Label(frame_act_as_exp[1], text="cc", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp2_cc.place(x=140, y=5, width=20, height=25)
spinbox_exp2_cc = ttk.Spinbox(frame_act_as_exp[1], from_=0, to=127)
spinbox_exp2_cc.config(textvariable=var_exp2_cc)
spinbox_exp2_cc.place(x=140, y=30, width=50, height=25)
label_act_as_exp_exp2_ch = tk.Label(frame_act_as_exp[1], text="ch", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp2_ch.place(x=200, y=5, width=20, height=25)
spinbox_exp2_ch = ttk.Spinbox(frame_act_as_exp[1], from_=1, to=16)
spinbox_exp2_ch.config(textvariable=var_exp2_ch)
spinbox_exp2_ch.place(x=200, y=30, width=50, height=25)
label_act_as_exp_exp2 = tk.Label(frame_act_as_exp[1], text="Expr 2 Pedal", bg=kleur_back, fg=kleur_front, font=FONT,
                                 anchor="w")
label_act_as_exp_exp2.place(x=5, y=30, width=100, height=30)
label_act_as_exp_exp2_auto_on = tk.Label(frame_act_as_exp[1], text="Expr 2 Auto On", bg=kleur_back, fg=kleur_front,
                                         font=FONT, anchor="w")
label_act_as_exp_exp2_auto_on.place(x=5, y=60, width=180, height=30)
checkbutton_exp2_auto = tk.Checkbutton(frame_act_as_exp[1], text="", variable=var_exp2_auto_onoff,
                                       command=lambda c=i: checkbutton_autoexp(2))
checkbutton_exp2_auto.place(x=110, y=65, width=19, height=16)
spinbox_auto2_cc = ttk.Spinbox(frame_act_as_exp[1], from_=0, to=127)
spinbox_auto2_cc.config(textvariable=var_auto2_cc)
spinbox_auto2_cc.place(x=140, y=60, width=50, height=25)
spinbox_auto2_ch = ttk.Spinbox(frame_act_as_exp[1], from_=1, to=16)
spinbox_auto2_ch.config(textvariable=var_auto2_ch)
spinbox_auto2_ch.place(x=200, y=60, width=50, height=25)

# expr 3 pedal as expr. pedal
frame_act_as_exp.append(tk.Frame(frame_act_as_exp_pedal, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_exp[2].place(x=5, y=360, width=260, height=80)
label_act_as_exp_exp3 = tk.Label(frame_act_as_exp[2], text="Expr 3 Pedal", bg=kleur_back, fg=kleur_front, font=FONT,
                                 anchor="w")
label_act_as_exp_exp3.place(x=5, y=30, width=180, height=30)
label_act_as_exp_exp3_cc = tk.Label(frame_act_as_exp[2], text="cc", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp3_cc.place(x=135, y=5, width=20, height=25)
spinbox_exp3_cc = ttk.Spinbox(frame_act_as_exp[2], from_=0, to=127)
spinbox_exp3_cc.config(textvariable=var_exp3_cc)
spinbox_exp3_cc.place(x=140, y=30, width=50, height=25)
label_act_as_exp_exp3_ch = tk.Label(frame_act_as_exp[2], text="ch", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp3_ch.place(x=200, y=5, width=20, height=25)
spinbox_exp3_ch = ttk.Spinbox(frame_act_as_exp[2], from_=1, to=16)
spinbox_exp3_ch.config(textvariable=var_exp3_ch)
spinbox_exp3_ch.place(x=200, y=30, width=50, height=25)

###############
# act as button
frame_act_as_button = tk.Frame(frame_tab_expinput, bg=kleur_geel, borderwidth=0, relief=tk.RIDGE)
frame_act_as_button.place(x=900, y=30, width=280, height=450)
image_rc280x450_3 = tk.PhotoImage(file=path_bin + 'rc280x450.png')
label_rc_act_as_exp = tk.Label(frame_act_as_button, bg=kleur_grijs, image=image_rc280x450_3)
label_rc_act_as_exp.place(x=0, y=0, width=280, height=450)

label_act_as_button = tk.Label(frame_act_as_button, text="Act as Button", bg=kleur_grijs, fg=kleur_front,
                               font=FONT_BIG, anchor="w")
if windows:
    label_act_as_button.place(x=70, y=5, width=200, height=30)
else:
    label_act_as_button.place(x=60, y=5, width=200, height=30)

frame_act_as_btn = list()
frame_act_as_btn.append(tk.Frame(frame_act_as_button, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_btn[0].place(x=10, y=40, width=260, height=200)
label_act_as_button_exp1 = tk.Label(frame_act_as_btn[0], text="Expr 1 as Button", bg=kleur_back, fg=kleur_front,
                                    font=FONT, anchor="w")
label_act_as_button_exp1.place(x=10, y=20, width=180, height=30)
combobox_exp_as_button1 = ttk.Combobox(frame_act_as_btn[0], values=[x[0] for x in cmdsexp])
combobox_exp_as_button1.current(0)
combobox_exp_as_button1.place(x=10, y=50, width=210, height=28)

frame_act_as_btn.append(tk.Frame(frame_act_as_button, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_btn[1].place(x=10, y=250, width=260, height=100)
label_act_as_button_exp2 = tk.Label(frame_act_as_btn[1], text="Expr 2 as Button", bg=kleur_back, fg=kleur_front,
                                    font=FONT, anchor="w")
label_act_as_button_exp2.place(x=10, y=10, width=180, height=30)
combobox_exp_as_button2 = ttk.Combobox(frame_act_as_btn[1], values=[x[0] for x in cmdsexp])
combobox_exp_as_button2.current(0)
combobox_exp_as_button2.place(x=10, y=40, width=210, height=28)

frame_act_as_btn.append(tk.Frame(frame_act_as_button, bg=kleur_back, borderwidth=2, relief=tk.RIDGE))
frame_act_as_btn[2].place(x=10, y=360, width=260, height=80)
label_act_as_button_exp3 = tk.Label(frame_act_as_btn[2], text="Expr 3 as Button", bg=kleur_back, fg=kleur_front,
                                    font=FONT, anchor="w")
label_act_as_button_exp3.place(x=10, y=10, width=180, height=30)
combobox_exp_as_button3 = ttk.Combobox(frame_act_as_btn[2], values=[x[0] for x in cmdsexp])
combobox_exp_as_button3.current(0)
combobox_exp_as_button3.place(x=10, y=40, width=210, height=28)

###############
# act as SW-2X
frame_act_as_sw2x = tk.Frame(frame_tab_expinput, bg=kleur_geel, borderwidth=0, relief=tk.RIDGE)
frame_act_as_sw2x.place(x=30, y=30, width=370, height=450)
image_rc370x450 = tk.PhotoImage(file=path_bin + 'rc370x450.png')
label_rc_act_as_sw2x = tk.Label(frame_act_as_sw2x, bg=kleur_grijs, image=image_rc370x450)
label_rc_act_as_sw2x.place(x=0, y=0, width=370, height=450)
label_act_as_sw2x = tk.Label(frame_act_as_sw2x, text="SW-2x (Expr 1 only)", bg=kleur_grijs, font=FONT_BIG,
                             fg=kleur_front, anchor="w")
if windows:
    label_act_as_sw2x.place(x=80, y=5, width=230, height=30)
else:
    label_act_as_sw2x.place(x=70, y=5, width=230, height=30)

frame_act_as_sw2x_inner = tk.Frame(frame_act_as_sw2x, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
frame_act_as_sw2x_inner.place(x=10, y=40, width=350, height=400)

label_act_as_sw2x_LBNP = tk.Label(frame_act_as_sw2x_inner, text="Left Button - Normal Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_LBNP.place(x=5, y=0, width=190, height=30)
label_act_as_sw2x_LBLP = tk.Label(frame_act_as_sw2x_inner, text="Left Button - Long Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_LBLP.place(x=5, y=100, width=190, height=30)
label_act_as_sw2x_RBNP = tk.Label(frame_act_as_sw2x_inner, text="Right Button - Normal Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_RBNP.place(x=5, y=200, width=190, height=30)
label_act_as_sw2x_RBLP = tk.Label(frame_act_as_sw2x_inner, text="Right Button - Long Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_RBLP.place(x=5, y=300, width=190, height=30)

entry_name_sw2x = list()
combobox_sw2x_cmd = list()
# textboxes (entry), comboboxes and spinboxes SW-2X
for i in range(4):
    entry_name_sw2x.append(tk.Entry(frame_act_as_sw2x_inner, font=FONT, fg=kleur_back, bg=kleur_front))
    entry_name_sw2x[i].insert(0, "")
    entry_name_sw2x[i].bind("<Return>", lambda event, c=i: enter_name(event, True, True, c))
    entry_name_sw2x[i].place(x=5, y=30 + (100 * i), width=100, height=25)

    comboboxcmd = ttk.Combobox(frame_act_as_sw2x_inner)
    comboboxafx = ttk.Combobox(frame_act_as_sw2x_inner)
    comboboxspecial = ttk.Combobox(frame_act_as_sw2x_inner)

    combobox_sw2x_cmd.append(comboboxcmd)
    combobox_sw2x_cmd[i]['values'] = [x[0] for x in cmdssw2x]  # 7 = sw2x commands
    combobox_sw2x_cmd[i].current(0)
    combobox_sw2x_cmd[i].place(x=5, y=60 + (i * 100), width=160, height=28)
    combobox_sw2x_cmd[i].bind("<<ComboboxSelected>>", lambda event, c=i: cmd_changed(event, c, True))

    varcc = tk.IntVar(root)
    var_sw2x_cc.append(varcc)
    var_sw2x_cc[i].set(1)
    spinboxcc = ttk.Spinbox(frame_act_as_sw2x_inner, from_=0, to=127, command=lambda c=i: cch_changed(True, c, True))
    spinboxcc.config(textvariable=var_sw2x_cc[i])
    spinbox_sw2x_cc.append(spinboxcc)
    spinbox_sw2x_cc[i].place(x=210, y=60 + (100 * i), width=50, height=25)

    varch = tk.IntVar(root)
    var_sw2x_ch.append(varch)
    var_sw2x_ch[i].set(1)
    spinboxch = ttk.Spinbox(frame_act_as_sw2x_inner, from_=0, to=127, command=lambda c=i: cch_changed(False, c, True))
    spinboxch.config(textvariable=var_sw2x_ch[i])
    spinbox_sw2x_ch.append(spinboxch)
    spinbox_sw2x_ch[i].place(x=285, y=60 + (100 * i), width=50, height=25)

    labelcc = tk.Label(frame_act_as_sw2x_inner, text="cc", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
    labelch = tk.Label(frame_act_as_sw2x_inner, text="ch", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")

    label_sw2x_cc.append(labelcc)
    label_sw2x_cc[i].place(x=190, y=60 + (100 * i), width=20, height=25)
    label_sw2x_ch.append(labelch)
    label_sw2x_ch[i].place(x=265, y=60 + (100 * i), width=20, height=25)

    combobox_sw2x_afx.append(comboboxafx)
    combobox_sw2x_afx[i]['values'] = [x[0] for x in afx]
    combobox_sw2x_afx[i].current(0)
    combobox_sw2x_afx[i].place(x=-505, y=60 + (100 * i), width=150, height=28)
    combobox_sw2x_afx[i].bind("<<ComboboxSelected>>", lambda event, c=i: afx_changed(event, c))

    combobox_sw2x_special.append(comboboxspecial)
    combobox_sw2x_special[i]['values'] = looperFractal
    combobox_sw2x_special[i].current(0)
    combobox_sw2x_special[i].place(x=-505, y=60 + (100 * i), width=70, height=28)
    combobox_sw2x_special[i].bind("<<ComboboxSelected>>", lambda event, c=i: special_changed(event, c, True))

########
# pijlen
img_pijl = tk.PhotoImage(file=path_bin + 'pijl.png')
button_pijl = []
for i in range(4):
    button_pijl.append(tk.Button(frame_tab_expinput, image=img_pijl, relief=tk.FLAT,
                                 borderwidth=1, bg=kleur_grijs, command=lambda c=i: press_exppijl(c)))
    button_pijl[i].place(x=815, y=180 + (i * 120), width=50, height=30)
button_pijl.append(tk.Button(frame_tab_expinput, image=img_pijl, relief=tk.FLAT,
                             borderwidth=1, bg=kleur_grijs, command=lambda c=i: press_exppijl(c)))
button_pijl[3].place(x=425, y=180, width=50, height=30)

########################################################################
# TAB SysEx
########################################################################
var_prefix = tk.IntVar(root)
var_prefix.set(1)
var_double = tk.IntVar(root)
var_double.set(0)

frame_sysex = tk.Frame(frame_tab_sysex, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_sysex.place(x=295+xpresets, y=50, width=600, height=400)
image_rc600x400 = tk.PhotoImage(file=path_bin + 'rc600x400.png')
label_rc_sysex = tk.Label(frame_sysex, bg=kleur_grijs, image=image_rc600x400)
label_rc_sysex.place(x=0, y=0, width=600, height=400)

label_sysex_titel = tk.Label(frame_sysex, text="Prefix", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_sysex_titel.place(x=12, y=17, width=200, height=20)

label_sysex_pressenter = tk.Label(frame_sysex, text="Press enter when changing values!", bg=kleur_grijs, fg="#ff0000",
                                  font=FONT_MIDDLE, anchor="w")
label_sysex_pressenter.place(x=150, y=10, width=350, height=20)

spinbox_prefix = ttk.Spinbox(frame_sysex, from_=0, to=8, command=lambda c=i: prefix_changed())
spinbox_prefix.config(textvariable=var_prefix)
spinbox_prefix.place(x=15, y=38, width=35, height=25)

checkbutton_double = tk.Checkbutton(frame_sysex, variable=var_double, command=lambda c=i: checkbutton_double_changed())
checkbutton_double.place(x=310, y=40, width=20, height=16)
label_double = tk.Label(frame_sysex, text="double", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_double.place(x=335, y=40, width=150, height=20)

entry_sysex = []
label_sysex = []
posx = 0
posy = 80
for i in range(80):
    entry_sysex.append(tk.Entry(frame_sysex, fg=kleur_back, bg=kleur_front, font=FONT))
    entry_sysex[i].insert(0, sysex[i])
    entry_sysex[i].place(x=50 + (posx * 30), y=posy, width=25, height=20)
    entry_sysex[i].bind("<Return>", lambda event, c=i: enter_sysex(event, c))
    posx = posx + 1
    if posx > 7:
        posx = 0
        posy = posy + 30

posx = 0
posy = 80
for i in range(80):
    entry_sysex.append(tk.Entry(frame_sysex, fg=kleur_back, bg=kleur_front, font=FONT))
    entry_sysex[i + 80].insert(0, sysex[i + 80])
    entry_sysex[i + 80].place(x=340 + (posx * 30), y=posy, width=25, height=20)
    entry_sysex[i + 80].bind("<Return>", lambda event, c=i + 80: enter_sysex(event, c))
    posx = posx + 1
    if posx > 7:
        posx = 0
        posy = posy + 30
# prefix
for i in range(8):
    entry_sysex.append(tk.Entry(frame_sysex, fg=kleur_back, bg=kleur_front, font=FONT))
    entry_sysex[i + 160].insert(0, sysex[i + 160])
    entry_sysex[i + 160].place(x=50 + (i * 30), y=40, width=25, height=20)
    entry_sysex[i + 160].bind("<Return>", lambda event, c=i + 160: enter_sysex(event, c))

for i in range(10):
    label_sysex.append(tk.Label(frame_sysex, text=i + 1, bg=kleur_back, fg=kleur_front, font=FONT, anchor="e"))
    label_sysex[i].place(x=20, y=75 + (i * 30), width=25, height=30)
for i in range(10):
    label_sysex.append(tk.Label(frame_sysex, text=i + 11, bg=kleur_back, fg=kleur_front, font=FONT, anchor="e"))
    label_sysex[i + 10].place(x=310, y=75 + (i * 30), width=25, height=30)

########################################################################
# TAB Global
########################################################################
# Global - Misc
var_global_preset_offset = tk.IntVar(root)
var_global_preset_offset.set(0)
var_global_bank_only = tk.IntVar(root)
var_global_bank_only.set(0)
var_global_ignore_pc = tk.IntVar(root)
var_global_ignore_pc.set(0)
var_global_reset_steps = tk.IntVar(root)
var_global_reset_steps.set(0)
var_global_cc_start_value = tk.IntVar(root)
var_global_cc_start_value.set(64)
var_global_auto_color = tk.IntVar(root)
var_global_auto_color.set(0)
# var_global_extendclone = tk.IntVar(root)
# var_global_extendclone.set(0)
var_global_long_press = tk.IntVar(root)
var_global_long_press.set(0)
var_global_reset_lcd = tk.IntVar(root)
var_global_reset_lcd.set(4)

# Global - External Device
var_global_midi_channel = tk.IntVar(root)
var_global_midi_channel.set(1)
var_global_show_preset = tk.IntVar(root)
var_global_show_preset.set(0)
var_global_start_preset = tk.IntVar(root)
var_global_start_preset.set(1)

# Global - Expr. Calibration
var_global_exp1_min = tk.IntVar(root)
var_global_exp1_min.set(10)
var_global_exp1_max = tk.IntVar(root)
var_global_exp1_max.set(245)
var_global_exp2_min = tk.IntVar(root)
var_global_exp2_min.set(10)
var_global_exp2_max = tk.IntVar(root)
var_global_exp2_max.set(245)
var_global_exp3_min = tk.IntVar(root)
var_global_exp3_min.set(10)
var_global_exp3_max = tk.IntVar(root)
var_global_exp3_max.set(245)

frame_misc = tk.Frame(frame_tab_global, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_misc.place(x=350, y=40, width=280, height=450)
image_rc280x450 = tk.PhotoImage(file=path_bin + 'rc280x450.png')
label_rc_misc = tk.Label(frame_misc, bg=kleur_grijs, image=image_rc280x450)
label_rc_misc.place(x=0, y=0, width=280, height=450)

# Tab Global - Misc
label_misc = tk.Label(frame_tab_global, text="Misc.", bg=kleur_back, fg=kleur_front, font=FONT_BIG, anchor="w")
label_misc.place(x=350, y=10, width=100, height=30)
label_misc_preset_offset = tk.Label(frame_misc, text="Preset Offset (-1)", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                    anchor="w")
label_misc_preset_offset.place(x=10, y=10, width=130, height=30)
checkbutton_preset_offset = tk.Checkbutton(frame_misc, text="", variable=var_global_preset_offset)
checkbutton_preset_offset.place(x=150, y=15, width=19, height=16)

label_misc_bank_only = tk.Label(frame_misc, text="Bank Only on Midi\nChannel Ext. Device", bg=kleur_grijs,
                                fg=kleur_front, font=FONT, justify="left")
checkbutton_bank_only = tk.Checkbutton(frame_misc, text="", variable=var_global_bank_only)
checkbutton_bank_only.place(x=150, y=60, width=19, height=16)

label_misc_ignore_pc = tk.Label(frame_misc, text="Don't send CC\nValues on PC", bg=kleur_grijs, fg=kleur_front,
                                font=FONT, justify="left")
checkbutton_ignore_pc = tk.Checkbutton(frame_misc, text="", variable=var_global_ignore_pc)
checkbutton_ignore_pc.place(x=150, y=100, width=19, height=16)

label_misc_reset_steps = tk.Label(frame_misc, text="Reset Steps", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_reset_steps.place(x=10, y=130, width=120, height=30)
checkbutton_reset_steps = tk.Checkbutton(frame_misc, text="", variable=var_global_reset_steps)
checkbutton_reset_steps.place(x=150, y=135, width=19, height=16)

label_misc_auto_color_steps = tk.Label(frame_misc, text="Auto Color Steps", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                       anchor="w")
label_misc_auto_color_steps.place(x=10, y=160, width=120, height=30)
checkbutton_auto_color_steps = tk.Checkbutton(frame_misc, text="", variable=var_global_auto_color)
checkbutton_auto_color_steps.place(x=150, y=165, width=19, height=16)

label_misc_cc_start_value = tk.Label(frame_misc, text="CC +/- start value", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                     anchor="w")
label_misc_cc_start_value.place(x=10, y=195, width=120, height=30)
spinbox_global_cc_start_value = ttk.Spinbox(frame_misc, from_=0, to=127)
spinbox_global_cc_start_value.config(textvariable=var_global_cc_start_value)
spinbox_global_cc_start_value.place(x=150, y=195, width=60, height=25)

label_misc_extendclone = tk.Label(frame_misc, text="Extend / Clone /\nSync / Merge", bg=kleur_grijs,
                                  fg=kleur_front, font=FONT, justify="left")
if windows:
    label_misc_bank_only.place(x=10, y=50, height=30)
    label_misc_ignore_pc.place(x=10, y=90, height=30)
    label_misc_extendclone.place(x=10, y=230, height=35)
else:
    label_misc_bank_only.place(x=5, y=50, height=30)
    label_misc_ignore_pc.place(x=5, y=90, height=30)
    label_misc_extendclone.place(x=5, y=230, height=35)

combobox_extendclone = ttk.Combobox(frame_misc, values=("none", "Extend Mother", "Extend Child", "Clone Mother",
                                                        "Clone Child", "Sync FM3/FM9/III", "Midi Merge", "Midi Merge (PC#)",
                                                        "Midi Merge (IA#)", "Midi In (PC#)", "Midi In (IA#)"))
combobox_extendclone.current(0)
combobox_extendclone.place(x=150, y=235, width=120, height=28)
combobox_extendclone.bind("<<ComboboxSelected>>", lambda event, obj=i: extendclone_changed(event))

label_misc_long_press = tk.Label(frame_misc, text="Long Press", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_long_press.place(x=10, y=275, width=120, height=30)
radiobutton_short_press = tk.Radiobutton(frame_misc, text="short", variable=var_global_long_press, value=0)
radiobutton_short_press.place(x=150, y=290, width=60, height=25, anchor="w")
radiobutton_long_press = tk.Radiobutton(frame_misc, text="long", variable=var_global_long_press, value=1)
radiobutton_long_press.place(x=210, y=290, width=60, height=25, anchor="w")

label_misc_reset_lcd = tk.Label(frame_misc, text="Reset LCD", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_reset_lcd.place(x=10, y=315, width=120, height=30)
spinbox_global_reset_lcd = ttk.Spinbox(frame_misc, from_=0, to=10)
spinbox_global_reset_lcd.config(textvariable=var_global_reset_lcd)
spinbox_global_reset_lcd.place(x=150, y=315, width=50, height=25)
label_misc_nullisoff = tk.Label(frame_misc, text="(0=off)", bg=kleur_grijs, fg=kleur_front, font=FONT_KNOP_ITALIC,
                                anchor="w")
label_misc_nullisoff.place(x=210, y=315, width=50, height=30)

label_misc_page_a_off_color = tk.Label(frame_misc, text="Page A Off Color", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                       anchor="w")
label_misc_page_a_off_color.place(x=10, y=350, width=120, height=30)
combobox_kleur_page_a = ttk.Combobox(frame_misc, values=kleuren)
combobox_kleur_page_a.current(0)
combobox_kleur_page_a.place(x=150, y=350, width=80, height=28)

label_misc_page_b_off_color = tk.Label(frame_misc, text="Page B Off Color", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                       anchor="w")
label_misc_page_b_off_color.place(x=10, y=380, width=120, height=30)
combobox_kleur_page_b = ttk.Combobox(frame_misc, values=kleuren)
combobox_kleur_page_b.current(0)
combobox_kleur_page_b.place(x=150, y=380, width=80, height=28)

label_misc_scene_ab_off_color = tk.Label(frame_misc, text="Scene A/B Off Color", bg=kleur_grijs, fg=kleur_front,
                                         font=FONT, anchor="w")
label_misc_scene_ab_off_color.place(x=10, y=410, width=130, height=30)
combobox_kleur_scene_ab = ttk.Combobox(frame_misc, values=kleuren)
combobox_kleur_scene_ab.current(0)
combobox_kleur_scene_ab.place(x=150, y=410, width=80, height=28)

# Tab Global - External Device
frame_external_device = tk.Frame(frame_tab_global, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_external_device.place(x=650, y=40, width=280, height=210)
image_rc280x210 = tk.PhotoImage(file=path_bin + 'rc280x210.png')
label_rc_external_device = tk.Label(frame_external_device, bg=kleur_grijs, image=image_rc280x210)
label_rc_external_device.place(x=0, y=0, width=280, height=210)

label_external_device = tk.Label(frame_tab_global, text="External Device", bg=kleur_back, fg=kleur_front, font=FONT_BIG,
                                 anchor="w")
label_external_device.place(x=650, y=10, width=200, height=30)
label_external_device_ext_device = tk.Label(frame_external_device, text="External Device", bg=kleur_grijs,
                                            fg=kleur_front, font=FONT, anchor="w")
label_external_device_ext_device.place(x=10, y=15, width=120, height=30)
combobox_device = ttk.Combobox(frame_external_device, values=[x[0] for x in devices])
combobox_device.current(0)
combobox_device.place(x=150, y=15, width=120, height=28)

label_external_device_midi_channel = tk.Label(frame_external_device, text="Midi Channel", bg=kleur_grijs,
                                              fg=kleur_front, font=FONT, anchor="w")
label_external_device_midi_channel.place(x=10, y=55, width=120, height=30)
spinbox_global_midi_channel = ttk.Spinbox(frame_external_device, from_=1, to=16)
spinbox_global_midi_channel.config(textvariable=var_global_midi_channel)
spinbox_global_midi_channel.place(x=150, y=55, width=50, height=25)

label_external_device_tuner = tk.Label(frame_external_device, text="Tuner", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                       anchor="w")
label_external_device_tuner.place(x=10, y=95, width=120, height=30)
combobox_tuner = ttk.Combobox(frame_external_device, values=("Mixed", "Flat", "Sharp"))
combobox_tuner.current(0)
combobox_tuner.place(x=150, y=95, width=100, height=28)

label_external_device_showpreset = tk.Label(frame_external_device, text="Show Preset #", bg=kleur_grijs, font=FONT,
                                            fg=kleur_front, anchor="w")
label_external_device_showpreset.place(x=10, y=135, width=120, height=30)
checkbutton_showpreset = tk.Checkbutton(frame_external_device, text="", variable=var_global_show_preset)
checkbutton_showpreset.place(x=150, y=140, width=19, height=16)

label_misc_start_preset = tk.Label(frame_external_device, text="Start Preset", bg=kleur_grijs, fg=kleur_front,
                                   font=FONT, anchor="w")
label_misc_start_preset.place(x=10, y=175, width=120, height=30)
spinbox_global_start_preset = ttk.Spinbox(frame_external_device, from_=0, to=1024)
spinbox_global_start_preset.config(textvariable=var_global_start_preset)
spinbox_global_start_preset.place(x=150, y=175, width=60, height=25)

# Tab Global - Expression Calibration
frame_expr_calibration = tk.Frame(frame_tab_global, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_expr_calibration.place(x=650, y=300, width=280, height=190)
image_rc280x190 = tk.PhotoImage(file=path_bin + 'rc280x190.png')
label_rc_exprcalib = tk.Label(frame_expr_calibration, bg=kleur_grijs, image=image_rc280x190)
label_rc_exprcalib.place(x=0, y=0, width=280, height=190)

label_expr_calibration = tk.Label(frame_tab_global, text="Expr. Calibration", bg=kleur_back, fg=kleur_front,
                                  font=FONT_BIG, anchor="w")
label_expr_calibration.place(x=650, y=270, width=220, height=30)
label_expr_min = tk.Label(frame_expr_calibration, text="min", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_expr_min.place(x=150, y=15, width=50, height=30)
label_expr_max = tk.Label(frame_expr_calibration, text="max", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_expr_max.place(x=215, y=15, width=50, height=30)
label_expr_expr1_calib = tk.Label(frame_expr_calibration, text="Expr. 1 Calib.", bg=kleur_grijs, fg=kleur_front,
                                  font=FONT, anchor="w")
label_expr_expr1_calib.place(x=10, y=45, width=120, height=30)
spinbox_global_exp1_min = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp1_min.config(textvariable=var_global_exp1_min)
spinbox_global_exp1_min.place(x=150, y=45, width=50, height=25)
spinbox_global_exp1_max = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp1_max.config(textvariable=var_global_exp1_max)
spinbox_global_exp1_max.place(x=215, y=45, width=55, height=25)

label_expr_expr2_calib = tk.Label(frame_expr_calibration, text="Expr. 2 Calib.", bg=kleur_grijs, fg=kleur_front,
                                  font=FONT, anchor="w")
label_expr_expr2_calib.place(x=10, y=85, width=120, height=30)
spinbox_global_exp2_min = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp2_min.config(textvariable=var_global_exp2_min)
spinbox_global_exp2_min.place(x=150, y=85, width=50, height=25)
spinbox_global_exp2_max = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp2_max.config(textvariable=var_global_exp2_max)
spinbox_global_exp2_max.place(x=215, y=85, width=55, height=25)

label_expr_expr3_calib = tk.Label(frame_expr_calibration, text="Expr. 3 Calib.", bg=kleur_grijs, fg=kleur_front,
                                  font=FONT, anchor="w")
label_expr_expr3_calib.place(x=10, y=125, width=120, height=30)
spinbox_global_exp3_min = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp3_min.config(textvariable=var_global_exp3_min)
spinbox_global_exp3_min.place(x=150, y=125, width=50, height=25)
spinbox_global_exp3_max = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp3_max.config(textvariable=var_global_exp3_max)
spinbox_global_exp3_max.place(x=215, y=125, width=55, height=25)

########################################################################
# TAB Easy Setup
########################################################################
frame_easysetup1 = tk.Frame(frame_tab_easysetup, bg=kleur_back, bd=1)
frame_easysetup2 = tk.Frame(frame_tab_easysetup, bg=kleur_back, bd=1)
frame_easysetup3 = tk.Frame(frame_tab_easysetup, bg=kleur_back, bd=1)

########################################################################
# TAB Easy Setup - Step 1
########################################################################
frame_easysetup1.place(x=5 + EASYPOSX, y=5, width=1196, height=495)
label_easysetup1_titel = tk.Label(frame_easysetup1, text="EASY SETUP\n\nSTEP 1 OF 3\nwhich MX device do you use?",
                                  bg=kleur_back, font=FONT_BIG, fg=kleur_geel)
label_easysetup1_titel.place(x=350 + EASYPOSX, y=0, width=500, height=110)

img_mx5 = tk.PhotoImage(file=path_bin + 'mx5.png')
img_mx6 = tk.PhotoImage(file=path_bin + 'mx6.png')
img_mx9 = tk.PhotoImage(file=path_bin + 'mx9.png')
img_mx1226 = tk.PhotoImage(file=path_bin + 'mx1226.png')
img_mx1234 = tk.PhotoImage(file=path_bin + 'mx1234.png')
img_mx18 = tk.PhotoImage(file=path_bin + 'mx18.png')

button_mx5 = tk.Button(frame_easysetup1, image=img_mx5, text='MX-5', relief=tk.FLAT, borderwidth=0,
                       bg=kleur_back, command=lambda c='0515': press_easysetup1(c))
button_mx5.place(x=210 + EASYPOSX, y=120, height=100, width=200)
label_easysetup1_mx5 = tk.Label(frame_easysetup1, text="MX-5", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx5.place(x=255 + EASYPOSX, y=225, width=100, height=30)

button_mx6 = tk.Button(frame_easysetup1, image=img_mx6, text='MX-6', relief=tk.FLAT, borderwidth=0,
                       bg=kleur_back, command=lambda c='0623': press_easysetup1(c))
button_mx6.place(x=490 + EASYPOSX, y=120, height=100, width=200)
label_easysetup1_mx6 = tk.Label(frame_easysetup1, text="MX-6", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx6.place(x=540 + EASYPOSX, y=225, width=100, height=30)

button_mx9 = tk.Button(frame_easysetup1, image=img_mx9, text='MX-9', relief=tk.FLAT, borderwidth=0,
                       bg=kleur_back, command=lambda c='0933': press_easysetup1(c))
button_mx9.place(x=760 + EASYPOSX, y=120, height=100, width=200)
label_easysetup1_mx9 = tk.Label(frame_easysetup1, text="MX-9", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx9.place(x=815 + EASYPOSX, y=225, width=100, height=30)

button_mx1226 = tk.Button(frame_easysetup1, image=img_mx1226, text='MX-12 (2x6)', relief=tk.FLAT, borderwidth=0,
                          bg=kleur_back, command=lambda c='1226': press_easysetup1(c))
button_mx1226.place(x=210 + EASYPOSX, y=300, height=100, width=200)
label_easysetup1_mx1226 = tk.Label(frame_easysetup1, text="MX-12\n2x6", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx1226.place(x=245 + EASYPOSX, y=405, width=120, height=60)

button_mx1234 = tk.Button(frame_easysetup1, image=img_mx1234, text='MX-12 (3x4)', relief=tk.FLAT, borderwidth=0,
                          bg=kleur_back, command=lambda c='1234': press_easysetup1(c))
button_mx1234.place(x=490 + EASYPOSX, y=300, height=100, width=200)
label_easysetup1_mx1234 = tk.Label(frame_easysetup1, text="MX-12\n3x4", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx1234.place(x=530 + EASYPOSX, y=405, width=120, height=60)

button_mx18 = tk.Button(frame_easysetup1, image=img_mx18, text='MX-18', relief=tk.FLAT, borderwidth=0,
                        bg=kleur_back, command=lambda c='1836': press_easysetup1(c))
button_mx18.place(x=760 + EASYPOSX, y=290, height=100, width=200)
label_easysetup1_mx18 = tk.Label(frame_easysetup1, text="MX-18", bg=kleur_back, fg=kleur_geel, font=FONT_BIG)
label_easysetup1_mx18.place(x=805 + EASYPOSX, y=405, width=120, height=60)


########################################################################
# TAB Easy Setup - Step 2
########################################################################
label_easysetup2_titel = tk.Label(frame_easysetup2, bg=kleur_back, fg=kleur_geel, font=FONT_BIG,
                                  text="EASY SETUP\n\nSTEP 2 OF 3\nwhich device do you want to control?")
label_easysetup2_titel.place(x=350 + EASYPOSX, y=0, width=500, height=110)

frame_easysetup2_model = []
img_easysetup2 = []
button_easysetup2 = []
label_easysetup2 = []
txt_easysetup2 = ["Midi", "Axe-Fx Standard", "Axe-Fx Ultra", "Axe-Fx II", "Axe-Fx II XL", "Axe-Fx II XL+",
                  "Axe-Fx III", "Kemper", "HX Stomp", "FM3", "Quad Cortex", "FM9", "Tonex", "Kemper Player"]
posx = [100, 300, 500, 700, 900, 100, 300, 500, 700, 900, 100, 300, 500, 700]
posy = [125, 125, 125, 125, 125, 235, 235, 235, 235, 235, 345, 345, 345, 345]

for i in range(14):
    nr = str(i + 1)
    if i < 9:
        nr = "0" + nr
    frame_easysetup2_model.append(tk.Frame(frame_easysetup2, bg=kleur_btn_wit, bd=1))
    frame_easysetup2_model[i].place(x=posx[i] + 20 + EASYPOSX, y=posy[i], width=160, height=100)
    img_easysetup2.append(tk.PhotoImage(file=path_bin + str(i) + '.png'))
    button_easysetup2.append(tk.Button(frame_easysetup2_model[i], image=img_easysetup2[i], text=nr, relief=tk.FLAT,
                                       borderwidth=1, bg=kleur_btn_grijs, command=lambda c=nr: press_easysetup2(c)))
    button_easysetup2[i].place(x=0, y=0, width=157, height=78)
    label_easysetup2.append(tk.Label(frame_easysetup2_model[i], text=txt_easysetup2[i], bg=kleur_grijs, font=FONT,
                                     fg=kleur_front))
    label_easysetup2[i].place(x=0, y=70, width=157, height=28)

button_easysetup2_return = tk.Button(frame_easysetup2, text="back to step 1", relief=tk.FLAT, borderwidth=1,
                                     bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MIDDLE,
                                     command=lambda c=0: press_easysetup_return(c))
button_easysetup2_return.place(x=510 + EASYPOSX, y=460, width=180, height=30)

########################################################################
# TAB Easy Setup - Step 3
########################################################################
label_easysetup3_titel = tk.Label(frame_easysetup3, text="EASY SETUP\n\nSTEP 3 OF 3\nchoose a template",
                                  bg=kleur_back, font=FONT_BIG, fg=kleur_geel)
label_easysetup3_titel.place(x=350 + EASYPOSX, y=0, width=500, height=110)

label_easysetup3_undertitel = tk.Label(frame_easysetup3, text="(* = page B    ** = page P)", font=FONT_KNOP_ITALIC,
                                       bg=kleur_back, fg=kleur_btn_wit)
label_easysetup3_undertitel.place(x=350 + EASYPOSX, y=80, width=500, height=30)

frame_easysetup3_template = []
button_easysetup3 = []
posx = [100, 300, 500, 700, 900, 100, 300, 500, 700, 900]
posy = [145, 145, 145, 145, 145, 275, 275, 275, 275, 275]

for i in range(10):
    nr = str(i + 1)
    if i < 9:
        nr = "0" + nr
    frame_easysetup3_template.append(tk.Frame(frame_easysetup3, bg=kleur_btn_wit, bd=1))
    frame_easysetup3_template[i].place(x=posx[i] + 20 + EASYPOSX, y=posy[i], width=160, height=100)
    button_easysetup3.append(tk.Button(frame_easysetup3_template[i], text=nr, relief=tk.FLAT, font=FONT_TMPL,
                                       bg=kleur_btn_grijs, fg=kleur_btn_front,
                                       borderwidth=1, command=lambda c=nr: press_easysetup3(c)))
    button_easysetup3[i].place(x=0, y=0, width=157, height=98)

button_easysetup3_return = tk.Button(frame_easysetup3, text="back to step 2", relief=tk.FLAT, borderwidth=1,
                                     bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MIDDLE,
                                     command=lambda c=1: press_easysetup_return(1))
button_easysetup3_return.place(x=510 + EASYPOSX, y=460, width=180, height=30)

########################################################################
# Frame Menu
########################################################################
frame_menu = tk.Frame(root, bg=kleur_back, bd=0)

if windows is True:
    frame_menu.place(x=745, y=58, width=480, height=26)
else:
    frame_menu.place(x=810, y=70, width=480, height=26)

button_mx5 = tk.Button(frame_menu, text="MX-5", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                       command=lambda: change_model(15))
button_mx5.place(x=0, y=0, height=25, width=75)

button_mx6 = tk.Button(frame_menu, text="MX-6", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                       command=lambda: change_model(23))
button_mx6.place(x=80, y=0, height=25, width=75)

button_mx9 = tk.Button(frame_menu, text="MX-9", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                       command=lambda: change_model(33))
button_mx9.place(x=160, y=0, height=25, width=75)

button_mx1226 = tk.Button(frame_menu, text="MX-12 2x6", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                          command=lambda: change_model(26))
button_mx1226.place(x=240, y=0, height=25, width=75)

button_mx1234 = tk.Button(frame_menu, text="MX-12 3x4", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                          command=lambda: change_model(34))
button_mx1234.place(x=320, y=0, height=25, width=75)

button_mx18 = tk.Button(frame_menu, text="MX-18", bg=kleur_btn_grijs, fg=kleur_btn_front, font=FONT_MODEL,
                        command=lambda: change_model(36))
button_mx18.place(x=400, y=0, height=25, width=75)


########################################################################
# Frame Controls
########################################################################
frame_controls = tk.Frame(root, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
if windows:
    frame_controls.place(x=10, y=608, width=1210, height=85)
else:
    frame_controls.place(x=16, y=635, width=1270, height=85)
image_logo = tk.PhotoImage(file=path_bin + 'logo.png')
button_logo = tk.Button(frame_controls, image=image_logo, bg=kleur_back, borderwidth=0, command=lambda: press_logo())
button_logo.place(x=1, y=2)

button_load_from_computer = tk.Button(frame_controls, text="load from\n computer", bg=kleur_back, relief=tk.RIDGE,
                                      highlightbackground=kleur_btn_back, activebackground=kleur_geel,
                                      fg=kleur_btn_front, font=FONT_KNOP_MENU, borderwidth=3,
                                      command=lambda: press_load_from_computer())
button_load_from_computer.place(x=170, y=15, height=50, width=110)

button_save_to_computer = tk.Button(frame_controls, text="save to\n computer", bg=kleur_back, relief=tk.RIDGE,
                                    highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                    font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_save_to_computer())
button_save_to_computer.place(x=300, y=15, height=50, width=110)

button_load_from_mx = tk.Button(frame_controls, text="load from\n MX", bg=kleur_back, relief=tk.RIDGE,
                                highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_load_from_mx())
button_load_from_mx.place(x=570, y=15, height=50, width=110)

button_save_to_mx = tk.Button(frame_controls, text="send to\n MX", bg=kleur_back, relief=tk.RIDGE,
                              highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                              font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_save_to_mx())
button_save_to_mx.place(x=700, y=15, height=50, width=110)

button_update_firmware = tk.Button(frame_controls, text="update\n firmware", bg=kleur_back, relief=tk.RIDGE,
                                   highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                   font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_update_firmware())

if windows:
    button_update_firmware.place(x=1050, y=15, height=50, width=110)
else:
    button_update_firmware.place(x=1130, y=15, height=50, width=110)


########################################################################
# Frame Info
########################################################################
def close_info():
    frame_info.place(x=-1250)


def youtube(url):
    webbrowser.open(url)


def test_connection():
    tell.app('Terminal', 'do script "' + cmdavr + '"')
    tell.app('Terminal', 'activate')

frame_info = tk.Frame(root, bg=kleur_grijs, borderwidth=2, relief=tk.RIDGE)
frame_info.place(x=-1250, y=220, width=400, height=280)

message = "Editor: " + VERSION + "\n(Build: " + BUILD + ")\n\nFirmware: " + FIRMWARE
message += "\n\nLatest software and firmware on"

label_firmware = tk.Label(frame_info, text=message, bg=kleur_grijs, fg=kleur_front, font=FONT)
label_firmware.place(x=0, y=10, width=395, height=120)

button_avrdude = tk.Button(frame_info, text="Close this window", bg=kleur_front, fg=kleur_back, font=FONT,
                           command=lambda: close_info())
button_avrdude.place(x=125, y=200, height=40, width=150)

button_voes = tk.Button(frame_info, text="www.voes.be", bg=kleur_front, fg=kleur_back,
                        command=lambda: youtube('https://voes.be/downloads'))
button_voes.place(x=155, y=130, height=30, width=90)

if not windows:
    button_test_connection = tk.Button(frame_info, text="Test Connection", bg=kleur_btn_grijs, fg=kleur_back, font=FONT,
                                       command=lambda: test_connection())
    button_test_connection.place(x=125, y=250, height=20, width=150)

# load default template 18360101
filename = path_templates + easysetup + "18360101.hex"
read_hex(filename)
loaddata()
check_latest_version()
root.mainloop()
