import binascii
import subprocess
import tkinter as tk
import os
import time
import webbrowser
import urllib.request
import ssl
from tkinter import ttk
from tkinter import messagebox
from tkinter import filedialog
from sys import platform
from pathlib import Path

########################################################################
# Variables
########################################################################
VERSION = "v 1.02"
BUILD = "240910"
FIRMWARE = "unknown"
titel = "Voes MX-6x6 " + VERSION + " - build " + BUILD

windows = True
keyctrl = 0x04
keyshift = 0x01
path_bin = 'bin/'
path_templates = 'templates/'
path_mx = '/'
if platform == "darwin":
    from applescript import tell
    windows = False
    keyshift = 0x03
    path_bin = os.path.dirname(os.path.realpath(__file__)) + '/bin/'
	
    path_templates = os.path.dirname(os.path.realpath(__file__)) + '/templates/'
    path_mx = os.path.expanduser("~/Documents/")
    path_avr = os.path.dirname(os.path.realpath(__file__)) + '/avr/bin/'
    cmdavr = path_avr + 'avrdude -C ' + path_avr + 'avrdude.conf -p m1284p -P usb -c usbasp -U '

# Global variables - if needed to change, use "global x" before changing x=?
MAX = 18
MAX2 = 36
MAX3 = 72
MAX4 = 40 # (6*6) + 4 sw2x
knop = 0
pijl_exp = False
blocksavecurrentsettings = False

if windows:
    kleur_front = "#EEEEEE"
    kleur_back = "#000000"
    kleur_grijs = "#333333"
    kleur_geel = "#FFCC00"
    kleur_btn_wit = "#DDDDDD"
    kleur_btn_front = "#EEEEEE"
    kleur_btn_back = "#25252d"
    kleur_btn_grijs = "#333333"
    kleur_btn_geel = "#FFCC00"
    kleur_lcd = "#3399FF"
    FONT = "Helvetica 10"
    FONT_BIG = "Helvetica 16 bold"
    FONT_MIDDLE = "Helvetica 14"
    FONT_TMPL = "Helvetica 12"
    FONT_TAB = "Helvetica 11 bold"
    FONT_KNOP = "Helvetica 16"
    FONT_KNOP_ITALIC = "Helvetica 10 italic"
    FONT_KNOP_MENU = "Helvetica 12"
    FONT_KNOP_NR = "Helvetica 9 bold"
    FONT_MODEL = "Helvetica 9"
    FONT_LCD = "Courier 20 bold"
    EASYPOSX = 0
else:
    kleur_front = "#EEEEEE"
    kleur_back = "#000000"
    kleur_grijs = "#333333"  # voorheen AAAAAA
    kleur_geel = "#FFCC00"
    kleur_btn_wit = "#FFFFFF"
    kleur_btn_front = "#000000"
    kleur_btn_back = "#FFFFFF"
    kleur_btn_grijs = "#333333"  # voorheen AAAAAA
    kleur_btn_geel = "#FFCC00"
    kleur_lcd = "#3399FF"
    FONT = "Helvetica 14"
    FONT_BIG = "Helvetica 22"
    FONT_MIDDLE = "Helvetica 16"
    FONT_TMPL = "Helvetica 16"
    FONT_TAB = "Helvetica 14 bold"
    FONT_KNOP = "Helvetica 18"
    FONT_KNOP_ITALIC = "Helvetica 12 italic"
    FONT_KNOP_MENU = "Helvetica 16"
    FONT_KNOP_NR = "Helvetica 13"
    FONT_MODEL = "Helvetica 13"
    FONT_LCD = "Courier 24 bold"
    EASYPOSX = 30

folder = ""
hexfile = "temp1284.hex"
newLines = []
easysetup = ''

kleuren = ['none', 'green', 'red', 'blue', 'purple', 'yellow', 'turquoise', 'white']
colors = ['#160900', '#2E8B57', '#CC0000', '#1E90FF', '#D200D2', '#FFCC00', "#40E0D0", kleur_btn_wit]

# Command Types
TYPE_NONE = 0
TYPE_PC = 1
TYPE_CCONOFF = 2
TYPE_CCOFFON = 3
TYPE_CCONONLY = 4
TYPE_CCOFFONLY = 5
TYPE_CCVALUE = 6
TYPE_EXPR1SWAP = 7
TYPE_AUTO1SWAP = 8
TYPE_IAONOFF = 11
TYPE_ALLLEDSOFF = 12
TYPE_ONCOLOR = 13
TYPE_OFFCOLOR = 45
TYPE_PRESETDOWN = 17
TYPE_PRESETUP = 18
TYPE_FAVORITEPRESET = 42
TYPE_SCENES = 14
TYPE_SCENEDOWN = 19
TYPE_SCENEUP = 20
TYPE_SCENE_AB = 63
TYPE_CCONONLYLED = 67
TYPE_PAGE_NUMBER = 71 # voor MX-6x6
TYPE_CC_PLUS = 72
TYPE_CC_MIN = 73
TYPE_MAX = 73
cmds1np = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("CC On/Off", TYPE_CCONOFF), ("CC Off/On", TYPE_CCOFFON),
           ("CC On Only", TYPE_CCONONLY), ("CC On Only LED", TYPE_CCONONLYLED), ("CC Off Only", TYPE_CCOFFONLY),
           ("CC Value", TYPE_CCVALUE), ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
           ("Exp CC Swap", TYPE_EXPR1SWAP), ("Auto On CC Swap", TYPE_AUTO1SWAP),
           ("IA On/Off", TYPE_IAONOFF), ("All Other LEDs Off", TYPE_ALLLEDSOFF), ("Preset Down", TYPE_PRESETDOWN),
           ("Preset Up", TYPE_PRESETUP), ("Favorite Preset", TYPE_FAVORITEPRESET), ("Scene/Snapshot", TYPE_SCENES),
           ("Scene/Snapshot Down", TYPE_SCENEDOWN), ("Scene/Snapshot Up", TYPE_SCENEUP),
           ("Scene/Snapshot A/B", TYPE_SCENE_AB), ("Page", TYPE_PAGE_NUMBER)]

cmds26 = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("CC On/Off", TYPE_CCONOFF), ("CC Off/On", TYPE_CCOFFON),
          ("CC On Only", TYPE_CCONONLY), ("CC Off Only", TYPE_CCOFFONLY), ("CC Value", TYPE_CCVALUE),
          ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
          ("Exp CC Swap", TYPE_EXPR1SWAP), ("Auto On CC Swap", TYPE_AUTO1SWAP), ("IA On/Off", TYPE_IAONOFF),
          ("All Other LEDs Off", TYPE_ALLLEDSOFF), ("Page", TYPE_PAGE_NUMBER)]

cmdssw2x = [("none", TYPE_NONE), ("Preset (PC)", TYPE_PC), ("CC On/Off", TYPE_CCONOFF), ("CC Off/On", TYPE_CCOFFON),
            ("CC On Only", TYPE_CCONONLY), ("CC Off Only", TYPE_CCOFFONLY), ("CC Value", TYPE_CCVALUE),
            ("CC Plus", TYPE_CC_PLUS), ("CC Min", TYPE_CC_MIN),
            ("Exp CC Swap", TYPE_EXPR1SWAP), ("Auto On CC Swap", TYPE_AUTO1SWAP), ("Preset Down", TYPE_PRESETDOWN),
            ("Preset Up", TYPE_PRESETUP), ("Favorite Preset", TYPE_FAVORITEPRESET), ("Scene/Snapshot", TYPE_SCENES),
            ("Scene/Snapshot Down", TYPE_SCENEDOWN), ("Scene/Snapshot Up", TYPE_SCENEUP),
            ("Scene/Snapshot A/B", TYPE_SCENE_AB), ("Page", TYPE_PAGE_NUMBER)]

# normal press
cmds_text = [cmds1np]
for i in range(5):
    cmds_text.append(cmds26)


########################################################################
# Classes
########################################################################
class Cmd:
    def __init__(self, type, cc, ch):
        self.type = type
        self.cc = cc
        self.ch = ch

    def prnt(self):
        print(self.type, self.cc, self.ch)


class IA:
    def __init__(self, name, cmd, steps, color, group):
        self.name = name
        self.cmd = cmd
        self.steps = steps
        self.color = color
        self.group = group

    def prnt(self):
        print(self.name, self.cmd.prnt(), self.steps, self.color, self.group)


class Pages:
    def __init__(self, name, color):
        self.name = name
        self.color = color

    def prnt(self):
        print(self.name, self.ison)


# create IA's & Pages
ias = []
for i in range(MAX4):  # MAX=18 MAX2=36 MAX3=nvt MAX4=40 (6*6)+ 4 sw2x PAGE=36
    cmds = []
    for j in range(6):
        cmd = Cmd(0, 1, 1)
        cmds.append(cmd)
    ia = IA('ia' + str(i + 1), cmds, False, 0, 0)
    ias.append(ia)

########################################################################
# Functions
########################################################################

def checkbutton_double_changed():
    for i in range (10, 20):
        if var_double.get() == 0:
            label_sysex[i].config(text = i+1)
        else:
            label_sysex[i].config(text = "+")


def is_hex(s):
    try:
        int(s, 16)
        return True
    except ValueError:
        return False


def enter_name_page(event, nr):
    t = entry_page_name[nr].get()
    t = t[0:12]
    entry_page_name[nr].delete(12, 'end')
    #frame_tab[nr].config(text = t)


def enter_name(event, issw2x, nr):
    if issw2x is True:
        t = entry_name_sw2x[nr].get()
        t = t[0:4]
        entry_name_sw2x[nr].delete(4, 'end')
        ias[MAX2+nr].name = t
    else:
        t = entry_name_np.get()
        t = t[0:4]
        entry_name_np.delete(4, 'end')
        label_knop_name[knop]['text'] = t
        label_lcd[knop]['text'] = t
        ias[knop].name = t


def on_drag_start(event):
    widget = event.widget
    widget.startX = event.x
    widget.startY = event.y


def on_drag_motion(event):
    widget = event.widget
    x = widget.winfo_x() - widget.startX + event.x
    y = widget.winfo_y() - widget.startY + event.y
    widget.place(x=x,y=y)


def on_drag_stop(event):
    global blocksavecurrentsettings
    widget = event.widget
    t = widget.index
    mod = int(t / 6) * 6
    rest = t % 6

    x1,y1,x2,y2=widget.winfo_x(),widget.winfo_y(),widget.winfo_x()+widget.winfo_width(),\
                widget.winfo_y()+widget.winfo_height()
    for i in range(mod, mod + 6):
        if button_knop[i] != widget:
            x3,y3,x4,y4=button_knop[i].winfo_x(),button_knop[i].winfo_y(),\
                        button_knop[i].winfo_x()+button_knop[i].winfo_width(),\
                        button_knop[i].winfo_y()+button_knop[i].winfo_height()
            if x1<x4 and x2>x3 and y1<y4 and y2>y3:
                global blocksavecurrentsettings
                blocksavecurrentsettings = True
                if (event.state & keyshift) != 0:  # SHIFT key is pressed, copy color only
                    ias[i].color = ias[t].color
                    label_knop_name[i].config(fg=colors[ias[i].color])
                elif (event.state & keyctrl) != 0:  # CTRl key is pressed, copy
                    ias[i].color = ias[t].color
                    ias[i].name = ias[t].name
                    for j in range(6):
                        tmpType = int(ias[t].cmd[j].type)
                        tmpCc = int(ias[t].cmd[j].cc)
                        tmpCh = int(ias[t].cmd[j].ch)
                        ias[i].cmd[j].type = tmpType
                        ias[i].cmd[j].cc = tmpCc
                        ias[i].cmd[j].ch= tmpCh

                    ias[i].group = ias[t].group
                    ias[i].steps = ias[t].steps
                    label_knop_name[i].config(fg=colors[ias[i].color])
                    label_knop_name[i].config(text=ias[i].name)
                    label_lcd[i].config(text=ias[i].name)
                    label_knop_name[i].config(fg=colors[ias[i].color])
                else:  # swap
                    temp = ias[t]
                    ias[t] = ias[i]
                    label_knop_name[t].config(text=ias[t].name)
                    label_lcd[t].config(text=ias[t].name)
                    label_knop_name[t].config(fg=colors[ias[t].color])

                    ias[i] = temp
                    label_knop_name[i].config(text=ias[i].name)
                    label_lcd[i].config(text=ias[i].name)
                    label_knop_name[i].config(fg=colors[ias[i].color])
 
                blocksavecurrentsettings = True
                press_button(i)
                blocksavecurrentsettings = False
    widget.place(x=button_position[rest][0],y=button_position[rest][1])


def kleur_changed(event, nr, ispage):
    caller = event.widget
    index = caller.current()
    if ispage is True:
        label_page_kleurkleur[nr].config(bg=colors[index])
    else:
        label_kleurkleur_np.config(bg=colors[index])
        ias[knop].color = index
        label_knop_name[knop].config(fg=colors[index])


def checkbutton_changed(type):
    if type == 1:
        ias[knop].glbl = var_np_glbl.get()
    elif type == 2:
        ias[knop].steps = var_np_steps.get()


def checkbutton_autoexp(nr):
    if var_exp1_auto_onoff.get() == 0:
        spinbox_auto1_cc.place(x=-1400)
        spinbox_auto1_ch.place(x=-2000)
        var_auto1_cc.set(0)
    else:
        spinbox_auto1_cc.place(x=140)
        spinbox_auto1_ch.place(x=200)


def group_changed(grp):
    ias[knop].group = var_np_group.get()


def adjust_layout_ccch(cmdNr, nr, issw2x):  # nr -> 0-5 Normal Press en 6-11 Long Press
    if issw2x is True:
        label_sw2x_cc[nr].config(text='cc')
        label_sw2x_ch[nr].config(text='ch')
        label_sw2x_cc[nr].place(x=190)
        label_sw2x_ch[nr].place(x=265)
        spinbox_sw2x_cc[nr].place(x=210)
        spinbox_sw2x_cc[nr].config(to=127)
        spinbox_sw2x_ch[nr].place(x=285)
        spinbox_sw2x_ch[nr].config(to=16)

        if cmdNr == TYPE_NONE or cmdNr == TYPE_ALLLEDSOFF or \
                cmdNr == TYPE_PRESETDOWN or cmdNr == TYPE_PRESETUP or cmdNr == TYPE_SCENEDOWN or \
                cmdNr == TYPE_SCENEUP:
            label_sw2x_cc[nr].config(text='')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].place(x=-200)
            spinbox_sw2x_ch[nr].place(x=-280)
        elif cmdNr == TYPE_PC or cmdNr == TYPE_FAVORITEPRESET:
            label_sw2x_cc[nr].config(text='pc')
        elif cmdNr == TYPE_CCVALUE:
            label_sw2x_cc[nr].config(text='cc')
            label_sw2x_ch[nr].config(text='#')
            spinbox_ch[nr].config(to=127)
        elif cmdNr == TYPE_IAONOFF:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=36)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENES:
            label_sw2x_cc[nr].config(text='#')
            label_sw2x_ch[nr].config(text='')
            spinbox_sw2x_cc[nr].config(to=8)
            spinbox_sw2x_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENE_AB:
            label_sw2x_cc[nr].config(text='A')
            label_sw2x_ch[nr].config(text='B')
            spinbox_sw2x_cc[nr].config(to=8)
            spinbox_sw2x_ch[nr].config(to=8)
    else:
        if nr < 6:
            plus = 0
            y = nr
        else:
            plus = MAX
            y = nr - 6

        label_cc[nr].config(text='cc')
        label_ch[nr].config(text='ch')
        label_cc[nr].place(x=190)
        label_ch[nr].place(x=265)
        spinbox_cc[nr].place(x=210)
        spinbox_cc[nr].config(to=127)
        spinbox_ch[nr].place(x=285)
        spinbox_ch[nr].config(to=16)
        combobox_special[nr].place(x=-500)

        if cmdNr == TYPE_NONE or cmdNr == TYPE_ALLLEDSOFF or \
                cmdNr == TYPE_PRESETDOWN or cmdNr == TYPE_PRESETUP or cmdNr == TYPE_SCENEDOWN or \
                cmdNr == TYPE_SCENEUP:
            label_cc[nr].config(text='')
            label_ch[nr].config(text='')
            spinbox_cc[nr].place(x=-200)
            spinbox_ch[nr].place(x=-280)
        elif cmdNr == TYPE_PC or cmdNr == TYPE_FAVORITEPRESET:
            label_cc[nr].config(text='pc')
        elif cmdNr == TYPE_CCVALUE:
            label_cc[nr].config(text='cc')
            label_ch[nr].config(text='#')
            spinbox_ch[nr].config(to=127)
        elif cmdNr == TYPE_PAGE_NUMBER:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=6)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENES:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=8)
            spinbox_ch[nr].place(x=-285)
        elif cmdNr == TYPE_SCENE_AB:
            label_cc[nr].config(text='A')
            label_ch[nr].config(text='B')
            spinbox_cc[nr].config(to=8)
            spinbox_ch[nr].config(to=8)
        elif cmdNr == TYPE_ONCOLOR or cmdNr == TYPE_OFFCOLOR:
            label_cc[nr].place(x=-285)
            label_ch[nr].place(x=-265)
            spinbox_cc[nr].place(x=-210)
            spinbox_ch[nr].place(x=-285)
            combobox_special[nr].place(x=210)
            combobox_special[nr]['values'] = kleuren
            combobox_special[nr].current(ias[knop].cmd[nr].cc)
        elif cmdNr == TYPE_IAONOFF:
            label_cc[nr].config(text='#')
            label_ch[nr].config(text='')
            spinbox_cc[nr].config(to=36)
            spinbox_ch[nr].place(x=-285)


def cmd_changed(event, nr, issw2x):
    caller = event.widget
    tekst = caller.get()
    if issw2x is True:
        cmdNr = getNumber(cmds1np, tekst)
        ias[MAX2 + nr].cmd[0].type = cmdNr
        adjust_layout_ccch(cmdNr, nr, True)
    else:
        if nr == 0:
            cmdNr = getNumber(cmds1np, tekst)
        else:
            cmdNr = getNumber(cmds26, tekst)

        ias[knop].cmd[nr].type = cmdNr
        adjust_layout_ccch(cmdNr, nr, False)


def cch_changed(is_cc, nr, issw2x):
    if issw2x is True:
        if is_cc is True:
            ias[MAX2 + nr].cmd[0].cc = int(spinbox_sw2x_cc[nr].get())
        else:
            ias[MAX2 + nr].cmd[0].ch = int(spinbox_sw2x_ch[nr].get())
    else:
        if is_cc is True:
            ias[knop].cmd[nr].cc = int(spinbox_cc[nr].get())
        else:
            ias[knop].cmd[nr].ch = int(spinbox_ch[nr].get())


def special_changed(event, nr, issw2x):
    caller = event.widget
    tekst = caller.get()
    if issw2x is True:
        cmd = ias[MAX2 + nr].cmd[0].type
    else:
        cmd = ias[knop].cmd[nr].type
    if cmd == TYPE_ONCOLOR or cmd == TYPE_OFFCOLOR:
        ias[knop].cmd[nr].cc = kleuren.index(tekst)

    if windows:
        kleur_btn_act_back = kleur_btn_geel
        kleur_btn_act_front = kleur_btn_back
    else:
        kleur_btn_act_back = kleur_btn_geel
        kleur_btn_act_front = kleur_btn_front

    for i in range(6):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
        # frame_knop[i].place(x=button_position[i][0], y=button_position[i][1], height=95, width=75)
        # frame_knop[i+36].place(x=button_position[i][0], y=button_position[i][1], height=95, width=75)
        xt=100


def loaddata():
    # Checksum check
    t = get_translation_hex(53, 53, 55)
    if int(t) != 11:   # 11=MX  12=6x6
        if int(t) == 12:
            messagebox.showinfo(titel, "This is a MX file. Can't load data!")
        else:
            messagebox.showinfo(titel, "Checksum is " + t + ". Should be 11!")

    # Buttons
    #############
    t = ""
    for i in range(MAX2):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
        t = get_translation_ascii(i, 57, 73)
        t = t + '        '
        t = t[0:4]
        t = t.strip()
        ias[i].name = t

        for j in range(6):
            k = 9 + (6 * j)
            temptype = get_translation_int(i, k, k + 2)
            tempcc = get_translation_int(i, k + 2, k + 4)
            tempch = get_translation_int(i, k + 4, k + 6)
            tempcmd = Cmd(temptype, tempcc, tempch)
            ias[i].cmd[j] = tempcmd

        # steps, group, color
        getal = get_translation_int(i, 45, 47)
        k = int(0)
        d = int(0)
        bingetal = [0, 0, 0, 0, 0, 0, 0, 0]

        while getal != 0:
            d = int(getal % 2)
            bingetal[k] = int(d)
            k = k + 1
            getal = int(getal / 2)

        ias[i].steps = False
        ias[i].group = 0
        ias[i].color = 0
        if bingetal[1] == 1:
            ias[i].steps = True
        if bingetal[2] == 0 and bingetal[3] == 0 and bingetal[4] == 1:
            ias[i].group = 1
        if bingetal[2] == 0 and bingetal[3] == 1 and bingetal[4] == 0:
            ias[i].group = 2
        if bingetal[2] == 0 and bingetal[3] == 1 and bingetal[4] == 1:
            ias[i].group = 3
        if bingetal[2] == 1 and bingetal[3] == 0 and bingetal[4] == 0:
            ias[i].group = 4
        if bingetal[5] == 0 and bingetal[6] == 0 and bingetal[7] == 1:
            ias[i].color = 1
        if bingetal[5] == 0 and bingetal[6] == 1 and bingetal[7] == 0:
            ias[i].color = 2
        if bingetal[5] == 0 and bingetal[6] == 1 and bingetal[7] == 1:
            ias[i].color = 3
        if bingetal[5] == 1 and bingetal[6] == 0 and bingetal[7] == 0:
            ias[i].color = 4
        if bingetal[5] == 1 and bingetal[6] == 0 and bingetal[7] == 1:
            ias[i].color = 5
        if bingetal[5] == 1 and bingetal[6] == 1 and bingetal[7] == 0:
            ias[i].color = 6
        if bingetal[5] == 1 and bingetal[6] == 1 and bingetal[7] == 1:
            ias[i].color = 7

        label_knop_name[i].config(text=str(t))
        label_lcd[i].config(text=str(t))
        label_knop_name[i].config(fg=colors[ias[i].color])

        # Pages
        #######
        t = ""
        for i in range(6):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
            t = get_translation_ascii(78 + i, 9, 33)
            t = t + '           '
            t = t[0:12]
            t = t.strip()
            entry_page_name[i].delete(0, 'end')
            entry_page_name[i].insert(0, t)

            kl = get_translation_int(78 + i, 33, 35)
            if kl > 7:
                kl = 0
            combobox_page_kleur[i].current(kl)
            label_page_kleurkleur[i].config(bg=colors[kl])


    # sw2x
    for i in range(4):
        t = get_translation_ascii(77, 9 + (i * 16), 25 + (i*16))
        t = t.strip()
        ias[MAX2+i].name = t
        entry_name_sw2x[i].delete(0, 'end')
        entry_name_sw2x[i].insert(0, t)

        temptype = get_translation_int(27 + (i * 3), 53, 55)
        if temptype > TYPE_MAX:
            temptype = TYPE_NONE

        tempcc = get_translation_int(28 + (i * 3), 53, 55)
        tempch = get_translation_int(29 + (i * 3), 53, 55)
        tempcmd = Cmd(temptype, tempcc, tempch)
        ias[MAX2+i].cmd[0] = tempcmd
        t = ias[MAX2+i].cmd[0].type
        combobox_sw2x_cmd[i].current(getIndex(cmdssw2x, t))
        var_sw2x_cc[i].set(ias[MAX2+i].cmd[0].cc)
        spinbox_sw2x_cc[i].config(textvariable=var_sw2x_cc[i])
        var_sw2x_ch[i].set(ias[MAX2+i].cmd[0].ch)
        spinbox_sw2x_ch[i].config(textvariable=var_sw2x_ch[i])
        adjust_layout_ccch(t, i, True)

    global blocksavecurrentsettings
    blocksavecurrentsettings = True
    press_button(0)
    blocksavecurrentsettings = False

    # Exp. Input
    #############
    var_exp1_cc.set(get_translation_int(0, 53, 55))
    spinbox_exp1_cc.config(textvariable=var_exp1_cc)
    var_exp1_ch.set(get_translation_int(1, 53, 55))
    spinbox_exp1_ch.config(textvariable=var_exp1_ch)
    auto = get_translation_int(2, 53, 55)
    var_auto1_cc.set(auto)
    if auto == 0:
        var_exp1_auto_onoff.set(0)
        spinbox_auto1_cc.place(x=-1400)
        spinbox_auto1_ch.place(x=-2000)
    else:
        var_exp1_auto_onoff.set(1)
        spinbox_auto1_cc.place(x=140)
        spinbox_auto1_ch.place(x=200)
    spinbox_auto1_cc.config(textvariable=var_auto1_cc)
    var_auto1_ch.set(get_translation_int(3, 53, 55))
    spinbox_auto1_ch.config(textvariable=var_auto1_ch)
    var_exp1_resend.set(get_translation_int(17, 55, 57))

    temp = get_translation_int(39, 53, 55)
    if temp > 127:
        temp = 0
    var_exp1_min_cc.set(temp)
    spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
    temp = get_translation_int(40, 53, 55)
    if temp > 127 or temp == 0:
        temp = 127
    if temp < var_exp1_min_cc.get():
        temp = 127
        var_exp1_min_cc.set(0)
        spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
    var_exp1_max_cc.set(temp)
    spinbox_exp1_max_cc.config(textvariable=var_exp1_max_cc)

    for nr in range(3):
        device = get_translation_int(10 + nr, 53, 55)
        # index = getIndex(cmdsexp, device)
     #     if index == 0:
    #         frame_act_as_exp[nr].place(x=10)
    #         frame_act_as_btn[nr].place(x=-1000)
    #         pijl_exp[nr] = True
    #     else:
    #         frame_act_as_sw2x_inner.place(x=-1000)
    #         frame_act_as_exp[nr].place(x=-1000)
    #         frame_act_as_btn[nr].place(x=10)
    #         pijl_exp[nr] = False
    if ias[MAX2].cmd[0].type == 0:  # check if SW2x Left Button NP is > 0
        frame_act_as_sw2x_inner.place(x=-1000)
        frame_act_as_exp.place(x=10)
    else:
        frame_act_as_sw2x_inner.place(x=10)
        frame_act_as_exp.place(x=-1000)

    # Global
    #############
    # Misc
    var_global_preset_offset.set(get_translation_int(1, 55, 57))
     # var_global_bank_only.set(get_translation_int(3, 55, 57))
    # var_global_ignore_pc.set(get_translation_int(16, 55, 57))
    var_global_reset_steps.set(get_translation_int(2, 55, 57))
    var_global_midi_merge.set(get_translation_int(0, 55, 57))
    var_global_cc_start_value.set(get_translation_int(42, 53, 55))
    var_global_long_press.set((get_translation_int(4, 55, 57)))
    var_global_reset_lcd.set(get_translation_int(9, 55, 57))
    spinbox_global_reset_lcd.config(textvariable=var_global_reset_lcd)
    var_global_start_page.set(get_translation_int(11, 55, 57))
    spinbox_global_start_page.config(textvariable=var_global_start_page)
    var_global_looper_page.set(get_translation_int(8, 55, 57))
    spinbox_global_looper_page.config(textvariable=var_global_looper_page)

    # External Device
    var_global_midi_channel.set(get_translation_int(6, 55, 57))
    spinbox_global_midi_channel.config(textvariable=var_global_midi_channel)
    var_global_start_preset.set(get_translation_int(14, 55, 57))
    # !!!!!!!!!! hier moet nog start_bank komen !!!!!!!!!!
    spinbox_global_start_preset.config(textvariable=var_global_start_preset)
    var_global_scenes_cc.set(get_translation_int(7, 55, 57))
    spinbox_global_scenes_cc.config(textvariable=var_global_scenes_cc)

    # Expr. Calibration
    var_global_exp1_min.set(get_translation_int(13, 53, 55))
    spinbox_global_exp1_min.config(textvariable=var_global_exp1_min)
    var_global_exp1_max.set(get_translation_int(14, 53, 55))
    spinbox_global_exp1_max.config(textvariable=var_global_exp1_max)


def updatedata():
    # Checksum
    change_value_to_int(53, 53, 55, '11')  # 11=MX  12=6x6

    # Buttons
    #############
    for i in range(MAX2):  # MAX=18 MAX2=36 MAX3=72 MAX4=76
        # name
        txt = ias[i].name
        txt = txt + '        '
        txt = txt[0:4]
        change_value(i, 57, 65, txt)

        # type, cc, ch
        for j in range(6):
            k = 9 + (6 * j)
            change_value_to_hex(i, k, k + 2, ias[i].cmd[j].type)
            change_value_to_hex(i, k + 2, k + 4, ias[i].cmd[j].cc)
            change_value_to_hex(i, k + 4, k + 6, ias[i].cmd[j].ch)

        # steps, group, color
        int7 = int6 = int5 = int4 = int3 = int2 = int1 = int0 = 0

        if ias[i].steps:
            int1 = 1
        if ias[i].group == 1:
            int2 = 0
            int3 = 0
            int4 = 1
        if ias[i].group == 2:
            int2 = 0
            int3 = 1
            int4 = 0
        if ias[i].group == 3:
            int2 = 0
            int3 = 1
            int4 = 1
        if ias[i].group == 4:
            int2 = 1
            int3 = 0
            int4 = 0
        if ias[i].color == 0:
            int5 = 0
            int6 = 0
            int7 = 0
        if ias[i].color == 1:
            int5 = 0
            int6 = 0
            int7 = 1
        if ias[i].color == 2:
            int5 = 0
            int6 = 1
            int7 = 0
        if ias[i].color == 3:
            int5 = 0
            int6 = 1
            int7 = 1
        if ias[i].color == 4:
            int5 = 1
            int6 = 0
            int7 = 0
        if ias[i].color == 5:
            int5 = 1
            int6 = 0
            int7 = 1
        if ias[i].color == 6:
            int5 = 1
            int6 = 1
            int7 = 0
        if ias[i].color == 7:
            int5 = 1
            int6 = 1
            int7 = 1

        getal = int0 + (int1 * 2) + (int2 * 4) + (int3 * 8) + (int4 * 16) + (int5 * 32) + (int6 * 64) + (int7 * 128)
        change_value_to_hex(i, 45, 47, getal)

    # Pages
    #######
    for i in range(6):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
        txt = entry_page_name[i].get()
        txt = txt + '              '
        txt = txt[0:12]
        change_value(78 + i, 9, 33, txt)
        change_value_to_hex(78 + i, 33, 35, combobox_page_kleur[i].current())

    # sw2x
    for i in range(4):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
         # name
        txt = ias[MAX2+i].name
        txt = txt + '        '
        txt = txt[0:8]
        change_value(77, 9 + (i * 16), 25 + (i*16), txt)

        #type, cc, ch
        change_value_to_hex(27 + (i * 3), 53, 55, ias[MAX2+i].cmd[0].type)
        change_value_to_hex(28 + (i * 3), 53, 55, ias[MAX2+i].cmd[0].cc)
        change_value_to_hex(29 + (i * 3), 53, 55, ias[MAX2+i].cmd[0].ch)


    # Exp. Input
    #############
    change_value_to_hex(0, 53, 55, var_exp1_cc.get())
    change_value_to_hex(1, 53, 55, var_exp1_ch.get())
    change_value_to_hex(2, 53, 55, var_auto1_cc.get())
    change_value_to_hex(3, 53, 55, var_auto1_ch.get())
    change_value_to_hex(17, 55, 57, var_exp1_resend.get())
    change_value_to_hex(39, 53, 55, var_exp1_min_cc.get())
    change_value_to_hex(40, 53, 55, var_exp1_max_cc.get())


    # Global
    #############
    # Misc
    change_value_to_hex(1, 55, 57, var_global_preset_offset.get())
    # change_value_to_hex(3, 55, 57, var_global_bank_only.get())
    # change_value_to_hex(16, 55, 57, var_global_ignore_pc.get())
    change_value_to_hex(2, 55, 57, var_global_reset_steps.get())
    change_value_to_hex(0, 55, 57, var_global_midi_merge.get())
    change_value_to_hex(42, 53, 55, var_global_cc_start_value.get())
    change_value_to_hex(4, 55, 57, var_global_long_press.get())
    change_value_to_hex(8, 55, 57, var_global_looper_page.get())
    change_value_to_hex(9, 55, 57, var_global_reset_lcd.get())
    change_value_to_hex(11, 55, 57, var_global_start_page.get())

    # External Device
    change_value_to_hex(6, 55, 57, var_global_midi_channel.get())
    change_value_to_hex(14, 55, 57, var_global_start_preset.get())
    change_value_to_hex(7, 55, 57, var_global_scenes_cc.get())

    # Expr. Calibration
    change_value_to_hex(13, 53, 55, var_global_exp1_min.get())
    change_value_to_hex(14, 53, 55, var_global_exp1_max.get())


# get the Hex version from the bytes on line 'line
def get_translation_hex(lineNr, yOffsetStart, yOffsetEnd):
    out = 0
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = line
    return out


# get the Int version from the bytes on line 'line
def get_translation_int(lineNr, yOffsetStart, yOffsetEnd):
    out = 0
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = int(line, 16)
    return out


# get the Ascii version from the bytes on line 'line
def get_translation_ascii(lineNr, yOffsetStart, yOffsetEnd):
    out = ""
    line = newLines[lineNr]
    line = line[yOffsetStart: yOffsetEnd]
    out = binascii.unhexlify(line)
    out = str(out, 'ascii')
    return out


def get_checksum(line):
    oldChecksum = line[-2:]
    line = line[:len(line) - 1]
    o = 0
    i = line
    # calculate the sum
    while not len(i) < 2:
        o += int((i[:2]), 16)
        i = i[2:]

    # calculate the complement and add 1 (two's complement)
    checksum = format((o ^ 0xffff) + 1, '#016b')
    checksum = int(checksum[-8:], 2)
    checksum = "{0:#0{1}x}".format(checksum, 4)
    checksum = checksum[-2:]
    # return the last two symbols
    return checksum


# change a value on lineNr from (y_offsetStart, y_offsetEnd) to value
def change_value(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    # add spaces
    value = value.ljust(size, ' ')
    out = binascii.b2a_hex(value.encode())
    hex_value = str(out, 'ascii').upper()
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_int(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    # add spaces
    # value = value.ljust(size, ' ')
    # out = binascii.b2a_hex(value.encode())
    # hex_value = str(out, 'ascii').upper()

    hex_value = str(value)
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_hex(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    hex_value = str(hex(value))
    lengte = len(hex_value)
    if lengte > 3:
        hex_value = hex_value[2:4].upper()
    else:
        hex_value = "0" + hex_value[2:3].upper()
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def change_value_to_realhex(lineNr, y_offsetStart, y_offsetEnd, value):
    size = y_offsetEnd - y_offsetStart
    hex_value = value.upper()
    lengte = len(hex_value)
    if lengte < 2:
         hex_value = "0" + hex_value
    hex_value = hex_value[0:2]
    # print(hex_value)
    line = newLines[lineNr]
    line = line[:y_offsetStart] + hex_value[:size] + line[y_offsetEnd:]
    newLines[lineNr] = line


def read_hex(filepath):
    my_file = Path(filepath)
    if my_file.is_file():
        newLines.clear()
        with open(filepath) as f:
            lines = f.readlines()
        f.close()
        for line in lines:
            newLines.append(line)
    else:
        messagebox.showinfo(titel, "File does not exist!")


def read_txt(filepath):
    my_file = Path(filepath)
    if my_file.is_file():
        if windows:
            os.startfile(my_file)
        else:
            subprocess.call(['open', '-a', 'Textedit', my_file])
            

def write_hex(filepath):
    #if windows:
    #    file = open(filepath, "w")
    #else:
    #    file = open('./' + filepath, "w")
    file = open(filepath, "w")
    for line in newLines:
        file.write(line)
    file.close()


def press_load_from_computer():
    root.filename = filedialog.askopenfilename(title="Select file",
                                               filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return
    read_hex(root.filename)
    loaddata()


def press_save_to_computer():
    updatedata()
    root.filename = filedialog.asksaveasfilename(title="Select file",
                                                 filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return
    root.filename = root.filename
    if root.filename[-4:] != '.hex':
        root.filename = root.filename + '.hex'
    write_hex(root.filename)
    file = open(root.filename, "w")
    # delete the : and newlines
    n = 9
    for line in newLines:
        line = line.strip()
        line = line.strip()
        line = line[1:]
        checksum = get_checksum(line)
        line = ":" + line[:len(line) - 2] + checksum.upper() + "\n"
        file.write(line)
    file.close()
    # write to chip
    # self.run_bash(savef)
    messagebox.showinfo(titel, "Saved to computer")


def press_load_from_mx():
    if windows:
        os.system('start cmd /k "bin\\read_settings.bat"')
        time.sleep(4)
        read_hex("./temp.hex")
    else:
        cmd = cmdavr + 'eeprom:r:' + path_mx + 'temp.hex:i'
        tell.app('Terminal', 'do script "' + cmd + '"')
        tell.app('Terminal', 'activate')
        tell.app('System Events', 'delay 4')
        tell.app('System Events', 'tell process "Terminal" to keystroke "w" using command down')
        read_hex(path_mx + "temp.hex")        
    loaddata()
    # Firmware
    global FIRMWARE
    major = str(get_translation_hex(51, 53, 55))
    if major[0:1] == "0":
        major = major[1:]
    minor = str(get_translation_hex(52, 53, 55))
    FIRMWARE = "v " + major + "." + minor
    message = "Editor: " + VERSION + "\n(Build: " + BUILD + ")\n\nFirmware: " + FIRMWARE
    message += "\n\nLatest software and firmware on"
    label_firmware.config(text=message)
    if VERSION != FIRMWARE:
        messagebox.showinfo(titel, "Editor (" + VERSION + ") and Firmware (" + FIRMWARE +
                            ") versions are not identical.\n\nPlease update!")
    

def press_save_to_mx():
    updatedata()    
    if windows:
        write_hex('temp.hex')
        file = open('temp.hex', "w")
    else:
        write_hex(path_mx + 'temp.hex')
        file = open(path_mx + 'temp.hex', "w")
    # delete the : and newlines
    n = 9
    for line in newLines:
        line = line.strip()
        line = line.strip()
        line = line[1:]
        checksum = get_checksum(line)
        line = ":" + line[:len(line) - 2] + checksum.upper() + "\n"
        file.write(line)
    file.close()

    if windows:
         os.system('start cmd /k "bin\\write_settings.bat"')
    else:
        cmd = cmdavr + 'eeprom:w:' + path_mx + 'temp.hex:i'
        tell.app('Terminal', 'do script "' + cmd + '"')
        tell.app('Terminal', 'activate')
        tell.app('System Events', 'delay 52')
        tell.app('System Events', 'tell process "Terminal" to keystroke "w" using command down')


def press_update_firmware():
    root.filename = filedialog.askopenfilename(title="Select file",
                                               filetypes=(("hex files", "*.hex"), ("all files", "*.*")))
    if not root.filename: return

    if windows:
        cmd = 'start cmd /k "bin\\update_firmware.bat" ' + Path(root.filename).stem
        os.system(cmd)
    else:
        cmd = cmdavr + 'flash:w:' + root.filename
        tell.app('Terminal', 'do script "' + cmd + '"')
        tell.app('Terminal', 'activate')


# Apple, niet gebruikt??
def run_bash(filepath):
    # start a new subprocess to run the script:
    # data_folder = Path("/bin/")
    # file_to_open = data_folder / filePath
    file_to_open = filepath
    # os.chmod(file_to_open, 0o755)
    p = subprocess.Popen(file_to_open, shell=True, stdout=subprocess.PIPE)
    stdout, stderr = p.communicate()
    p.kill()
    is_process_alive(p)
    return p.returncode


def check_internet_connection(url='https://voes.be'):
    context = ssl._create_unverified_context()
    try:
        urllib.request.urlopen(url, context=context, timeout=5)
        return True
    except:
        return False


def check_latest_version():
    if check_internet_connection():
        url = 'https://voes.be/downloads/latest_firmware.txt'
        context = ssl._create_unverified_context()
        response = urllib.request.urlopen(url, context=context)
        data = response.read().decode('utf-8')

        # Controleer of "MX-6x6 =" in de data staat en haal de waarde op
        latest_version = None
        for line in data.splitlines():
            if "MX-6x6 =" in line:
                latest_version = line.split('=')[1].strip()
                break

        if latest_version:
            if VERSION < latest_version:
                response = messagebox.askquestion(titel, "New editor and firmware " + latest_version +
                                                  " available\n\nDownload?")
                if response == 'yes':
                    webbrowser.open("https://voes.be/downloads.html")
                    root.destroy()


def is_process_alive(p): # check if a process is still running
    check = p.poll()
    if check is None:
        print("still running")
        return True
    print("process terminated")
    return False


def cch_check(value, max):
    if value > max:
        value = max
    return value
    

def press_button(x):
    global knop
    
    # save current settings before changing to new knop
    if blocksavecurrentsettings is False:
        # name
        t = entry_name_np.get()
        t = t[0:4]
        ias[knop].name = t
        label_knop_name[knop].config(text=str(t))
        # color
        label_knop_name[knop].config(fg=colors[ias[knop].color])
        # command 1-6
        for i in range(6):
            cmdNr = ias[knop].cmd[i].type
            if cmdNr != TYPE_ONCOLOR and cmdNr != TYPE_OFFCOLOR:
                cctemp = int(spinbox_cc[i].get())
                chtemp = int(spinbox_ch[i].get())
                if cmdNr == TYPE_SCENES or cmdNr == TYPE_SCENE_AB:
                    cctemp = cch_check(cctemp, 8)
                    chtemp = cch_check(chtemp, 8)
                elif cmdNr == TYPE_PC or cmdNr == TYPE_CCONOFF or cmdNr == TYPE_CCOFFON or cmdNr == TYPE_CCONONLY or \
                    cmdNr == TYPE_CCONONLYLED or cmdNr == TYPE_CCOFFONLY or cmdNr == TYPE_EXPR1SWAP or \
                    cmdNr == TYPE_AUTO1SWAP or cmdNr == TYPE_FAVORITEPRESET:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 16)
                elif cmdNr == TYPE_CCVALUE or cmdNr == TYPE_CC_MIN or cmdNr == TYPE_CC_PLUS:
                    cctemp = cch_check(cctemp, 127)
                    chtemp = cch_check(chtemp, 127)
                elif cmdNr == TYPE_PAGE_NUMBER:
                    cctemp = cch_check(cctemp, 8)
                elif cmdNr == TYPE_IAONOFF:
                    cctemp = cch_check(cctemp, 36)
                ias[knop].cmd[i].cc = cctemp
                ias[knop].cmd[i].ch = chtemp
    # end save current settings
    
    knop = x
    entry_name_np.delete(0, 'end')
    # entry_name_np.insert(0, label_knop_name[knop].cget("text"))
    entry_name_np.insert(0, ias[x].name)
    label_ia_np['text'] = "IA " + str(knop + 1)
    kleur = int(ias[x].color)
    label_kleurkleur_np.config(bg=colors[kleur])
    combobox_kleur_np.current(kleur)
    var_np_steps.set(ias[x].steps)
    var_np_group.set(ias[x].group)

    for i in range(6):
        t = ias[x].cmd[i].type
        if i == 0:
            combobox_cmd[i].current(getIndex(cmds1np, t))
        else:
            combobox_cmd[i].current(getIndex(cmds26, t))
        var_cc[i].set(ias[x].cmd[i].cc)
        spinbox_cc[i].config(textvariable=var_cc[i])
        var_ch[i].set(ias[x].cmd[i].ch)
        spinbox_ch[i].config(textvariable=var_ch[i])
        adjust_layout_ccch(t, i, False)


def press_logo():
    frame_info.place(x=250)


def press_exppijl():
    global pijl_exp
    if pijl_exp is True:
        frame_act_as_exp.place(x=-1000)
        pijl_exp = False
        frame_act_as_sw2x_inner.place(x=10)
        combobox_sw2x_cmd[0].current(0)
    else:
        frame_act_as_exp.place(x=10)
        pijl_exp = True
        frame_act_as_sw2x_inner.place(x=-1000)
        combobox_sw2x_cmd[0].current(0)


def getNumber(lijst, selectNaam):
    if selectNaam in [y[0] for y in lijst]:
        idx = [y[0] for y in lijst].index(selectNaam)
        return lijst[idx][1]
    else:
        return ""


def getName(lijst, selectNr):
    if selectNr in [y[1] for y in lijst]:
        idx = [y[1] for y in lijst].index(selectNr)
        return lijst[idx][0]
    else:
        return 0


def getIndex(lijst, selectNr):
    if selectNr in [y[1] for y in lijst]:
        idx = [y[1] for y in lijst].index(selectNr)
        return idx
    else:
        return 0


def test(testinput):
    label_test['text'] = str(testinput)


def copypasteclear_button(type, isNormalPress):
    global knop, knopcopypaste, blocksavecurrentsettings
    knptemp = knop

    if type == 1: # copy
        blocksavecurrentsettings = True
        if isNormalPress:
            knopcopypaste = knop

    elif type == 2: # paste
        blocksavecurrentsettings = True
        if isNormalPress:
            knptemp = knop
            ias[knptemp].name = ias[knopcopypaste].name
            entry_name_np.delete(0, 'end')
            entry_name_np.insert(0, ias[knptemp].name)

            # label on the MX-6 Display
            # label_knop_name[knop].config(text=ias[knptemp].name)
            # # color
            # label_knop_name[knop].config(fg=colors[ias[knptemp].color])

        ias[knptemp].color = ias[knopcopypaste].color
        for j in range(6):
            tmpType = int(ias[knopcopypaste].cmd[j].type)
            tmpCc = int(ias[knopcopypaste].cmd[j].cc)
            tmpCh = int(ias[knopcopypaste].cmd[j].ch)
            ias[knptemp].cmd[j].type = tmpType
            ias[knptemp].cmd[j].cc = tmpCc
            ias[knptemp].cmd[j].ch = tmpCh

        ias[knptemp].steps = ias[knopcopypaste].steps
        ias[knptemp].group = ias[knopcopypaste].group
        label_knop_name[knptemp].config(text=ias[knopcopypaste].name)
        label_knop_name[knptemp].config(fg=colors[ias[knopcopypaste].color])

        blocksavecurrentsettings = True
        if isNormalPress:
            press_button(knptemp)
        blocksavecurrentsettings = False

    else: # clear
        knopcopypaste = 0
        if isNormalPress:
            entry_name_np.delete(0, 'end')

        ias[knptemp].color = 0
        for j in range(6):
            ias[knptemp].cmd[j].type = 0
            ias[knptemp].cmd[j].cc = 0
            ias[knptemp].cmd[j].ch = 0

        ias[knptemp].steps = 0
        ias[knptemp].group = 0
        label_knop_name[knptemp].config(text="")
        label_knop_name[knptemp].config(fg=colors[0])

        if isNormalPress:
            press_button(knptemp)


########################################################################
########################################################################
# GUI
########################################################################
########################################################################

if windows:
    app_height = 670
    app_width = 880
else:
    app_height = 700
    app_width = 940

root = tk.Tk()
root.title(titel)

try:
    if windows:
        root.iconbitmap(path_bin + 'logo.ico')
    else:
        img = tk.Image("photo", file=path_bin + 'logo.gif')
        root.tk.call('wm', 'iconphoto', root._w, img)
except Exception as err:
    messagebox.showerror(titel, "GUI\n\n" + str(err))

root.resizable(False, False)
screen_width = root.winfo_screenwidth()
screen_height = root.winfo_screenheight() - 80
xx = (screen_width / 2) - (app_width / 2)
yy = (screen_height / 2) - (app_height / 2)
root.geometry(f'{app_width}x{app_height}+{int(xx)}+{int(yy)}')

canvas = tk.Canvas(root, height=app_height, width=app_width, bg=kleur_back)
canvas.pack()

image_title = tk.PhotoImage(file=path_bin + 'titel.png')
label_title = tk.Label(root, bg=kleur_back, image=image_title)
label_title.place(x=(app_width - 501) / 2, y=3, width=501, height=55)

label_test = tk.Label(root, bg=kleur_back, fg=kleur_front, anchor='w')
label_test.place(x=5, y=5, width=180, height=20)

image_midicc = tk.PhotoImage(file=path_bin + 'midi-cc.png')
button_midicc = tk.Button(root, image=image_midicc, bg=kleur_back, borderwidth=0,
                          command=lambda: youtube('https://voes.be/midi-cc'))
if windows:
    button_midicc.place(x=825, y=10)
else:
    button_midicc.place(x=880, y=15)

########################################################################
# Frame TABs
########################################################################
style = ttk.Style()
style.configure('TNotebook.Tab', font=FONT_TAB)
style.configure('TNotebook', background=kleur_back, highlightbackground=kleur_back, padding=0)
notebook_tabs = ttk.Notebook(root)
if windows:
    notebook_tabs.place(x=10, y=60, width=860, height=510)
else:
    notebook_tabs.place(x=15, y=77, width=910, height=520)

frame_tab_buttons = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_expinput = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)
frame_tab_global = tk.Frame(notebook_tabs, width=500, height=500, bg=kleur_back)

frame_tab_buttons.pack(fill="both", expand=1)
frame_tab_expinput.pack(fill="both", expand=1)
frame_tab_global.pack(fill="both", expand=1)

notebook_tabs.add(frame_tab_buttons, text="Buttons")
notebook_tabs.add(frame_tab_expinput, text="Exp. Input")
notebook_tabs.add(frame_tab_global, text="Global")

########################################################################
# TAB Buttons - Frame Buttons
########################################################################
btn_image = tk.PhotoImage(file=path_bin + 'button.png')
mx6_image = tk.PhotoImage(file=path_bin + 'mx6.png')
button_knop = list()
label_knop_name = list()
label_lcd = list()

label_page_name = list()
label_page_kleur = list()
label_page_kleurkleur = list()
entry_page_name = list()
combobox_page_kleur = list()
label_mx6 = list()

# button positions
if windows:
    x = -5
    y = 0
else:
    x = -5
    y = 0

button_position = [[50 + x, 310 + y], [225 + x, 310 + y], [390 + x, 310 + y],
                   [50 + x, 125 + y], [220 + x, 125 + y], [390 + x, 125 + y]]

lcd_position = [[115 + x, 220 + y], [205 + x, 220 + y], [295 + x, 220 + y],
                [115 + x, 185 + y], [205 + x, 185 + y], [295 + x, 185 + y]]

frame_buttons = tk.Frame(frame_tab_buttons, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
if windows:
    frame_buttons.place(x=5, y=10, width=490, height=450)
    kleur_btn_act_back = kleur_btn_geel
    kleur_btn_act_front = kleur_btn_back
else:
    frame_buttons.place(x=5, y=20, width=540, height=450)
    kleur_btn_act_back = kleur_btn_geel
    kleur_btn_act_front = kleur_btn_front

notebook_tabs = ttk.Notebook(frame_tab_buttons)
if windows:
    notebook_tabs.place(x=5, y=20, width=485, height=450)
else:
    notebook_tabs.place(x=5, y=5, width=525, height=475)

frame_tab = list()
for i in range(6):
    frame_tab.append(tk.Frame(notebook_tabs, width=520, height=500, bg=kleur_back))
    frame_tab[i].pack(fill="both", expand=1)
    notebook_tabs.add(frame_tab[i], text="Page " + str(i+1) + "      ")

    label_page_name.append(tk.Label(frame_tab[i], text="page name", relief=tk.FLAT, borderwidth=0, bg=kleur_back,
                                     fg=kleur_front, font=FONT_KNOP_NR))
    label_page_name[i].place(x=0, y=15, height=20, width=80)

    label_page_kleur.append(tk.Label(frame_tab[i], text="color off", relief=tk.FLAT, borderwidth=0, bg=kleur_back,
                                     fg=kleur_front, font=FONT_KNOP_NR))
    label_page_kleur[i].place(x=240, y=15, height=20, width=80)

    entry_page_name.append(tk.Entry(frame_tab[i], font=FONT, fg=kleur_back, bg=kleur_front))
    entry_page_name[i].insert(0, "")
    entry_page_name[i].bind("<Return>", lambda event, c=i: enter_name_page(event, c))
    entry_page_name[i].place(x=80, y=10, width=100, height=30)

    combobox_page_kleur.append(ttk.Combobox(frame_tab[i], values=kleuren))
    combobox_page_kleur[i].current(0)
    combobox_page_kleur[i].place(x=310, y=10, width=100, height=28)
    combobox_page_kleur[i].bind("<<ComboboxSelected>>", lambda event, c=i: kleur_changed(event, c, True))

    label_page_kleurkleur.append(tk.Label(frame_tab[i], bg=colors[0], anchor="w"))
    label_page_kleurkleur[i].place(x=420, y=10, width=40, height=28)

    label_mx6.append(tk.Label(frame_tab[i], text="", relief=tk.FLAT, borderwidth=0, bg=kleur_back,
                              image=mx6_image,))
    label_mx6[i].place(x=10, y=80, height=294, width=450)

    for j in range(6):  # MAX=18 MAX2=36 MAX3=72 MAX4=76 PAGE=36
        k = (i*6) + j

        label_knop_name.append(tk.Label(frame_tab[i], text=ias[k].name, relief=tk.FLAT, borderwidth=2,
                                        bg=kleur_back, fg=kleur_front, font=FONT_KNOP))
        if j > 2:
            ytekst = 35
        else:
            ytekst = 40
        label_knop_name[k].place(x=button_position[j][0], y=button_position[j][1]-ytekst, height=20, width=55)

        button_knop.append(tk.Button(frame_tab[i], image=btn_image, text=k + i, relief=tk.FLAT, borderwidth=0,
                                     bg=kleur_btn_back, command=lambda c=k: press_button(c)))
        button_knop[k].place(x=button_position[j][0], y=button_position[j][1], height=42, width=42)
        if windows:
            button_knop[k].bind("<Button-3>", on_drag_start)
            button_knop[k].bind("<B3-Motion>", on_drag_motion)
            button_knop[k].bind("<ButtonRelease-3>", on_drag_stop)
        else:
            button_knop[k].bind("<Button-2>", on_drag_start)
            button_knop[k].bind("<B2-Motion>", on_drag_motion)
            button_knop[k].bind("<ButtonRelease-2>", on_drag_stop)
        button_knop[k].index = k

        label_lcd.append(tk.Label(frame_tab[i], text=k + 1, relief=tk.FLAT, borderwidth=0, fg=kleur_btn_wit,
                                  bg=kleur_lcd, font=FONT_LCD, anchor="w"))
        if j == 2 or j == 5:
            breedte=70
        else:
            breedte=90
        label_lcd[k].place(x=lcd_position[j][0], y=lcd_position[j][1], height=35, width=breedte)


########################################################################
# TAB Buttons - Frame Normal Press
########################################################################
var_cc = []
var_ch = []
spinbox_cc = []
spinbox_ch = []
label_nr = []
label_cc = []
label_ch = []
combobox_cmd = []
combobox_special = []
var_cmd = []
var_np_steps = tk.IntVar()
var_np_group = tk.IntVar()

frame_normal_press = tk.Frame(frame_tab_buttons, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)

image_rc345x440 = tk.PhotoImage(file=path_bin + 'rc345x440.png')
label_round_np = tk.Label(frame_normal_press, bg=kleur_back, image=image_rc345x440)
label_round_np.place(x=0, y=20, width=345, height=440)

if windows:
    frame_normal_press.place(x=500, y=10, width=345, height=490)
else:
    frame_normal_press.place(x=540, y=10, width=345, height=490)

# Normal Press
label_name_normal_press = tk.Label(frame_normal_press, text="Normal Press", font=FONT_BIG, bg=kleur_back,
                                   fg=kleur_front, anchor="w")
label_name_normal_press.place(x=100, y=25, width=150, height=30)
label_ia_np = tk.Label(frame_normal_press, text="IA", font=FONT_BIG, bg=kleur_back, fg=kleur_front, anchor="w")
label_ia_np.place(x=150, y=50, width=60, height=30)

label_name_np = tk.Label(frame_normal_press, text="name", font=FONT, bg=kleur_back, fg=kleur_front,
                         anchor="w")
label_name_np.place(x=23, y=80, width=150, height=30)
entry_name_np = tk.Entry(frame_normal_press, font=FONT, fg=kleur_back, bg=kleur_front)
entry_name_np.insert(0, "")
entry_name_np.bind("<Return>", lambda event, obj=i: enter_name(event, False, 0))
entry_name_np.place(x=25, y=110, width=100, height=30)

label_steps_np = tk.Label(frame_normal_press, text="steps", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_steps_np.place(x=285, y=80, width=50, height=30)
checkbutton_steps_np = tk.Checkbutton(frame_normal_press, text="", variable=var_np_steps,
                                      command=lambda c=i: checkbutton_changed(2))
checkbutton_steps_np.place(x=290, y=115, width=19, height=16)

label_kleur_np = tk.Label(frame_normal_press, text="color on", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_kleur_np.place(x=23, y=140, width=100, height=30)
label_kleurkleur_np = tk.Label(frame_normal_press, bg=colors[0], anchor="w")
label_kleurkleur_np.place(x=145, y=165, width=40, height=25)
combobox_kleur_np = ttk.Combobox(frame_normal_press, values=kleuren)
combobox_kleur_np.current(0)
combobox_kleur_np.place(x=25, y=165, width=100, height=28)
combobox_kleur_np.bind("<<ComboboxSelected>>", lambda event, nr=knop: kleur_changed(event, nr, False))

label_cmd_np = tk.Label(frame_normal_press, text="command", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_cmd_np.place(x=23, y=195, width=150, height=25)

# group
frame_groep_group_np = tk.Frame(frame_normal_press, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_groep_group_np.place(x=20, y=425, width=300, height=20)
radiobutton_np_group0 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=0, bg=kleur_back,
                                       command=lambda c=i: group_changed(0))
radiobutton_np_group0.place(x=65, y=10, width=20, height=20, anchor="w")
radiobutton_np_group1 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=1, bg=kleur_back,
                                       command=lambda c=i: group_changed(1))
radiobutton_np_group1.place(x=135, y=10, width=20, height=20, anchor="w")
radiobutton_np_group2 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=2, bg=kleur_back,
                                       command=lambda c=i: group_changed(2))
radiobutton_np_group2.place(x=175, y=10, width=20, height=20, anchor="w")
radiobutton_np_group3 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=3, bg=kleur_back,
                                       command=lambda c=i: group_changed(3))
radiobutton_np_group3.place(x=215, y=10, width=20, height=20, anchor="w")
radiobutton_np_group4 = tk.Radiobutton(frame_groep_group_np, variable=var_np_group, value=4, bg=kleur_back,
                                       command=lambda c=i: group_changed(4))
radiobutton_np_group4.place(x=255, y=10, width=20, height=20, anchor="w")
groupx = 10
groupy = 0
if not windows:
    groupx = 0
    groupy = 2
label_group_np = tk.Label(frame_groep_group_np, text="group:", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_group_np.place(x=3, y=groupy, width=50, height=20)
label_np_group0 = tk.Label(frame_groep_group_np, text="None", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group0.place(x=90-groupx, y=groupy, width=35, height=20)
label_np_group1 = tk.Label(frame_groep_group_np, text="1", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group1.place(x=160-groupx, y=groupy, width=15, height=20)
label_np_group2 = tk.Label(frame_groep_group_np, text="2", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group2.place(x=200-groupx, y=groupy, width=15, height=20)
label_np_group3 = tk.Label(frame_groep_group_np, text="3", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group3.place(x=240-groupx, y=groupy, width=15, height=20)
label_np_group4 = tk.Label(frame_groep_group_np, text="4", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
label_np_group4.place(x=280-groupx, y=groupy, width=15, height=20)

# combobox and spinboxes Normal Press
for i in range(6):
    k = i
    comboboxcmd = ttk.Combobox(frame_normal_press)

    comboboxspecial = ttk.Combobox(frame_normal_press)
    combobox_cmd.append(comboboxcmd)
    combobox_cmd[i]['values'] = [x[0] for x in cmds_text[i]]
    combobox_cmd[i].current(0)
    combobox_cmd[i].place(x=23, y=220 + (k*32), width=160, height=28)
    combobox_cmd[i].bind("<<ComboboxSelected>>", lambda event, c=i: cmd_changed(event, c, False))

    varcc = tk.IntVar(root)
    var_cc.append(varcc)
    var_cc[i].set(1)
    spinboxcc = ttk.Spinbox(frame_normal_press, from_=0, to=127, command=lambda c=i: cch_changed(True, c, False))
    spinboxcc.config(textvariable=var_cc[i])
    spinbox_cc.append(spinboxcc)
    spinbox_cc[i].place(x=210, y=220 + (k*32), width=50, height=25)

    varch = tk.IntVar(root)
    var_ch.append(varch)
    var_ch[i].set(1)
    spinboxch = ttk.Spinbox(frame_normal_press, from_=0, to=127, command=lambda c=i: cch_changed(False, c, False))
    spinboxch.config(textvariable=var_ch[i])
    spinbox_ch.append(spinboxch)
    spinbox_ch[i].place(x=285, y=220 + (k*32), width=50, height=25)

    labelnr = tk.Label(frame_normal_press, text=str(i+1), font=FONT_BIG, bg=kleur_back, fg=kleur_front, anchor="w")
    labelcc = tk.Label(frame_normal_press, text="cc", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
    labelch = tk.Label(frame_normal_press, text="ch", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")

    label_nr.append(labelnr)
    label_nr[i].place(x=5, y=220 + (k * 32), width=20, height=30)

    label_cc.append(labelcc)
    label_cc[i].place(x=190, y=220 + (k * 32), width=20, height=25)
    label_ch.append(labelch)
    label_ch[i].place(x=265, y=220 + (k * 32), width=20, height=25)

    combobox_special.append(comboboxspecial)
    combobox_special[i]['values'] = kleuren
    combobox_special[i].current(0)
    combobox_special[i].place(x=-505, y=220 + (k*32), width=70, height=28)
    combobox_special[i].bind("<<ComboboxSelected>>", lambda event, c=i: special_changed(event, c, False))

# Copy, Paste, Clear
btn_copy = tk.PhotoImage(file=path_bin + 'copy.png')
btn_paste = tk.PhotoImage(file=path_bin + 'paste.png')
btn_clear = tk.PhotoImage(file=path_bin + 'clear.png')

button_copy_np = tk.Button(frame_normal_press, image=btn_copy, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(1, True))
button_copy_np.place(x=265, y=groupy+30, width=20, height=20)

button_paste_np = tk.Button(frame_normal_press, image=btn_paste, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(2, True))
button_paste_np.place(x=290, y=groupy+30, width=20, height=20)

button_clear_np = tk.Button(frame_normal_press, image=btn_clear, relief=tk.FLAT, borderwidth=0,
                           bg=kleur_back, command=lambda c=knop: copypasteclear_button(3, True))
button_clear_np.place(x=315, y=groupy+30, width=20, height=20)

########################################################################
# TAB Exp. Input
########################################################################
var_exp1_cc = tk.IntVar(root)
var_exp1_cc.set(1)
var_exp1_ch = tk.IntVar(root)
var_exp1_ch.set(1)
var_auto1_cc = tk.IntVar(root)
var_auto1_cc.set(1)
var_auto1_ch = tk.IntVar(root)
var_auto1_ch.set(1)
var_exp1_auto_onoff = tk.IntVar(root)
var_exp1_auto_onoff.set(0)
var_exp1_resend = tk.IntVar(root)
var_exp1_resend.set(0)
var_exp1_min_cc = tk.IntVar(root)
var_exp1_min_cc.set(0)
var_exp1_max_cc = tk.IntVar(root)
var_exp1_max_cc.set(127)

# sw2x
var_sw2x_cc = []
var_sw2x_ch = []
spinbox_sw2x_cc = []
spinbox_sw2x_ch = []
label_sw2x_cc = []
label_sw2x_ch = []
combobox_sw2x_cmd = []
var_sw2x_cmd = []

#########################
# act as Expression Pedal
frame_act_as_exp_pedal = tk.Frame(frame_tab_expinput, bg=kleur_geel, borderwidth=0, relief=tk.RIDGE)
frame_act_as_exp_pedal.place(x=520, y=15, width=280, height=450)
image_rc280x450 = tk.PhotoImage(file=path_bin + 'rc280x450.png')
label_rc_act_as_exp = tk.Label(frame_act_as_exp_pedal, bg=kleur_grijs, image=image_rc280x450)
label_rc_act_as_exp.place(x=0, y=0, width=280, height=450)

label_act_as_exp_pedal = tk.Label(frame_act_as_exp_pedal, text="Act as Expr. Pedal", bg=kleur_grijs,
                                  font=FONT_BIG, fg=kleur_front, anchor="w")
if windows:
    label_act_as_exp_pedal.place(x=45, y=5, width=220, height=30)
else:
    label_act_as_exp_pedal.place(x=35, y=5, width=220, height=30)

# expr 1 pedal as expr. pedal
frame_act_as_exp = tk.Frame(frame_act_as_exp_pedal, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
frame_act_as_exp.place(x=10, y=40, width=260, height=200)
label_act_as_exp_exp1 = tk.Label(frame_act_as_exp, text="Expr Pedal", bg=kleur_back, font=FONT, fg=kleur_front,
                                 anchor="w")
label_act_as_exp_exp1.place(x=5, y=30, width=180, height=30)
label_act_as_exp_exp1_cc = tk.Label(frame_act_as_exp, text="cc", font=FONT, bg=kleur_back, fg=kleur_front,
                                    anchor="w")
label_act_as_exp_exp1_cc.place(x=135, y=5, width=20, height=25)
spinbox_exp1_cc = ttk.Spinbox(frame_act_as_exp, from_=0, to=127)
spinbox_exp1_cc.config(textvariable=var_exp1_cc)
spinbox_exp1_cc.place(x=135, y=30, width=55, height=25)
label_act_as_exp_exp1_ch = tk.Label(frame_act_as_exp, text="ch", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_exp1_ch.place(x=195, y=5, width=20, height=25)
spinbox_exp1_ch = ttk.Spinbox(frame_act_as_exp, from_=1, to=16)
spinbox_exp1_ch.config(textvariable=var_exp1_ch)
spinbox_exp1_ch.place(x=195, y=30, width=55, height=25)
label_act_as_exp_exp1_auto_on = tk.Label(frame_act_as_exp, text="Expr 1 Auto On", bg=kleur_back, fg=kleur_front,
                                         font=FONT, anchor="w")
label_act_as_exp_exp1_auto_on.place(x=5, y=60, width=180, height=30)
spinbox_auto1_cc = ttk.Spinbox(frame_act_as_exp, from_=0, to=127)
spinbox_auto1_cc.config(textvariable=var_auto1_cc)
spinbox_auto1_cc.place(x=140, y=60, width=50, height=25)
spinbox_auto1_ch = ttk.Spinbox(frame_act_as_exp, from_=1, to=16)
spinbox_auto1_ch.config(textvariable=var_auto1_ch)
spinbox_auto1_ch.place(x=200, y=60, width=50, height=25)
checkbutton_exp1_auto = tk.Checkbutton(frame_act_as_exp, text="", variable=var_exp1_auto_onoff,
                                       command=lambda c=i: checkbutton_autoexp(1))
checkbutton_exp1_auto.place(x=110, y=65, width=19, height=16)

label_act_as_exp_minmax = tk.Label(frame_act_as_exp, text="Min/Max CC value", bg=kleur_back, font=FONT,
                                   fg=kleur_front, anchor="w")
label_act_as_exp_minmax.place(x=5, y=120, width=180, height=30)
label_act_as_exp_min_cc = tk.Label(frame_act_as_exp, text="min", font=FONT, bg=kleur_back, fg=kleur_front,
                                   anchor="w")
label_act_as_exp_min_cc.place(x=135, y=95, width=25, height=25)
spinbox_exp1_min_cc = ttk.Spinbox(frame_act_as_exp, from_=0, to=127)
spinbox_exp1_min_cc.config(textvariable=var_exp1_min_cc)
spinbox_exp1_min_cc.place(x=135, y=120, width=55, height=25)
label_act_as_exp_max_ch = tk.Label(frame_act_as_exp, text="max", bg=kleur_back, fg=kleur_front, font=FONT,
                                    anchor="w")
label_act_as_exp_max_ch.place(x=195, y=95, width=30, height=25)
spinbox_exp1_max_cc = ttk.Spinbox(frame_act_as_exp, from_=0, to=127)
spinbox_exp1_max_cc.config(textvariable=var_exp1_max_cc)
spinbox_exp1_max_cc.place(x=195, y=120, width=55, height=25)

label_act_as_exp_exp1_resend = tk.Label(frame_act_as_exp, text="Resend current value on\nScene or Pogram Change",
                                        bg=kleur_back, font=FONT, fg=kleur_front, justify="left")
if windows:
    label_act_as_exp_exp1_resend.place(x=5, y=150)
else:
    label_act_as_exp_exp1_resend.place(x=0, y=150)

checkbutton_exp1_resend = tk.Checkbutton(frame_act_as_exp, text="", variable=var_exp1_resend)
checkbutton_exp1_resend.place(x=195, y=160, width=19, height=16)


###############
# act as SW-2X
frame_act_as_sw2x = tk.Frame(frame_tab_expinput, bg=kleur_geel, borderwidth=0, relief=tk.RIDGE)
frame_act_as_sw2x.place(x=50, y=15, width=370, height=450)
image_rc370x450 = tk.PhotoImage(file=path_bin + 'rc370x450.png')
label_rc_act_as_sw2x = tk.Label(frame_act_as_sw2x, bg=kleur_grijs, image=image_rc370x450)
label_rc_act_as_sw2x.place(x=0, y=0, width=370, height=450)
label_act_as_sw2x = tk.Label(frame_act_as_sw2x, text="SW-2x", bg=kleur_grijs, font=FONT_BIG,
                             fg=kleur_front, anchor="w")
if windows:
    label_act_as_sw2x.place(x=150, y=5, width=130, height=30)
else:
    label_act_as_sw2x.place(x=140, y=5, width=130, height=30)

frame_act_as_sw2x_inner = tk.Frame(frame_act_as_sw2x, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
frame_act_as_sw2x_inner.place(x=10, y=40, width=350, height=400)

label_act_as_sw2x_LBNP = tk.Label(frame_act_as_sw2x_inner, text="Left Button - Normal Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_LBNP.place(x=5, y=0, width=180, height=30)
label_act_as_sw2x_LBLP = tk.Label(frame_act_as_sw2x_inner, text="Left Button - Long Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_LBLP.place(x=5, y=100, width=180, height=30)
label_act_as_sw2x_RBNP = tk.Label(frame_act_as_sw2x_inner, text="Right Button - Normal Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_RBNP.place(x=5, y=200, width=180, height=30)
label_act_as_sw2x_RBLP = tk.Label(frame_act_as_sw2x_inner, text="Right Button - Long Press", bg=kleur_back, font=FONT,
                                  fg=kleur_front, anchor="w")
label_act_as_sw2x_RBLP.place(x=5, y=300, width=180, height=30)

entry_name_sw2x = list()
combobox_sw2x_cmd = list()
# textboxes (entry), comboboxes and spinboxes SW-2X
for i in range(4):
    entry_name_sw2x.append(tk.Entry(frame_act_as_sw2x_inner, font=FONT, fg=kleur_back, bg=kleur_front))
    entry_name_sw2x[i].insert(0, "")
    entry_name_sw2x[i].bind("<Return>", lambda event, c=i: enter_name(event, True, c))
    entry_name_sw2x[i].place(x=5, y=30 + (100 * i), width=100, height=25)

    comboboxcmd = ttk.Combobox(frame_act_as_sw2x_inner)
    comboboxafx = ttk.Combobox(frame_act_as_sw2x_inner)
    comboboxspecial = ttk.Combobox(frame_act_as_sw2x_inner)

    combobox_sw2x_cmd.append(comboboxcmd)
    combobox_sw2x_cmd[i]['values'] = [x[0] for x in cmdssw2x] # 7 = sw2x commands
    combobox_sw2x_cmd[i].current(0)
    combobox_sw2x_cmd[i].place(x=5, y=60 + (i*100), width=160, height=28)
    combobox_sw2x_cmd[i].bind("<<ComboboxSelected>>", lambda event, c=i: cmd_changed(event, c, True))

    varcc = tk.IntVar(root)
    var_sw2x_cc.append(varcc)
    var_sw2x_cc[i].set(1)
    spinboxcc = ttk.Spinbox(frame_act_as_sw2x_inner, from_=0, to=127, command=lambda c=i: cch_changed(True, c, True))
    spinboxcc.config(textvariable=var_sw2x_cc[i])
    spinbox_sw2x_cc.append(spinboxcc)
    spinbox_sw2x_cc[i].place(x=210, y=60 + (100 * i), width=50, height=25)

    varch = tk.IntVar(root)
    var_sw2x_ch.append(varch)
    var_sw2x_ch[i].set(1)
    spinboxch = ttk.Spinbox(frame_act_as_sw2x_inner, from_=0, to=127, command=lambda c=i: cch_changed(False, c, True))
    spinboxch.config(textvariable=var_sw2x_ch[i])
    spinbox_sw2x_ch.append(spinboxch)
    spinbox_sw2x_ch[i].place(x=285, y=60 + (100 * i), width=50, height=25)

    labelcc = tk.Label(frame_act_as_sw2x_inner, text="cc", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")
    labelch = tk.Label(frame_act_as_sw2x_inner, text="ch", font=FONT, bg=kleur_back, fg=kleur_front, anchor="w")

    label_sw2x_cc.append(labelcc)
    label_sw2x_cc[i].place(x=190, y=60 + (100 * i), width=20, height=25)
    label_sw2x_ch.append(labelch)
    label_sw2x_ch[i].place(x=265, y=60 + (100 * i), width=20, height=25)


########
# pijlen
img_pijl = tk.PhotoImage(file=path_bin + 'pijl.png')
button_pijl = tk.Button(frame_tab_expinput, image=img_pijl,  relief=tk.FLAT, borderwidth=1, bg=kleur_grijs,
                        command=lambda c=i: press_exppijl())
button_pijl.place(x=445, y=180, width=50, height=30)


########################################################################
# TAB Global
########################################################################
# Global - Misc
var_global_preset_offset = tk.IntVar(root)
var_global_preset_offset.set(0)
# var_global_bank_only = tk.IntVar(root)
# var_global_bank_only.set(0)
# var_global_ignore_pc = tk.IntVar(root)
# var_global_ignore_pc.set(0)
var_global_reset_steps = tk.IntVar(root)
var_global_reset_steps.set(0)
var_global_cc_start_value = tk.IntVar(root)
var_global_cc_start_value.set(64)
var_global_midi_merge = tk.IntVar(root)
var_global_midi_merge.set(0)
var_global_long_press = tk.IntVar(root)
var_global_long_press.set(0)
var_global_reset_lcd = tk.IntVar(root)
var_global_reset_lcd.set(4)
var_global_start_page = tk.IntVar(root)
var_global_start_page.set(1)
var_global_looper_page = tk.IntVar(root)
var_global_looper_page.set(0)

# Global - Primary External Device
var_global_midi_channel = tk.IntVar(root)
var_global_midi_channel.set(1)
var_global_start_preset = tk.IntVar(root)
var_global_start_preset.set(1)
var_global_scenes_cc = tk.IntVar(root)
var_global_scenes_cc.set(34)

# Global - Expr. Calibration
var_global_exp1_min = tk.IntVar(root)
var_global_exp1_min.set(10)
var_global_exp1_max = tk.IntVar(root)
var_global_exp1_max.set(245)

if windows:
    linkerkant = 0
else:
    linkerkant = 25

# Tab Global - Misc
frame_misc = tk.Frame(frame_tab_global, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_misc.place(x=100 + linkerkant, y=100, width=280, height=300)
image_rc280x300 = tk.PhotoImage(file=path_bin + 'rc280x300.png')
label_rc_misc = tk.Label(frame_misc, bg=kleur_grijs, image=image_rc280x300)
label_rc_misc.place(x=0, y=0, width=280, height=300)

label_misc = tk.Label(frame_tab_global, text="Misc.", bg=kleur_back, fg=kleur_front, font=FONT_BIG, anchor="w")
label_misc.place(x=100 + linkerkant + 5, y=70, width=100, height=30)

label_misc_preset_offset = tk.Label(frame_misc, text="Preset Offset (-1)", bg=kleur_grijs,fg=kleur_front, font=FONT,
                                     anchor="w")
label_misc_preset_offset.place(x=10, y=10, width=120, height=30)
checkbutton_preset_offset = tk.Checkbutton(frame_misc, text="", variable=var_global_preset_offset)
checkbutton_preset_offset.place(x=140, y=15, width=19, height=16)

label_misc_reset_steps = tk.Label(frame_misc, text="Reset Steps", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_reset_steps.place(x=10, y=40, width=120, height=30)
checkbutton_reset_steps = tk.Checkbutton(frame_misc, text="", variable=var_global_reset_steps)
checkbutton_reset_steps.place(x=140, y=45, width=19, height=16)

label_misc_cc_start_value = tk.Label(frame_misc, text="CC +/- start value", bg=kleur_grijs, fg=kleur_front, font=FONT,
                                   anchor="w")
label_misc_cc_start_value.place(x=10, y=75, width=120, height=30)
spinbox_global_cc_start_value = ttk.Spinbox(frame_misc, from_=0, to=127)
spinbox_global_cc_start_value.config(textvariable=var_global_cc_start_value)
spinbox_global_cc_start_value.place(x=140, y=80, width=60, height=25)

label_misc_long_press = tk.Label(frame_misc, text="Long Press", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_long_press.place(x=10, y=115, width=120, height=30)
radiobutton_short_press = tk.Radiobutton(frame_misc, text="short", variable=var_global_long_press, value=0)
radiobutton_short_press.place(x=140, y=130, width=60, height=25, anchor="w")
radiobutton_long_press = tk.Radiobutton(frame_misc, text="long", variable=var_global_long_press, value=1)
radiobutton_long_press.place(x=210, y=130, width=60, height=25, anchor="w")

label_misc_midimerge = tk.Label(frame_misc, text="Midi Merge", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_midimerge.place(x=10, y=150, width=120, height=30)
checkbutton_midimerge = tk.Checkbutton(frame_misc, text="", variable=var_global_midi_merge)
checkbutton_midimerge.place(x=140, y=155, width=19, height=16)

label_misc_reset_lcd = tk.Label(frame_misc, text="Reset LCD", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_reset_lcd.place(x=10, y=180, width=120, height=30)
spinbox_global_reset_lcd = ttk.Spinbox(frame_misc, from_=0, to=10)
spinbox_global_reset_lcd.config(textvariable=var_global_reset_lcd)
spinbox_global_reset_lcd.place(x=140, y=185, width=50, height=25)
label_misc_nullisoff = tk.Label(frame_misc, text="(0=off)", bg=kleur_grijs, fg=kleur_front, font=FONT_KNOP_ITALIC,
                                anchor="w")
label_misc_nullisoff.place(x=195, y=180, width=50, height=30)

label_misc_start_page = tk.Label(frame_misc, text="Start Page", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_start_page.place(x=10, y=215, width=120, height=30)
spinbox_global_start_page = ttk.Spinbox(frame_misc, from_=1, to=6)
spinbox_global_start_page.config(textvariable=var_global_start_page)
spinbox_global_start_page.place(x=140, y=220, width=50, height=25)

label_misc_looper_page = tk.Label(frame_misc, text="Looper Page", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_misc_looper_page.place(x=10, y=250, width=120, height=30)
spinbox_global_looper_page = ttk.Spinbox(frame_misc, from_=0, to=6)
spinbox_global_looper_page.config(textvariable=var_global_looper_page)
spinbox_global_looper_page.place(x=140, y=255, width=50, height=25)
label_misc_nullisoff2 = tk.Label(frame_misc, text="(0=off)", bg=kleur_grijs, fg=kleur_front, font=FONT_KNOP_ITALIC,
                                anchor="w")
label_misc_nullisoff2.place(x=195, y=250, width=50, height=30)

# Tab Global - Primary External Device
frame_external_device = tk.Frame(frame_tab_global, bg=kleur_back, borderwidth=0, relief=tk.RIDGE)
frame_external_device.place(x=470 + linkerkant, y=100, width=280, height=130)
image_rc280x130 = tk.PhotoImage(file=path_bin + 'rc280x130.png')
label_rc_external_device = tk.Label(frame_external_device, bg=kleur_grijs, image=image_rc280x130)
label_rc_external_device.place(x=0, y=0, width=280, height=130)

label_external_device = tk.Label(frame_tab_global, text="Primary External Device", bg=kleur_back, fg=kleur_front,
                                 font=FONT_BIG, anchor="w")
label_external_device.place(x=470 + linkerkant + 5, y=70, width=250, height=30)

label_external_device_midi_channel = tk.Label(frame_external_device, text="Midi Channel", bg=kleur_grijs,
                                              fg=kleur_front, font=FONT, anchor="w")
label_external_device_midi_channel.place(x=10, y=10, width=120, height=30)
spinbox_global_midi_channel = ttk.Spinbox(frame_external_device, from_=1, to=16)
spinbox_global_midi_channel.config(textvariable=var_global_midi_channel)
spinbox_global_midi_channel.place(x=140, y=10, width=55, height=25)

label_external_device_start_preset = tk.Label(frame_external_device, text="Start Preset", bg=kleur_grijs,
                                              fg=kleur_front, font=FONT, anchor="w")
label_external_device_start_preset.place(x=10, y=50, width=120, height=30)
spinbox_global_start_preset = ttk.Spinbox(frame_external_device, from_=0, to=127)
spinbox_global_start_preset.config(textvariable=var_global_start_preset)
spinbox_global_start_preset.place(x=140, y=50, width=55, height=25)

label_external_device_scenes_cc = tk.Label(frame_external_device, text="Scenes CC#", bg=kleur_grijs, font=FONT,
                                           fg=kleur_front, anchor="w")
label_external_device_scenes_cc.place(x=10, y=90, width=120, height=30)
spinbox_global_scenes_cc = ttk.Spinbox(frame_external_device, from_=0, to=127)
spinbox_global_scenes_cc.config(textvariable=var_global_scenes_cc)
spinbox_global_scenes_cc.place(x=140, y=90, width=55, height=25)


# Tab Global - Expression Calibration
frame_expr_calibration = tk.Frame(frame_tab_global, bg=kleur_grijs, borderwidth=0, relief=tk.RIDGE)
frame_expr_calibration.place(x=470 + linkerkant, y=320, width=280, height=80)
image_rc280x80 = tk.PhotoImage(file=path_bin + 'rc280x80.png')
label_rc_exprcalib = tk.Label(frame_expr_calibration, bg=kleur_grijs, image=image_rc280x80)
label_rc_exprcalib.place(x=0, y=0, width=280, height=80)

label_expr_calibration = tk.Label(frame_tab_global, text="Expr. Calibration", bg=kleur_back, fg=kleur_front,
                                  font=FONT_BIG, anchor="w")
label_expr_calibration.place(x=470 + linkerkant + 5, y=290, width=220, height=30)
label_expr_min = tk.Label(frame_expr_calibration, text="min", bg=kleur_grijs, fg=kleur_front,font=FONT,  anchor="w")
label_expr_min.place(x=140, y=5, width=50, height=30)
label_expr_max = tk.Label(frame_expr_calibration, text="max", bg=kleur_grijs, fg=kleur_front, font=FONT, anchor="w")
label_expr_max.place(x=210, y=5, width=50, height=30)
label_expr_expr1_calib = tk.Label(frame_expr_calibration, text="Expr. Calibration", bg=kleur_grijs, fg=kleur_front,
                                  font=FONT, anchor="w")
label_expr_expr1_calib.place(x=10, y=35, width=120, height=30)
spinbox_global_exp1_min = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp1_min.config(textvariable=var_global_exp1_min)
spinbox_global_exp1_min.place(x=140, y=35, width=55, height=25)
spinbox_global_exp1_max = ttk.Spinbox(frame_expr_calibration, from_=0, to=255)
spinbox_global_exp1_max.config(textvariable=var_global_exp1_max)
spinbox_global_exp1_max.place(x=210, y=35, width=55, height=25)


########################################################################
# Frame Controls
########################################################################
frame_controls = tk.Frame(root, bg=kleur_back, borderwidth=2, relief=tk.RIDGE)
if windows:
    frame_controls.place(x=10, y=580, width=860, height=85)
else:
    frame_controls.place(x=16, y=605, width=910, height=85)
image_logo = tk.PhotoImage(file=path_bin + 'logo.png')
button_logo = tk.Button(frame_controls, image=image_logo, bg=kleur_back, borderwidth=0, command=lambda: press_logo())
button_logo.place(x=1, y=2)

button_load_from_computer = tk.Button(frame_controls, text="load from\n computer", bg=kleur_back, relief=tk.RIDGE,
                                      highlightbackground=kleur_btn_back, activebackground=kleur_geel,
                                      fg=kleur_btn_front, font=FONT_KNOP_MENU, borderwidth=3,
                                      command=lambda: press_load_from_computer())
button_load_from_computer.place(x=100, y=15, height=50, width=110)

button_save_to_computer = tk.Button(frame_controls, text="save to\n computer", bg=kleur_back, relief=tk.RIDGE,
                                    highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                    font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_save_to_computer())
button_save_to_computer.place(x=230, y=15, height=50, width=110)

button_load_from_mx = tk.Button(frame_controls, text="load from\n MX-6", bg=kleur_back, relief=tk.RIDGE,
                                highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_load_from_mx())
button_load_from_mx.place(x=410, y=15, height=50, width=110)

button_save_to_mx = tk.Button(frame_controls, text="send to\n MX-6", bg=kleur_back, relief=tk.RIDGE,
                              highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                              font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_save_to_mx())
button_save_to_mx.place(x=540, y=15, height=50, width=110)

button_update_firmware = tk.Button(frame_controls, text="update\n firmware", bg=kleur_back, relief=tk.RIDGE,
                                   highlightbackground=kleur_btn_back, activebackground=kleur_geel, fg=kleur_btn_front,
                                   font=FONT_KNOP_MENU, borderwidth=3, command=lambda: press_update_firmware())
if windows:
    button_update_firmware.place(x=730, y=15, height=50, width=110)
else:
    button_update_firmware.place(x=780, y=15, height=50, width=110)


########################################################################
# Frame Info
########################################################################
def close_info():
    frame_info.place(x=-1250)

def youtube(url):
    webbrowser.open(url)

def test_connection():
    tell.app('Terminal', 'do script "' + cmdavr + '"')
    tell.app('Terminal', 'activate')

frame_info = tk.Frame(root, bg=kleur_grijs, borderwidth=2, relief=tk.RIDGE)
frame_info.place(x=-1250, y=220, width=400, height=280)

message = "Editor: " + VERSION + "\n(Build: " + BUILD + ")\n\nFirmware: " + FIRMWARE
message += "\n\nLatest software and firmware on"

label_firmware = tk.Label(frame_info, text=message, bg=kleur_grijs, fg=kleur_front, font=FONT)
label_firmware.place(x=0, y=10, width=395, height=120)

button_avrdude = tk.Button(frame_info, text="Close this window", bg=kleur_front, fg=kleur_back, font=FONT,
                           command=lambda: close_info())
button_avrdude.place(x=125, y=200, height=40, width=150)

button_voes = tk.Button(frame_info, text="www.voes.be", bg=kleur_front, fg=kleur_back,
                       command=lambda: youtube('https://voes.be/downloads'))
button_voes.place(x=155, y=130, height=30, width=90)

if platform == "darwin":
    button_test_connection = tk.Button(frame_info, text="Test Connection", bg=kleur_btn_grijs, fg=kleur_back, font=FONT,
                                       command=lambda: test_connection())
    button_test_connection.place(x=125, y=250, height=20, width=150)

# load default template in bin directory
filename = path_bin + "default.hex"
read_hex(filename)
loaddata()
notebook_tabs.select(0)
check_latest_version()

root.mainloop()
